" Vim syntax file
" Language:     SiCAD (procedure language)
" Maintainer:   Zsolt Branyiczky <zbranyiczky@lmark.mgx.hu>
" Last Change:  2003 May 11
" URL:		http://lmark.mgx.hu:81/download/vim/sicad.vim

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" use SQL highlighting after 'sql' command
if version >= 600
  syn include @SQL syntax/sql.vim
else
  syn include @SQL <sfile>:p:h/sql.vim
endif
unlet b:current_syntax

" spaces are used in (auto)indents since sicad hates tabulator characters
if version >= 600
  setlocal expandtab
else
  set expandtab
endif

" ignore case
syn case ignore

" most important commands - not listed by ausku
syn keyword sicadStatement define
syn keyword sicadStatement dialog
syn keyword sicadStatement do
syn keyword sicadStatement dop contained
syn keyword sicadStatement end
syn keyword sicadStatement enddo
syn keyword sicadStatement endp
syn keyword sicadStatement erroff
syn keyword sicadStatement erron
syn keyword sicadStatement exitp
syn keyword sicadGoto      goto contained
syn keyword sicadStatement hh
syn keyword sicadStatement if
syn keyword sicadStatement in
syn keyword sicadStatement msgsup
syn keyword sicadStatement out
syn keyword sicadStatement padd
syn keyword sicadStatement parbeg
syn keyword sicadStatement parend
syn keyword sicadStatement pdoc
syn keyword sicadStatement pprot
syn keyword sicadStatement procd
syn keyword sicadStatement procn
syn keyword sicadStatement psav
syn keyword sicadStatement psel
syn keyword sicadStatement psymb
syn keyword sicadStatement ptrace
syn keyword sicadStatement ptstat
syn keyword sicadStatement set
syn keyword sicadStatement sql contained
syn keyword sicadStatement step
syn keyword sicadStatement sys
syn keyword sicadStatement ww

" functions
syn match sicadStatement "\<atan("me=e-1
syn match sicadStatement "\<atan2("me=e-1
syn match sicadStatement "\<cos("me=e-1
syn match sicadStatement "\<dist("me=e-1
syn match sicadStatement "\<exp("me=e-1
syn match sicadStatement "\<log("me=e-1
syn match sicadStatement "\<log10("me=e-1
syn match sicadStatement "\<sin("me=e-1
syn match sicadStatement "\<sqrt("me=e-1
syn match sicadStatement "\<tanh("me=e-1
syn match sicadStatement "\<x("me=e-1
syn match sicadStatement "\<y("me=e-1
syn match sicadStatement "\<v("me=e-1
syn match sicadStatement "\<x%g\=p[0-9]\{1,2}\>"me=s+1
syn match sicadStatement "\<y%g\=p[0-9]\{1,2}\>"me=s+1

" logical operators
syn match sicadOperator "\.and\."
syn match sicadOperator "\.ne\."
syn match sicadOperator "\.not\."
syn match sicadOperator "\.eq\."
syn match sicadOperator "\.ge\."
syn match sicadOperator "\.gt\."
syn match sicadOperator "\.le\."
syn match sicadOperator "\.lt\."
syn match sicadOperator "\.or\."
syn match sicadOperator "\.eqv\."
syn match sicadOperator "\.neqv\."

" variable name
syn match sicadIdentifier "%g\=[irpt][0-9]\{1,2}\>"
syn match sicadIdentifier "%g\=l[0-9]\>"
syn match sicadIdentifier "%g\=[irptl]("me=e-1
syn match sicadIdentifier "%error\>"
syn match sicadIdentifier "%nsel\>"
syn match sicadIdentifier "%nvar\>"
syn match sicadIdentifier "%scl\>"
syn match sicadIdentifier "%wd\>"
syn match sicadIdentifier "\$[irt][0-9]\{1,2}\>" contained

" label
syn match sicadLabel1 "^ *\.[a-z][a-z0-9]\{0,7} \+[^ ]"me=e-1
syn match sicadLabel1 "^ *\.[a-z][a-z0-9]\{0,7}\*"me=e-1
syn match sicadLabel2 "\<goto \.\=[a-z][a-z0-9]\{0,7}\>" contains=sicadGoto
syn match sicadLabel2 "\<goto\.[a-z][a-z0-9]\{0,7}\>" contains=sicadGoto

" boolean
syn match sicadBoolean "\.[ft]\."
" integer without sign
syn match sicadNumber "\<[0-9]\+\>"
" floating point number, with dot, optional exponent
syn match sicadFloat "\<[0-9]\+\.[0-9]*\(e[-+]\=[0-9]\+\)\=\>"
" floating point number, starting with a dot, optional exponent
syn match sicadFloat "\.[0-9]\+\(e[-+]\=[0-9]\+\)\=\>"
" floating point number, without dot, with exponent
syn match sicadFloat "\<[0-9]\+e[-+]\=[0-9]\+\>"

" without this extraString definition a ' ;  ' could stop the comment
syn region sicadString_ transparent start=+'+ end=+'+ oneline contained
" string
syn region sicadString start=+'+ end=+'+ oneline

" comments - nasty ones in sicad

" - ' *  blabla' or ' *  blabla;'
syn region sicadComment start="^ *\*" skip='\\ *$' end=";"me=e-1 end="$" contains=sicadString_
" - ' .LABEL03 *  blabla' or ' .LABEL03 *  blabla;'
syn region sicadComment start="^ *\.[a-z][a-z0-9]\{0,7} *\*" skip='\\ *$' end=";"me=e-1 end="$" contains=sicadLabel1,sicadString_
" - '; * blabla' or '; * blabla;'
syn region sicadComment start="; *\*"ms=s+1 skip='\\ *$' end=";"me=e-1 end="$" contains=sicadString_
" - comments between docbeg and docend
syn region sicadComment matchgroup=sicadStatement start="\<docbeg\>" end="\<docend\>"

" catch \ at the end of line
syn match sicadLineCont "\\ *$"

" parameters in dop block - for the time being it is not used
"syn match sicadParameter " [a-z][a-z0-9]*[=:]"me=e-1 contained
" dop block - for the time being it is not used
syn region sicadDopBlock transparent matchgroup=sicadStatement start='\<dop\>' skip='\\ *$' end=';'me=e-1 end='$' contains=ALL

" sql block - new highlighting mode is used (see syn include)
syn region sicadSqlBlock transparent matchgroup=sicadStatement start='\<sql\>' skip='\\ *$' end=';'me=e-1 end='$' contains=@SQL,sicadIdentifier,sicadLineCont

" synchronizing
syn sync clear  " clear sync used in sql.vim
syn sync match sicadSyncComment groupthere NONE "\<docend\>"
syn sync match sicadSyncComment grouphere sicadComment "\<docbeg\>"
" next line must be examined too
syn sync linecont "\\ *$"

" catch error caused by tabulator key
syn match sicadError "\t"
" catch errors caused by wrong parenthesis
"syn region sicadParen transparent start='(' end=')' contains=ALLBUT,sicadParenError
syn region sicadParen transparent start='(' skip='\\ *$' end=')' end='$' contains=ALLBUT,sicadParenError
syn match sicadParenError ')'
"syn region sicadApostrophe transparent start=+'+ end=+'+ contains=ALLBUT,sicadApostropheError
"syn match sicadApostropheError +'+
" not closed apostrophe
"syn region sicadError start=+'+ end=+$+ contains=ALLBUT,sicadApostropheError
"syn match sicadApostropheError +'[^']*$+me=s+1 contained

" SICAD keywords
syn keyword sicadStatement abst add addsim adrin aib
syn keyword sicadStatement aibzsn aidump aifgeo aisbrk alknam
syn keyword sicadStatement alknr alksav alksel alktrc alopen
syn keyword sicadStatement ansbo aractiv ararea arareao ararsfs
syn keyword sicadStatement arbuffer archeck arcomv arcont arconv
syn keyword sicadStatement arcopy arcopyo arcorr arcreate arerror
syn keyword sicadStatement areval arflfm arflop arfrast argbkey
syn keyword sicadStatement argenf argraph argrapho arinters arkompfl
syn keyword sicadStatement arlasso arlcopy arlgraph arline arlining
syn keyword sicadStatement arlisly armakea armemo arnext aroverl
syn keyword sicadStatement arovers arparkmd arpars arrefp arselect
syn keyword sicadStatement arset arstruct arunify arupdate arvector
syn keyword sicadStatement arveinfl arvflfl arvoroni ausku basis
syn keyword sicadStatement basisaus basisdar basisnr bebos befl
syn keyword sicadStatement befla befli befls beo beorta
syn keyword sicadStatement beortn bep bepan bepap bepola
syn keyword sicadStatement bepoln bepsn bepsp ber berili
syn keyword sicadStatement berk bewz bkl bli bma
syn keyword sicadStatement bmakt bmakts bmbm bmerk bmerw
syn keyword sicadStatement bmerws bminit bmk bmorth bmos
syn keyword sicadStatement bmoss bmpar bmsl bmsum bmsums
syn keyword sicadStatement bmver bmvero bmw bo bta
syn keyword sicadStatement buffer bvl bw bza bzap
syn keyword sicadStatement bzd bzgera bzorth cat catel
syn keyword sicadStatement cdbdiff ce cgmparam close closesim
syn keyword sicadStatement comgener comp comp conclose conclose coninfo
syn keyword sicadStatement conopen conread contour conwrite cop
syn keyword sicadStatement copar coparp coparp2 copel cr
syn keyword sicadStatement cs cstat cursor d da
syn keyword sicadStatement dal dasp dasps dataout dcol
syn keyword sicadStatement dd defsr del delel deskrdef
syn keyword sicadStatement df dfn dfns dfpos dfr
syn keyword sicadStatement dgd dgm dgp dgr dh
syn keyword sicadStatement diag diaus dir disbsd dkl
syn keyword sicadStatement dktx dkur dlgfix dlgfre dma
syn keyword sicadStatement dprio dr druse dsel dskinfo
syn keyword sicadStatement dsr dv dve eba ebd
syn keyword sicadStatement ebdmod ebs edbsdbin edbssnin edbsvtin
syn keyword sicadStatement edt egaus egdef egdefs eglist
syn keyword sicadStatement egloe egloenp egloes egxx eib
syn keyword sicadStatement ekur ekuradd elel elpos epg
syn keyword sicadStatement esau esauadd esek eta etap
syn keyword sicadStatement etav feparam ficonv filse fl
syn keyword sicadStatement fli flin flini flinit flins
syn keyword sicadStatement flkor fln flnli flop flout
syn keyword sicadStatement flowert flparam flraster flsy flsyd
syn keyword sicadStatement flsym flsyms flsymt fmtatt fmtdia
syn keyword sicadStatement fmtlib fpg gbadddb gbaim gbanrs
syn keyword sicadStatement gbatw gbau gbaudit gbclosp gbcredic
syn keyword sicadStatement gbcreem gbcreld gbcresdb gbcretd gbde
syn keyword sicadStatement gbdeldb gbdeldic gbdelem gbdelld gbdelref
syn keyword sicadStatement gbdeltd gbdisdb gbdisem gbdisld gbdistd
syn keyword sicadStatement gbebn gbemau gbepsv gbgetdet gbgetes
syn keyword sicadStatement gbgetmas gbgqel gbgqelr gbgqsa gbgran                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             