/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.msg;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;
import rath.msnm.msg.MimeMessage;

public class FileTransferMessage
extends MimeMessage {
    private static final Random random = new Random(System.currentTimeMillis());

    private FileTransferMessage() {
        this.setKind(3);
    }

    public static synchronized FileTransferMessage createInviteMessage(File toSend) {
        int cookie = random.nextInt(999998) + 1;
        return FileTransferMessage.createInviteMessage(toSend, cookie);
    }

    public static FileTransferMessage createInviteMessage(File toSend, int cookie) {
        if (cookie < 1) {
            throw new IllegalArgumentException("cookie must larger than 0");
        }
        if (!toSend.exists()) {
            throw new IllegalArgumentException(toSend.getName() + " not found");
        }
        FileTransferMessage msg = new FileTransferMessage();
        msg.setProperty("Application-Name", "\ud30c\uc77c \uc804\uc1a1");
        msg.setProperty("Application-GUID", "{5D3E02AB-6190-11d3-BBBB-00C04F795683}");
        msg.setProperty("Invitation-Command", "INVITE");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("Application-File", toSend.getName());
        msg.setProperty("Application-FileSize", String.valueOf(toSend.length()));
        return msg;
    }

    public static FileTransferMessage createAcceptMessage(int cookie) {
        FileTransferMessage msg = new FileTransferMessage();
        msg.setProperty("Invitation-Command", "ACCEPT");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("Launch-Application", "FALSE");
        msg.setProperty("Request-Data", "IP-Address:");
        return msg;
    }

    public static FileTransferMessage createRejectMessage(int cookie) {
        FileTransferMessage msg = new FileTransferMessage();
        msg.setProperty("Invitation-Command", "CANCEL");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("Cancel-Code", "REJECT");
        return msg;
    }

    public static FileTransferMessage createTransferMessage(int cookie) {
        return FileTransferMessage.createTransferMessage(cookie, 6891);
    }

    public static FileTransferMessage createTransferMessage(int cookie, int port) {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
            host = System.getProperty("jmsn.file.host", host);
        }
        catch (UnknownHostException e) {
            throw new Error("Can't get localhost address");
        }
        FileTransferMessage msg = new FileTransferMessage();
        msg.setProperty("Invitation-Command", "ACCEPT");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("AuthCookie", FileTransferMessage.createAuthCookie());
        msg.setProperty("Launch-Application", "FALSE");
        msg.setProperty("Request-Data", "IP-Address:");
        msg.setProperty("IP-Address", host);
        msg.setProperty("Port", String.valueOf(msg.getAvailablePort(port)));
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int getAvailablePort(int port) {
        int limit = port + 100;
        for (int i = port; i < limit; ++i) {
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(i);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
            if (socket == null) continue;
            return i;
        }
        return -1;
    }

    private static String createAuthCookie() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            sb.append((int)(Math.random() * 9.0) + 1);
        }
        return sb.toString();
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        if (this.getKind() != 3) {
            return super.getBytes();
        }
        StringBuffer buf = this.createMimeHeader("text/x-msmsgsinvite; charset=UTF-8");
        buf.append("\r\n");
        this.fillMimeProperties(buf);
        buf.append("\r\n");
        String msg = buf.toString();
        return msg.getBytes("UTF-8");
    }
}

