/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.ftp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import rath.msnm.SwitchboardSession;
import rath.msnm.ftp.ToSendFile;
import rath.msnm.ftp.VolatileDownloader;
import rath.msnm.ftp.VolatileTransferServer;
import rath.msnm.msg.FileTransferMessage;
import rath.msnm.msg.IncomingMessage;
import rath.msnm.msg.MimeMessage;

public class FileMessageProcessor {
    private static boolean _auto = true;
    private static boolean _autoReject = false;
    private SwitchboardSession session = null;
    private Hashtable toSendFileMap = new Hashtable();
    private Hashtable toReceiveFileMap = new Hashtable();

    public FileMessageProcessor(SwitchboardSession session) {
        this.session = session;
    }

    public void processMessage(IncomingMessage msg, MimeMessage mime) {
        String command = mime.getProperty("Invitation-Command");
        if (command == null || !mime.hasProperty("Invitation-Cookie")) {
            return;
        }
        boolean isLastInTransaction = mime.hasProperty("AuthCookie");
        try {
            if (command.equals("INVITE")) {
                this.processInvite(mime);
            } else if (command.equals("ACCEPT")) {
                if (!isLastInTransaction) {
                    this.processAccept(mime);
                } else {
                    this.processDownload(mime);
                }
            } else if (command.equals("CANCEL")) {
                this.processCancel(mime);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("MIME message violation: FileTransfer(" + e + ")");
        }
    }

    protected void processInvite(MimeMessage mime) throws IOException {
        String cookie = mime.getProperty("Invitation-Cookie");
        int cookieInt = Integer.parseInt(cookie);
        if (_autoReject) {
            this.session.rejectFileReceive(cookieInt);
            return;
        }
        String filename = mime.getProperty("Application-File");
        String strFileSize = null;
        strFileSize = mime.getProperty("Application-FileSize");
        if (strFileSize == null) {
            return;
        }
        int filesize = Integer.parseInt(strFileSize);
        if (_auto) {
            this.session.acceptFileReceive(cookieInt, new File(System.getProperty("msnm.file.download.dir", "."), filename));
            return;
        }
        this.session.msn.fireFilePostedEvent(this.session, cookieInt, filename, filesize);
    }

    public static void setAutoReceive(boolean auto) {
        _auto = auto;
    }

    public static void setAutoReject(boolean autoReject) {
        _autoReject = autoReject;
    }

    public static boolean isAutoReceive() {
        return _auto;
    }

    public void registerSend(ToSendFile file) {
        this.toSendFileMap.put(file.getCookie(), file);
    }

    public void registerReceive(int cookie, File file) {
        this.toReceiveFileMap.put(String.valueOf(cookie), file);
    }

    public void processAccept(MimeMessage mime) throws FileNotFoundException, IOException {
        String cookie = mime.getProperty("Invitation-Cookie");
        ToSendFile toSend = (ToSendFile)this.toSendFileMap.remove(cookie);
        if (toSend != null) {
            int cookieInt = Integer.parseInt(cookie);
            FileTransferMessage msg = FileTransferMessage.createTransferMessage(cookieInt);
            VolatileTransferServer vts = VolatileTransferServer.getInstance(this.session.msn, toSend, msg);
            vts.cookie = cookie;
            this.session.sendMessage(msg);
            this.session.msn.fireFileSendAcceptedEvent(this.session, cookieInt);
            vts.start();
        }
    }

    public void processCancel(MimeMessage mime) {
        String cookie = mime.getProperty("Invitation-Cookie");
        ToSendFile toSend = (ToSendFile)this.toSendFileMap.remove(cookie);
        if (toSend != null) {
            int cookieInt = Integer.parseInt(cookie);
            this.session.msn.fireFileSendRejectedEvent(this.session, cookieInt, mime.getProperty("Cancel-Code"));
        }
    }

    public void processDownload(MimeMessage mime) {
        String cookie = mime.getProperty("Invitation-Cookie");
        File toReceive = (File)this.toReceiveFileMap.remove(cookie);
        if (toReceive != null) {
            VolatileDownloader vd = VolatileDownloader.getInstance(this.session.msn, toReceive, mime);
            vd.cookie = cookie;
            vd.start();
        }
    }
}

