/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.adapters;

import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.adapters.VlAdapter;
import org.videolan.vlma.common.exceptions.AdapterParameterDoesNotExistException;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlSatellite;

public class VlDVBS
extends VlAdapter {
    private VlSatellite satellite;

    public String getType() {
        return "DVB-S";
    }

    public VlSatellite getSatellite() {
        return this.satellite;
    }

    public void setSatellite(VlSatellite satellite) {
        this.satellite = satellite;
    }

    public void setParameter(String parameter, String value, IVlData data) throws AdapterParameterDoesNotExistException {
        if (parameter.equalsIgnoreCase("satellite")) {
            this.setSatellite(null);
            for (VlSatellite s : data.getSatellites()) {
                if (!s.getName().equalsIgnoreCase(value)) continue;
                this.setSatellite(s);
                break;
            }
        } else {
            throw new AdapterParameterDoesNotExistException("Paramater " + parameter + " doesn't exist among adapters whose type is " + this.getClass().getSimpleName());
        }
    }

    public int hashType() {
        return VlSatChannel.class.hashCode() + this.satellite.hashCode();
    }

    public boolean canRead(IVlMedia media) {
        return media.getClass().equals(VlSatChannel.class) && this.satellite.getCoverages().contains(((VlSatChannel)media).getCoverage());
    }
}

