/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.graph.FetchSource;

public class FetchSourceList {
    private HashMap map;
    private ArrayList list;
    private int defCount;
    private boolean persistent;
    private boolean openerLocked;
    private boolean opened;
    private RrdOpener rrdOpener;

    public FetchSourceList(int n) {
        this(n, false, false);
    }

    public FetchSourceList(int n, boolean bl, boolean bl2) {
        this.map = new HashMap(n);
        this.list = new ArrayList(n);
        this.opened = false;
        this.persistent = bl;
        this.openerLocked = bl2;
    }

    public FetchSourceList(int n, boolean bl, boolean bl2, RrdOpener rrdOpener) {
        this(n, bl, bl2);
        this.rrdOpener = rrdOpener;
    }

    public void setRrdOpener(RrdOpener rrdOpener) {
        if (!this.persistent && !this.openerLocked) {
            this.rrdOpener = rrdOpener;
        }
    }

    public RrdOpener getRrdOpener() {
        return this.rrdOpener;
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    public void lockOpener() {
        this.openerLocked = true;
    }

    public void unlockOpener() {
        this.openerLocked = false;
    }

    public int size() {
        return this.list.size();
    }

    public int defCount() {
        return this.defCount;
    }

    public void openAll() throws RrdException, IOException {
        if (this.opened) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).openRrd();
        }
        this.opened = true;
    }

    public void releaseAll() throws RrdException, IOException {
        if (this.persistent) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).release();
        }
        this.opened = false;
    }

    public void clear() throws RrdException, IOException {
        this.persistent = false;
        this.releaseAll();
        this.map.clear();
        this.list.clear();
    }

    public long getLastUpdateTime() throws RrdException, IOException {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.size(); ++i) {
            RrdDb rrdDb = this.get(i).getRrd();
            l2 = rrdDb.getLastUpdateTime();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public void add(String string, String string2, String string3, String string4, String string5) throws RrdException {
        if (this.map.containsKey(string2)) {
            FetchSource fetchSource = (FetchSource)this.map.get(string2);
            fetchSource.addSource(string4, string3, string);
        } else {
            FetchSource fetchSource = new FetchSource(string2, string4, string3, string, string5, this);
            this.map.put(string2, fetchSource);
            this.list.add(fetchSource);
        }
        ++this.defCount;
    }

    public void add(String string, String string2, String string3, String string4) throws RrdException {
        if (this.map.containsKey(string2)) {
            FetchSource fetchSource = (FetchSource)this.map.get(string2);
            fetchSource.addSource(string4, string3, string);
        } else {
            FetchSource fetchSource = new FetchSource(string2, string4, string3, string, this);
            this.map.put(string2, fetchSource);
            this.list.add(fetchSource);
        }
        ++this.defCount;
    }

    protected FetchSource get(int n) {
        return (FetchSource)this.list.get(n);
    }
}

