/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.medias;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlFilesChannel;

public class MediasProgramRemoveFormController extends SimpleFormController {

    private IVlData data;
    
    private String successViewMedias;
    
    private String successViewFiles;
    
    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }
    
    public String getSuccessViewMedias() {
        return successViewMedias;
    }
    
    public void setSuccessViewMedias(String successViewMedias) {
        this.successViewMedias = successViewMedias;
    }
    
    public String getSuccessViewFiles() {
        return successViewFiles;
    }    
    
    public void setSuccessViewFiles(String successViewFiles) {
        this.successViewFiles = successViewFiles;
    }
    public ModelAndView onSubmit(Object command) throws ServletException,
            UnknownHostException {
        int mediaId = ((MediasProgramAdd) command).getMediaId();
        data.updateMediaProgram(mediaId, null);
        IVlMedia media = data.getMedia(mediaId);
        
        //Determine the success view with the media class
        String successView = new String();
        if (media.getClass() == VlFilesChannel.class) {
            successView = getSuccessViewFiles();
        }
        else {
            successView = getSuccessViewMedias();
        }
        
        data.giveOrders();
        
        return new ModelAndView(new RedirectView(successView));
    }

    protected Object formBackingObject(HttpServletRequest request)
            throws ServletException {
        MediasProgramAdd mediasProgramAdd = new MediasProgramAdd();
        int media = Integer.parseInt(request.getParameter("media"));
        mediasProgramAdd.setMediaId(media);
        mediasProgramAdd.setData(data);
        return mediasProgramAdd;
    }

    @Override
    protected ModelAndView showForm(HttpServletRequest arg0,
            HttpServletResponse arg1, BindException arg2, Map arg3)
            throws Exception {
        int mediaId = Integer.parseInt(arg0.getParameter("media"));
        Map<String, Object> m = new HashMap<String, Object>();
        m.put("media", data.getMedia(mediaId));
        return super.showForm(arg0, arg1, arg2, m);
    }

}
