/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.medias;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlTNTChannel;

public class MediasListFormController implements Controller {

    public ModelAndView handleRequest(HttpServletRequest arg0,
            HttpServletResponse arg1) throws Exception {
        Map<String, Object> params = new HashMap<String, Object>();
        String filter = arg0.getParameter("filter");

        // Pour les chaînes sattelites
        List<VlSatChannel> channelsSat = new ArrayList<VlSatChannel>();
        for (IVlMedia media : data.getMedias()) {
            if (media.getClass().equals(VlSatChannel.class)) {
                VlSatChannel channelSat = (VlSatChannel) media;
                String category = channelSat.getCategory();
                if ((!category.contains("CRYPT")) || (filter == "all")) {
                    channelsSat.add(channelSat);
                }
            }
        }

        // Pour les chaînes TNT
        List<VlTNTChannel> channelsTNT = new ArrayList<VlTNTChannel>();
        for (IVlMedia media : data.getMedias()) {
            if (media.getClass().equals(VlTNTChannel.class)) {
                VlTNTChannel channelTNT = (VlTNTChannel) media;
                channelsTNT.add(channelTNT);
            }
        }

        params.put("channelsSat", channelsSat);
        params.put("channelsTNT", channelsTNT);
        params.put("shortList", filter == "all");
        return new ModelAndView("medias/mediaslist", params);
    }

    private IVlData data;

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

}
