/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.bdplus;

import org.bluray.bdplus.StatusListener;
import org.videolan.BDJListeners;
import org.videolan.Libbluray;
import org.videolan.Logger;

public class Status {
    private static final Object instanceLock = new Object();
    private static Status instance = null;
    private BDJListeners listeners = new BDJListeners();
    private static final Logger logger = Logger.getLogger(Status.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getInstance() {
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new Status();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Status s;
        Object object = instanceLock;
        synchronized (object) {
            s = instance;
            instance = null;
        }
        if (s != null) {
            s.listeners.clear();
        }
    }

    public void addListener(StatusListener listener) {
        this.listeners.add(listener);
    }

    public int get() {
        int val = Libbluray.readPSR(104);
        logger.trace("get(): 0x" + Integer.toHexString(val));
        return val;
    }

    public void removeListener(StatusListener listener) {
        this.listeners.remove(listener);
    }

    public void send(int data) {
        logger.trace("send(0x" + Integer.toHexString(data) + ")");
        Libbluray.writePSR(103, data);
    }

    public void set(int data) {
        logger.trace("set(0x" + Integer.toHexString(data) + ")");
        Libbluray.writePSR(104, data);
    }

    public void receive(int data) {
        logger.trace("receive(0x" + Integer.toHexString(data) + ")");
        this.listeners.putPSR102Callback(data);
    }
}

