/*****************************************************************************
 * drmstables.h : AES/Rijndael block cipher and miscellaneous tables
 *****************************************************************************
 * Copyright (C) 2004 the VideoLAN team
 * $Id: drmstables.h 11664 2005-07-09 06:17:09Z courmisch $
 *
 * Author: Jon Lech Johansen <jon-vl@nanocrew.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#define AES_ROR( x, n ) (((x) << (32-(n))) | ((x) >> (n)))

#define AES_XOR_ROR( p_table, p_tmp ) \
    ( p_table[ (p_tmp[ t > 2 ? t - 3 : t + 1 ] >> 24) & 0xFF ] \
     ^ AES_ROR( p_table[ (p_tmp[ t > 1 ? t - 2 : t + 2 ] >> 16) & 0xFF ], 8 ) \
     ^ AES_ROR( p_table[ (p_tmp[ t > 0 ? t - 1 : t + 3 ] >> 8) & 0xFF ], 16 ) \
     ^ AES_ROR( p_table[ p_tmp[ t ] & 0xFF ], 24 ) )

#define AES_KEY_COUNT 10

static uint32_t const p_aes_table[ AES_KEY_COUNT ] =
{
    0x00000001, 0x00000002, 0x00000004, 0x00000008, 0x00000010, 0x00000020,
    0x00000040, 0x00000080, 0x0000001b, 0x00000036
};

static uint32_t const p_aes_encrypt[ 256 ] =
{
    0x63000000, 0x7c000000, 0x77000000, 0x7b000000, 0xf2000000, 0x6b000000,
    0x6f000000, 0xc5000000, 0x30000000, 0x01000000, 0x67000000, 0x2b000000,
    0xfe000000, 0xd7000000, 0xab000000, 0x76000000, 0xca000000, 0x82000000,
    0xc9000000, 0x7d000000, 0xfa000000, 0x59000000, 0x47000000, 0xf0000000,
    0xad000000, 0xd4000000, 0xa2000000, 0xaf000000, 0x9c000000, 0xa4000000,
    0x72000000, 0xc0000000, 0xb7000000, 0xfd000000, 0x93000000, 0x26000000,
    0x36000000, 0x3f000000, 0xf7000000, 0xcc000000, 0x34000000, 0xa5000000,
    0xe5000000, 0xf1000000, 0x71000000, 0xd8000000, 0x31000000, 0x15000000,
    0x04000000, 0xc7000000, 0x23000000, 0xc3000000, 0x18000000, 0x96000000,
    0x05000000, 0x9a000000, 0x07000000, 0x12000000, 0x80000000, 0xe2000000,
    0xeb000000, 0x27000000, 0xb2000000, 0x75000000, 0x09000000, 0x83000000,
    0x2c000000, 0x1a000000, 0x1b000000, 0x6e000000, 0x5a000000, 0xa0000000,
    0x52000000, 0x3b000000, 0xd6000000, 0xb3000000, 0x29000000, 0xe3000000,
    0x2f000000, 0x84000000, 0x53000000, 0xd1000000, 0x00000000, 0xed000000,
    0x20000000, 0xfc000000, 0xb1000000, 0x5b000000, 0x6a000000, 0xcb000000,
    0xbe000000, 0x39000000, 0x4a000000, 0x4c000000, 0x58000000, 0xcf000000,
    0xd0000000, 0xef000000, 0xaa000000, 0xfb000000, 0x43000000, 0x4d000000,
    0x33000000, 0x85000000, 0x45000000, 0xf9000000, 0x02000000, 0x7f000000,
    0x50000000, 0x3c000000, 0x9f000000, 0xa8000000, 0x51000000, 0xa3000000,
    0x40000000, 0x8f000000, 0x92000000, 0x9d000000, 0x38000000, 0xf5000000,
    0xbc000000, 0xb6000000, 0xda000000, 0x21000000, 0x10000000, 0xff000000,
    0xf3000000, 0xd2000000, 0xcd000000, 0x0c000000, 0x13000000, 0xec000000,
    0x5f000000, 0x97000000, 0x44000000, 0x17000000, 0xc4000000, 0xa7000000,
    0x7e000000, 0x3d000000, 0x64000000, 0x5d000000, 0x19000000, 0x73000000,
    0x60000000, 0x81000000, 0x4f000000, 0xdc000000, 0x22000000, 0x2a000000,
    0x90000000, 0x88000000, 0x46000000, 0xee000000, 0xb8000000, 0x14000000,
    0xde000000, 0x5e000000, 0x0b000000, 0xdb000000, 0xe0000000, 0x32000000,
    0x3a000000, 0x0a000000, 0x49000000, 0x06000000, 0x24000000, 0x5c000000,
    0xc2000000, 0xd3000000, 0xac000000, 0x62000000, 0x91000000, 0x95000000,
    0xe4000000, 0x79000000, 0xe7000000, 0xc8000000, 0x37000000, 0x6d000000,
    0x8d000000, 0xd5000000, 0x4e000000, 0xa9000000, 0x6c000000, 0x56000000,
    0xf4000000, 0xea000000, 0x65000000, 0x7a000000, 0xae000000, 0x08000000,
    0xba000000, 0x78000000, 0x25000000, 0x2e000000, 0x1c000000, 0xa6000000,
    0xb4000000, 0xc6000000, 0xe8000000, 0xdd000000, 0x74000000, 0x1f000000,
    0x4b000000, 0xbd000000, 0x8b000000, 0x8a000000, 0x70000000, 0x3e000000,
    0xb5000000, 0x66000000, 0x48000000, 0x03000000, 0xf6000000, 0x0e000000,
    0x61000000, 0x35000000, 0x57000000, 0xb9000000, 0x86000000, 0xc1000000,
    0x1d000000, 0x9e000000, 0xe1000000, 0xf8000000, 0x98000000, 0x11000000,
    0x69000000, 0xd9000000, 0x8e000000, 0x94000000, 0x9b000000, 0x1e000000,
    0x87000000, 0xe9000000, 0xce000000, 0x55000000, 0x28000000, 0xdf000000,
    0x8c000000, 0xa1000000, 0x89000000, 0x0d000000, 0xbf000000, 0xe6000000,
    0x42000000, 0x68000000, 0x41000000, 0x99000000, 0x2d000000, 0x0f000000,
    0xb0000000, 0x54000000, 0xbb000000, 0x16000000
};

static uint32_t const p_aes_itable[ 256 ] =
{
    0x5150a7f4, 0x7e536541, 0x1ac3a417, 0x3a965e27, 0x3bcb6bab, 0x1ff1459d,
    0xacab58fa, 0x4b9303e3, 0x2055fa30, 0xadf66d76, 0x889176cc, 0xf5254c02,
    0x4ffcd7e5, 0xc5d7cb2a, 0x26804435, 0xb58fa362, 0xde495ab1, 0x25671bba,
    0x45980eea, 0x5de1c0fe, 0xc302752f, 0x8112f04c, 0x8da39746, 0x6bc6f9d3,
    0x03e75f8f, 0x15959c92, 0xbfeb7a6d, 0x95da5952, 0xd42d83be, 0x58d32174,
    0x492969e0, 0x8e44c8c9, 0x756a89c2, 0xf478798e, 0x996b3e58, 0x27dd71b9,
    0xbeb64fe1, 0xf017ad88, 0xc966ac20, 0x7db43ace, 0x63184adf, 0xe582311a,
    0x97603351, 0x62457f53, 0xb1e07764, 0xbb84ae6b, 0xfe1ca081, 0xf9942b08,
    0x70586848, 0x8f19fd45, 0x94876cde, 0x52b7f87b, 0xab23d373, 0x72e2024b,
    0xe3578f1f, 0x662aab55, 0xb20728eb, 0x2f03c2b5, 0x869a7bc5, 0xd3a50837,
    0x30f28728, 0x23b2a5bf, 0x02ba6a03, 0xed5c8216, 0x8a2b1ccf, 0xa792b479,
    0xf3f0f207, 0x4ea1e269, 0x65cdf4da, 0x06d5be05, 0xd11f6234, 0xc48afea6,
    0x349d532e, 0xa2a055f3, 0x0532e18a, 0xa475ebf6, 0x0b39ec83, 0x40aaef60,
    0x5e069f71, 0xbd51106e, 0x3ef98a21, 0x963d06dd, 0xddae053e, 0x4d46bde6,
    0x91b58d54, 0x71055dc4, 0x046fd406, 0x60ff1550, 0x1924fb98, 0xd697e9bd,
    0x89cc4340, 0x67779ed9, 0xb0bd42e8, 0x07888b89, 0xe7385b19, 0x79dbeec8,
    0xa1470a7c, 0x7ce90f42, 0xf8c91e84, 0x00000000, 0x09838680, 0x3248ed2b,
    0x1eac7011, 0x6c4e725a, 0xfdfbff0e, 0x0f563885, 0x3d1ed5ae, 0x3627392d,
    0x0a64d90f, 0x6821a65c, 0x9bd1545b, 0x243a2e36, 0x0cb1670a, 0x930fe757,
    0xb4d296ee, 0x1b9e919b, 0x804fc5c0, 0x61a220dc, 0x5a694b77, 0x1c161a12,
    0xe20aba93, 0xc0e52aa0, 0x3c43e022, 0x121d171b, 0x0e0b0d09, 0xf2adc78b,
    0x2db9a8b6, 0x14c8a91e, 0x578519f1, 0xaf4c0775, 0xeebbdd99, 0xa3fd607f,
    0xf79f2601, 0x5cbcf572, 0x44c53b66, 0x5b347efb, 0x8b762943, 0xcbdcc623,
    0xb668fced, 0xb863f1e4, 0xd7cadc31, 0x42108563, 0x13402297, 0x842011c6,
    0x857d244a, 0xd2f83dbb, 0xae1132f9, 0xc76da129, 0x1d4b2f9e, 0xdcf330b2,
    0x0dec5286, 0x77d0e3c1, 0x2b6c16b3, 0xa999b970, 0x11fa4894, 0x472264e9,
    0xa8c48cfc, 0xa01a3ff0, 0x56d82c7d, 0x22ef9033, 0x87c74e49, 0xd9c1d138,
    0x8cfea2ca, 0x98360bd4, 0xa6cf81f5, 0xa528de7a, 0xda268eb7, 0x3fa4bfad,
    0x2ce49d3a, 0x500d9278, 0x6a9bcc5f, 0x5462467e, 0xf6c2138d, 0x90e8b8d8,
    0x2e5ef739, 0x82f5afc3, 0x9fbe805d, 0x697c93d0, 0x6fa92dd5, 0xcfb31225,
    0xc83b99ac, 0x10a77d18, 0xe86e639c, 0xdb7bbb3b, 0xcd097826, 0x6ef41859,
    0xec01b79a, 0x83a89a4f, 0xe6656e95, 0xaa7ee6ff, 0x2108cfbc, 0xefe6e815,
    0xbad99be7, 0x4ace366f, 0xead4099f, 0x29d67cb0, 0x31afb2a4, 0x2a31233f,
    0xc63094a5, 0x35c066a2, 0x7437bc4e, 0xfca6ca82, 0xe0b0d090, 0x3315d8a7,
    0xf14a9804, 0x41f7daec, 0x7f0e50cd, 0x172ff691, 0x768dd64d, 0x434db0ef,
    0xcc544daa, 0xe4df0496, 0x9ee3b5d1, 0x4c1b886a, 0xc1b81f2c, 0x467f5165,
    0x9d04ea5e, 0x015d358c, 0xfa737487, 0xfb2e410b, 0xb35a1d67, 0x9252d2db,
    0xe9335610, 0x6d1347d6, 0x9a8c61d7, 0x377a0ca1, 0x598e14f8, 0xeb893c13,
    0xceee27a9, 0xb735c961, 0xe1ede51c, 0x7a3cb147, 0x9c59dfd2, 0x553f73f2,
    0x1879ce14, 0x73bf37c7, 0x53eacdf7, 0x5f5baafd, 0xdf146f3d, 0x7886db44,
    0xca81f3af, 0xb93ec468, 0x382c3424, 0xc25f40a3, 0x1672c31d, 0xbc0c25e2,
    0x288b493c, 0xff41950d, 0x397101a8, 0x08deb30c, 0xd89ce4b4, 0x6490c156,
    0x7b6184cb, 0xd570b632, 0x48745c6c, 0xd04257b8
};

static uint32_t const p_aes_decrypt[ 256 ] =
{
    0x52000000, 0x09000000, 0x6a000000, 0xd5000000, 0x30000000, 0x36000000,
    0xa5000000, 0x38000000, 0xbf000000, 0x40000000, 0xa3000000, 0x9e000000,
    0x81000000, 0xf3000000, 0xd7000000, 0xfb000000, 0x7c000000, 0xe3000000,
    0x39000000, 0x82000000, 0x9b000000, 0x2f000000, 0xff000000, 0x87000000,
    0x34000000, 0x8e000000, 0x43000000, 0x44000000, 0xc4000000, 0xde000000,
    0xe9000000, 0xcb000000, 0x54000000, 0x7b000000, 0x94000000, 0x32000000,
    0xa6000000, 0xc2000000, 0x23000000, 0x3d000000, 0xee000000, 0x4c000000,
    0x95000000, 0x0b000000, 0x42000000, 0xfa000000, 0xc3000000, 0x4e000000,
    0x08000000, 0x2e000000, 0xa1000000, 0x66000000, 0x28000000, 0xd9000000,
    0x24000000, 0xb2000000, 0x76000000, 0x5b000000, 0xa2000000, 0x49000000,
    0x6d000000, 0x8b000000, 0xd1000000, 0x25000000, 0x72000000, 0xf8000000,
    0xf6000000, 0x64000000, 0x86000000, 0x68000000, 0x98000000, 0x16000000,
    0xd4000000, 0xa4000000, 0x5c000000, 0xcc000000, 0x5d000000, 0x65000000,
    0xb6000000, 0x92000000, 0x6c000000, 0x70000000, 0x48000000, 0x50000000,
    0xfd000000, 0xed000000, 0xb9000000, 0xda000000, 0x5e000000, 0x15000000,
    0x46000000, 0x57000000, 0xa7000000, 0x8d000000, 0x9d000000, 0x84000000,
    0x90000000, 0xd8000000, 0xab000000, 0x00000000, 0x8c000000, 0xbc000000,
    0xd3000000, 0x0a000000, 0xf7000000, 0xe4000000, 0x58000000, 0x05000000,
    0xb8000000, 0xb3000000, 0x45000000, 0x06000000, 0xd0000000, 0x2c000000,
    0x1e000000, 0x8f000000, 0xca000000, 0x3f000000, 0x0f000000, 0x02000000,
    0xc1000000, 0xaf000000, 0xbd000000, 0x03000000, 0x01000000, 0x13000000,
    0x8a000000, 0x6b000000, 0x3a000000, 0x91000000, 0x11000000, 0x41000000,
    0x4f000000, 0x67000000, 0xdc000000, 0xea000000, 0x97000000, 0xf2000000,
    0xcf000000, 0xce000000, 0xf0000000, 0xb4000000, 0xe6000000, 0x73000000,
    0x96000000, 0xac000000, 0x74000000, 0x22000000, 0xe7000000, 0xad000000,
    0x35000000, 0x85000000, 0xe2000000, 0xf9000000, 0x37000000, 0xe8000000,
    0x1c000000, 0x75000000, 0xdf000000, 0x6e000000, 0x47000000, 0xf1000000,
    0x1a000000, 0x71000000, 0x1d000000, 0x29000000, 0xc5000000, 0x89000000,
    0x6f000000, 0xb7000000, 0x62000000, 0x0e000000, 0xaa000000, 0x18000000,
    0xbe000000, 0x1b000000, 0xfc000000, 0x56000000, 0x3e000000, 0x4b000000,
    0xc6000000, 0xd2000000, 0x79000000, 0x20000000, 0x9a000000, 0xdb000000,
    0xc0000000, 0xfe000000, 0x78000000, 0xcd000000, 0x5a000000, 0xf4000000,
    0x1f000000, 0xdd000000, 0xa8000000, 0x33000000, 0x88000000, 0x07000000,
    0xc7000000, 0x31000000, 0xb1000000, 0x12000000, 0x10000000, 0x59000000,
    0x27000000, 0x80000000, 0xec000000, 0x5f000000, 0x60000000, 0x51000000,
    0x7f000000, 0xa9000000, 0x19000000, 0xb5000000, 0x4a000000, 0x0d000000,
    0x2d000000, 0xe5000000, 0x7a000000, 0x9f000000, 0x93000000, 0xc9000000,
    0x9c000000, 0xef000000, 0xa0000000, 0xe0000000, 0x3b000000, 0x4d000000,
    0xae000000, 0x2a000000, 0xf5000000, 0xb0000000, 0xc8000000, 0xeb000000,
    0xbb000000, 0x3c000000, 0x83000000, 0x53000000, 0x99000000, 0x61000000,
    0x17000000, 0x2b000000, 0x04000000, 0x7e000000, 0xba000000, 0x77000000,
    0xd6000000, 0x26000000, 0xe1000000, 0x69000000, 0x14000000, 0x63000000,
    0x55000000, 0x21000000, 0x0c000000, 0x7d000000
};

static uint16_t const p_shuffle_xor[ 256 ] =
{
    0x00d1, 0x0315, 0x1a32, 0x19ec, 0x1bbb, 0x1d6f, 0x14fe, 0x0e9e,
    0x029e, 0x1b8f, 0x0b70, 0x033a, 0x188e, 0x1d18, 0x0bd8, 0x0edb,
    0x0c64, 0x1c2b, 0x149c, 0x047b, 0x1064, 0x1c7c, 0x118d, 0x1355,
    0x0ae5, 0x0f18, 0x016f, 0x17d6, 0x1595, 0x0084, 0x0616, 0x1ccd,
    0x1d94, 0x0618, 0x182c, 0x195b, 0x196d, 0x0394, 0x07db, 0x0287,
    0x1636, 0x0b81, 0x1519, 0x0df9, 0x1ba3, 0x1cc3, 0x0ee2, 0x1434,
    0x1457, 0x0ced, 0x0f7d, 0x0d7b, 0x0b9e, 0x0d13, 0x13d7, 0x18d0,
    0x1259, 0x1977, 0x0606, 0x1e80, 0x05f2, 0x06b8, 0x1f07, 0x1365,
    0x0334, 0x0e30, 0x195f, 0x15f1, 0x058e, 0x0aa8, 0x045a, 0x0465,
    0x0b3e, 0x071e, 0x0a36, 0x105c, 0x01ac, 0x1a1e, 0x04e4, 0x056b,
    0x12bf, 0x0da2, 0x0b41, 0x0eaf, 0x034f, 0x0181, 0x04e2, 0x002b,
    0x12e6, 0x01be, 0x10e8, 0x128f, 0x0eb2, 0x1369, 0x05be, 0x1a59,
    0x117e, 0x047c, 0x1e86, 0x056a, 0x0da7, 0x0d61, 0x03fc, 0x1e6e,
    0x1d0c, 0x1e6d, 0x14bf, 0x0c50, 0x063a, 0x1b47, 0x17ae, 0x1321,
    0x041b, 0x0a24, 0x0d4d, 0x1f2b, 0x1cb6, 0x1bed, 0x1549, 0x03a7,
    0x0254, 0x006c, 0x0c9e, 0x0f73, 0x006c, 0x0008, 0x11f9, 0x0dd5,
    0x0bcf, 0x0af9, 0x1dfe, 0x0341, 0x0e49, 0x0d38, 0x17cb, 0x1513,
    0x0e96, 0x00ed, 0x0556, 0x1b28, 0x100c, 0x19d8, 0x14fa, 0x028c,
    0x1c60, 0x1232, 0x13d3, 0x0d00, 0x1534, 0x192c, 0x14b5, 0x1cf2,
    0x0504, 0x0b5b, 0x1ecf, 0x0423, 0x183b, 0x06b0, 0x169e, 0x1066,
    0x04cb, 0x08a2, 0x1b4a, 0x1254, 0x198d, 0x1044, 0x0236, 0x1bd8,
    0x18a1, 0x03ff, 0x1a0d, 0x0277, 0x0c2d, 0x17c9, 0x007c, 0x116e,
    0x048a, 0x1eaf, 0x0922, 0x0c45, 0x0766, 0x1e5f, 0x1a28, 0x0120,
    0x1c15, 0x034c, 0x0508, 0x0e73, 0x0879, 0x0441, 0x09ae, 0x132f,
    0x14fe, 0x0413, 0x0a9d, 0x1727, 0x01d7, 0x1a2b, 0x0474, 0x18f0,
    0x1f3b, 0x14f5, 0x1071, 0x0895, 0x1071, 0x18ff, 0x18e3, 0x0eb9,
    0x0ba9, 0x0961, 0x1599, 0x019e, 0x1d12, 0x1baa, 0x1e94, 0x1921,
    0x14dc, 0x124e, 0x0a25, 0x03ab, 0x1cc0, 0x1ebb, 0x0b4b, 0x16e5,
    0x11ea, 0x0d78, 0x1bb3, 0x1ba7, 0x1510, 0x1b7b, 0x0c64, 0x1995,
    0x1a58, 0x1651, 0x1964, 0x147a, 0x15f2, 0x11bb, 0x1654, 0x166e,
    0x0ea9, 0x1de1, 0x1443, 0x13c5, 0x00e1, 0x0b2f, 0x0b6f, 0x0a37,
    0x18ac, 0x08e6, 0x06f0, 0x136e, 0x0853, 0x0b2e, 0x0813, 0x10d6
};

static uint16_t const p_shuffle_sub[ 256 ] =
{
    0x067a, 0x0c7d, 0x0b4f, 0x127d, 0x0bd6, 0x04ac, 0x16e0, 0x1730,
    0x0587, 0x0afb, 0x1ac3, 0x0120, 0x14b5, 0x0f67, 0x11de, 0x0961,
    0x1127, 0x1a68, 0x07f0, 0x17d0, 0x1a6f, 0x1f3b, 0x01ef, 0x0919,
    0x131e, 0x0f90, 0x19e9, 0x18a8, 0x0cb2, 0x1ad0, 0x0c66, 0x0378,
    0x03b0, 0x01be, 0x1866, 0x1159, 0x197c, 0x1105, 0x010b, 0x0353,
    0x1abb, 0x09a6, 0x028a, 0x1bad, 0x1b20, 0x0455, 0x0f57, 0x0588,
    0x1491, 0x0a1d, 0x0f04, 0x0650, 0x191e, 0x1e0e, 0x174b, 0x016b,
    0x051f, 0x0532, 0x00df, 0x1aea, 0x0005, 0x0e1b, 0x0ff6, 0x08d8,
    0x14b4, 0x086a, 0x0c20, 0x0149, 0x1971, 0x0f26, 0x1852, 0x017d,
    0x1228, 0x0352, 0x0a44, 0x1330, 0x18df, 0x1e38, 0x01bc, 0x0bac,
    0x1a48, 0x021f, 0x02f7, 0x0c31, 0x0bc4, 0x1e75, 0x105c, 0x13e3,
    0x0b20, 0x03a1, 0x1af3, 0x1a36, 0x0e34, 0x181f, 0x09bd, 0x122b,
    0x0ee0, 0x163b, 0x0be7, 0x103d, 0x1075, 0x1e9d, 0x02af, 0x0ba2,
    0x1daa, 0x0cf1, 0x04b6, 0x0598, 0x06a1, 0x0d33, 0x1cfe, 0x04ee,
    0x1bad, 0x07c8, 0x1a48, 0x05e6, 0x031f, 0x0e0a, 0x0326, 0x1650,
    0x0526, 0x0b4e, 0x08fc, 0x0e4d, 0x0832, 0x06ea, 0x09bf, 0x0993,
    0x09eb, 0x0f31, 0x071b, 0x14d5, 0x11ca, 0x0722, 0x120d, 0x014c,
    0x1993, 0x0ae4, 0x1ccb, 0x04e9, 0x0aee, 0x1708, 0x0c3d, 0x12f2,
    0x1a19, 0x07c1, 0x05a7, 0x0744, 0x1606, 0x1a9b, 0x042d, 0x1bfc,
    0x1841, 0x0c3c, 0x0ffe, 0x1ab1, 0x1416, 0x18a9, 0x0320, 0x1ec2,
    0x0ae7, 0x11c6, 0x124a, 0x11df, 0x0f81, 0x06cf, 0x0ed9, 0x0253,
    0x1d2b, 0x0349, 0x0805, 0x08b3, 0x1052, 0x12cf, 0x0a44, 0x0ea6,
    0x03bf, 0x1d90, 0x0ef8, 0x0657, 0x156d, 0x0405, 0x10be, 0x091f,
    0x1c82, 0x1725, 0x19ef, 0x0b8c, 0x04d9, 0x02c7, 0x025a, 0x1b89,
    0x0f5c, 0x013d, 0x02f7, 0x12e3, 0x0bc5, 0x1b56, 0x0848, 0x0239,
    0x0fcf, 0x03a4, 0x092d, 0x1354, 0x1d83, 0x01bd, 0x071a, 0x0af1,
    0x0875, 0x0793, 0x1b41, 0x1782, 0x0def, 0x1d20, 0x13be, 0x0095,
    0x1650, 0x19d4, 0x0de3, 0x0980, 0x18f2, 0x0ca3, 0x0098, 0x149a,
    0x0b81, 0x0ad2, 0x1bba, 0x1a02, 0x027b, 0x1906, 0x07f5, 0x1cae,
    0x0c3f, 0x02f6, 0x1298, 0x175e, 0x15b2, 0x13d8, 0x14cc, 0x161a,
    0x0a42, 0x15f3, 0x0870, 0x1c1d, 0x1203, 0x18b1, 0x1738, 0x1954,
    0x1143, 0x1ae8, 0x1d9d, 0x155b, 0x11e8, 0x0ed9, 0x06f7, 0x04ca
};

static uint16_t const p_shuffle_add[ 256 ] =
{
    0x0706, 0x175a, 0x0def, 0x1e72, 0x0297, 0x1b0e, 0x1d5a, 0x15b8,
    0x13e2, 0x1347, 0x10c6, 0x0b4f, 0x0629, 0x0a75, 0x0a9b, 0x0f55,
    0x1a69, 0x09bf, 0x0ba6, 0x1582, 0x1086, 0x1921, 0x01cb, 0x1c6a,
    0x0ff5, 0x00f7, 0x0a67, 0x0a1e, 0x1838, 0x0196, 0x10d6, 0x0c7a,
    0x180e, 0x038d, 0x1add, 0x0684, 0x154a, 0x0ab0, 0x18a4, 0x0d73,
    0x1641, 0x0ec6, 0x09f1, 0x1a62, 0x0414, 0x162a, 0x194e, 0x1ec9,
    0x022f, 0x0296, 0x1104, 0x14fc, 0x096c, 0x1d02, 0x09bd, 0x027c,
    0x080e, 0x1324, 0x128c, 0x0dc1, 0x00b9, 0x17f2, 0x0cbc, 0x0f97,
    0x1b93, 0x1c3c, 0x0415, 0x0395, 0x0c7a, 0x06cc, 0x0d4b, 0x16e2,
    0x04a2, 0x0dab, 0x1228, 0x012b, 0x0896, 0x0012, 0x1cd6, 0x1dac,
    0x080d, 0x0446, 0x047a, 0x00ad, 0x029e, 0x0686, 0x17c3, 0x1466,
    0x0d16, 0x1896, 0x076e, 0x00cd, 0x17dc, 0x1e9f, 0x1a7c, 0x02bb,
    0x0d06, 0x112b, 0x14cb, 0x0a03, 0x1541, 0x1290, 0x0f6d, 0x1503,
    0x084b, 0x0382, 0x1a3f, 0x0371, 0x1977, 0x0b67, 0x0cad, 0x1df8,
    0x1ce3, 0x1306, 0x13f8, 0x1163, 0x1b0b, 0x00bd, 0x0bf0, 0x1a4f,
    0x16f7, 0x0b4f, 0x0cf8, 0x1254, 0x0541, 0x100d, 0x0296, 0x0410,
    0x1a2b, 0x1169, 0x17d9, 0x0819, 0x03d6, 0x0d03, 0x194d, 0x184a,
    0x07ca, 0x1989, 0x0fad, 0x011c, 0x1c71, 0x0ef6, 0x0dc8, 0x0f2f,
    0x0fa5, 0x11be, 0x0f3b, 0x1d52, 0x0de2, 0x016e, 0x1ad1, 0x0c4a,
    0x1bc2, 0x0ac9, 0x1485, 0x1bee, 0x0949, 0x1a79, 0x1894, 0x12bb,
    0x17b6, 0x14f5, 0x16b1, 0x142c, 0x1301, 0x03ef, 0x16ff, 0x0d37,
    0x0d78, 0x01ff, 0x00d6, 0x1053, 0x1a2a, 0x0f61, 0x1352, 0x0c7f,
    0x137f, 0x09c4, 0x1d96, 0x021d, 0x1037, 0x1b19, 0x10ef, 0x14e4,
    0x02a0, 0x0236, 0x0a5d, 0x1519, 0x141c, 0x1399, 0x007e, 0x1e74,
    0x0941, 0x1b3c, 0x0062, 0x0371, 0x09ad, 0x08e8, 0x0a24, 0x0b97,
    0x1ed2, 0x0889, 0x136b, 0x0006, 0x1c4c, 0x0444, 0x06f8, 0x0dfb,
    0x1d0f, 0x198d, 0x0700, 0x0afc, 0x1781, 0x12f3, 0x10da, 0x1f19,
    0x1055, 0x0dc9, 0x1860, 0x012b, 0x05bf, 0x082d, 0x0c17, 0x1941,
    0x0359, 0x1232, 0x104c, 0x0762, 0x0897, 0x1d6c, 0x030f, 0x1a36,
    0x16b0, 0x094d, 0x1782, 0x036f, 0x0eea, 0x06e6, 0x0d00, 0x0187,
    0x17e2, 0x05e5, 0x19fa, 0x1950, 0x146a, 0x0b2a, 0x0512, 0x0ee0,
    0x1e27, 0x112d, 0x1df0, 0x0b13, 0x0378, 0x1dd0, 0x00c1, 0x01e6
};

