/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2016-2024 Intel Corporation <www.intel.com>
 */

#ifndef _SOCFPGA_SOC64_BASE_HARDWARE_H_
#define _SOCFPGA_SOC64_BASE_HARDWARE_H_

#if IS_ENABLED(CONFIG_TARGET_SOCFPGA_AGILEX5)
#define SOCFPGA_CCU_ADDRESS			0x1c000000
#define SOCFPGA_F2SDRAM_MGR_ADDRESS		0x18001000
#define SOCFPGA_SMMU_ADDRESS			0x16000000
#define SOCFPGA_OCRAM_FIREWALL_ADDRESS		0x108cc400
#define SOCFPGA_MAILBOX_ADDRESS			0x10a30000
#define SOCFPGA_UART0_ADDRESS			0x10c02000
#define SOCFPGA_UART1_ADDRESS			0x10c02100
#define SOCFPGA_SPTIMER0_ADDRESS		0x10c03000
#define SOCFPGA_SPTIMER1_ADDRESS		0x10c03100
#define SOCFPGA_SYSTIMER0_ADDRESS		0x10d00000
#define SOCFPGA_SYSTIMER1_ADDRESS		0x10d00100
#define SOCFPGA_L4WD0_ADDRESS			0x10d00200
#define SOCFPGA_L4WD1_ADDRESS			0x10d00300
#define SOCFPGA_L4WD2_ADDRESS			0x10d00400
#define SOCFPGA_L4WD3_ADDRESS			0x10d00500
#define SOCFPGA_L4WD4_ADDRESS			0x10d00600
#define SOCFPGA_GTIMER_SEC_ADDRESS		0x10d01000
#define SOCFPGA_GTIMER_NSEC_ADDRESS		0x10d02000
#define SOCFPGA_CLKMGR_ADDRESS			0x10d10000
#define SOCFPGA_RSTMGR_ADDRESS			0x10d11000
#define SOCFPGA_SYSMGR_ADDRESS			0x10d12000
#define SOCFPGA_OCRAM_ADDRESS			0x00000000
#define SOCFPGA_FW_DDR_CCU_DMI0_ADDRESS		0x18000800
#define SOCFPGA_FW_DDR_CCU_DMI1_ADDRESS		0x18000A00
#define SOCFPGA_FW_TBU2NOC_ADDRESS		0x18000C00
#define SOCFPGA_FIREWALL_L4_PER			0x10d21000
#define SOCFPGA_FIREWALL_L4_SYS			0x10d21100
#define SOCFPGA_FIREWALL_SOC2FPGA		0x10d21200
#define SOCFPGA_FIREWALL_LWSOC2FPGA		0x10d21300
#define SOCFPGA_FIREWALL_TCU			0x10d21400
#define SOCFPGA_FIREWALL_PRIV_MEMORYMAP_PRIV	0x10d24800
#define GICD_BASE				0x1d000000
#define GICR_BASE				0x1d060000
#else
#define SOCFPGA_CCU_ADDRESS			0xf7000000
#define SOCFPGA_SDR_SCHEDULER_ADDRESS		0xf8000400
#define SOCFPGA_HMC_MMR_IO48_ADDRESS		0xf8010000
#define SOCFPGA_SDR_ADDRESS			0xf8011000
#if IS_ENABLED(CONFIG_TARGET_SOCFPGA_AGILEX) || \
	IS_ENABLED(CONFIG_TARGET_SOCFPGA_N5X)
#define SOCFPGA_FW_MPU_DDR_SCR_ADDRESS		0xf8020200
#else
#define SOCFPGA_FW_MPU_DDR_SCR_ADDRESS		0xf8020100
#endif
#define SOCFPGA_F2SDRAM_MGR_ADDRESS		0xf8024000
#define SOCFPGA_SMMU_ADDRESS			0xfa000000
#define SOCFPGA_MAILBOX_ADDRESS			0xffa30000
#define SOCFPGA_UART0_ADDRESS			0xffc02000
#define SOCFPGA_UART1_ADDRESS			0xffc02100
#define SOCFPGA_SPTIMER0_ADDRESS		0xffc03000
#define SOCFPGA_SPTIMER1_ADDRESS		0xffc03100
#define SOCFPGA_SYSTIMER0_ADDRESS		0xffd00000
#define SOCFPGA_SYSTIMER1_ADDRESS		0xffd00100
#define SOCFPGA_L4WD0_ADDRESS			0xffd00200
#define SOCFPGA_L4WD1_ADDRESS			0xffd00300
#define SOCFPGA_L4WD2_ADDRESS			0xffd00400
#define SOCFPGA_L4WD3_ADDRESS			0xffd00500
#define SOCFPGA_GTIMER_SEC_ADDRESS		0xffd01000
#define SOCFPGA_GTIMER_NSEC_ADDRESS		0xffd02000
#define SOCFPGA_CLKMGR_ADDRESS			0xffd10000
#define SOCFPGA_RSTMGR_ADDRESS			0xffd11000
#define SOCFPGA_SYSMGR_ADDRESS			0xffd12000
#define SOCFPGA_PINMUX_DEDICATED_IO_ADDRESS	0xffd13000
#define SOCFPGA_FIREWALL_L4_PER			0xffd21000
#define SOCFPGA_FIREWALL_L4_SYS			0xffd21100
#define SOCFPGA_FIREWALL_SOC2FPGA		0xffd21200
#define SOCFPGA_FIREWALL_LWSOC2FPGA		0xffd21300
#define SOCFPGA_FIREWALL_TCU			0xffd21400
#define SOCFPGA_DMANONSECURE_ADDRESS		0xffda0000
#define SOCFPGA_DMASECURE_ADDRESS		0xffda1000
#define SOCFPGA_OCRAM_ADDRESS			0xffe00000
#define GICD_BASE				0xfffc1000
#define GICC_BASE				0xfffc2000
#endif /* IS_ENABLED(CONFIG_TARGET_SOCFPGA_AGILEX5) */

#endif /* _SOCFPGA_SOC64_BASE_HARDWARE_H_ */
