/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * MbedTLS config file
 *
 * Derived from the MbedTLS internal config file,
 * for more information about each build option,
 * please refer to:
 * external/mbedtls/include/mbedtls/mbedtls_config.h
 *
 * Copyright (c) 2024 Linaro Limited
 * Author: Raymond Mao <raymond.mao@linaro.org>
 */

#if defined CONFIG_MBEDTLS_LIB

#if CONFIG_IS_ENABLED(MD5)
#define MBEDTLS_MD_C
#define MBEDTLS_MD5_C
#if defined CONFIG_MBEDTLS_LIB_CRYPTO_ALT
#define MBEDTLS_MD5_ALT
#endif
#endif

#if CONFIG_IS_ENABLED(SHA1)
#define MBEDTLS_MD_C
#define MBEDTLS_SHA1_C
#if defined CONFIG_MBEDTLS_LIB_CRYPTO_ALT
#define MBEDTLS_SHA1_ALT
#endif
#endif

#if CONFIG_IS_ENABLED(SHA256)
#define MBEDTLS_MD_C
#define MBEDTLS_SHA256_C
#if defined CONFIG_MBEDTLS_LIB_CRYPTO_ALT
#define MBEDTLS_SHA256_ALT
#endif
#if CONFIG_IS_ENABLED(SHA256_SMALLER)
#define MBEDTLS_SHA256_SMALLER
#endif
#endif

#if CONFIG_IS_ENABLED(SHA384)
#define MBEDTLS_MD_C
#define MBEDTLS_SHA384_C
#endif

#if CONFIG_IS_ENABLED(SHA512)
#define MBEDTLS_MD_C
#define MBEDTLS_SHA512_C
#if defined CONFIG_MBEDTLS_LIB_CRYPTO_ALT
#define MBEDTLS_SHA512_ALT
#endif
#if CONFIG_IS_ENABLED(SHA512_SMALLER)
#define MBEDTLS_SHA512_SMALLER
#endif
#endif

#if defined CONFIG_MBEDTLS_LIB_X509

#if CONFIG_IS_ENABLED(X509_CERTIFICATE_PARSER)
#define MBEDTLS_X509_USE_C
#define MBEDTLS_X509_CRT_PARSE_C
#define MBEDTLS_X509_CRL_PARSE_C
#endif

#if CONFIG_IS_ENABLED(ASYMMETRIC_PUBLIC_KEY_SUBTYPE)
#define MBEDTLS_PK_C
#define MBEDTLS_PK_PARSE_C
#endif

#if CONFIG_IS_ENABLED(RSA_PUBLIC_KEY_PARSER)
#define MBEDTLS_BIGNUM_C
#define MBEDTLS_RSA_C
#define MBEDTLS_PKCS1_V15
#endif

#if CONFIG_IS_ENABLED(PKCS7_MESSAGE_PARSER)
#define MBEDTLS_PKCS7_C
#endif

#if CONFIG_IS_ENABLED(ASN1_DECODER)
#define MBEDTLS_OID_C
#define MBEDTLS_ASN1_PARSE_C
#define MBEDTLS_ASN1_WRITE_C
#endif

#endif /* #if defined CONFIG_MBEDTLS_LIB_X509 */

#if IS_ENABLED(CONFIG_MBEDTLS_LIB_TLS)
#include "rtc.h"

/* Generic options */
#define MBEDTLS_ENTROPY_HARDWARE_ALT
#define MBEDTLS_HAVE_TIME
#define MBEDTLS_PLATFORM_MS_TIME_ALT
#define MBEDTLS_PLATFORM_TIME_MACRO rtc_mktime
#define MBEDTLS_PLATFORM_C
#define MBEDTLS_SSL_CLI_C
#define MBEDTLS_SSL_TLS_C
#define MBEDTLS_CIPHER_C
#define MBEDTLS_MD_C
#define MBEDTLS_CTR_DRBG_C
#define MBEDTLS_AES_C
#define MBEDTLS_ENTROPY_C
#define MBEDTLS_NO_PLATFORM_ENTROPY
#define MBEDTLS_SSL_PROTO_TLS1_2
#define MBEDTLS_SSL_SERVER_NAME_INDICATION
#define MBEDTLS_KEY_EXCHANGE_PSK_ENABLED

/* RSA */
#define MBEDTLS_KEY_EXCHANGE_RSA_ENABLED
#define MBEDTLS_KEY_EXCHANGE_ECDHE_RSA_ENABLED
#define MBEDTLS_KEY_EXCHANGE_ECDH_RSA_ENABLED
#define MBEDTLS_GCM_C

/* ECDSA */
#define MBEDTLS_ECDSA_C
#define MBEDTLS_ECDH_C
#define MBEDTLS_ECDSA_DETERMINISTIC
#define MBEDTLS_HMAC_DRBG_C
#define MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA_ENABLED
#define MBEDTLS_KEY_EXCHANGE_ECDH_ECDSA_ENABLED
#define MBEDTLS_CAN_ECDH
#define MBEDTLS_PK_CAN_ECDSA_SIGN
#define MBEDTLS_ECP_C
#define MBEDTLS_ECP_DP_SECP256K1_ENABLED
#define MBEDTLS_ECP_DP_SECP192R1_ENABLED
#define MBEDTLS_ECP_DP_SECP224R1_ENABLED
#define MBEDTLS_ECP_DP_SECP256R1_ENABLED
#define MBEDTLS_ECP_DP_SECP384R1_ENABLED
#define MBEDTLS_ECP_DP_SECP521R1_ENABLED
#define MBEDTLS_ECP_DP_SECP192K1_ENABLED
#define MBEDTLS_ECP_DP_SECP224K1_ENABLED
#define MBEDTLS_ECP_DP_SECP256K1_ENABLED
#define MBEDTLS_ECP_DP_BP256R1_ENABLED
#define MBEDTLS_ECP_DP_BP384R1_ENABLED
#define MBEDTLS_ECP_DP_BP512R1_ENABLED

#endif /* #if defined CONFIG_MBEDTLS_LIB_TLS */

#endif /* #if defined CONFIG_MBEDTLS_LIB */
