/*
 * Copyright (C) 2015 Google, Inc
 * Written by Simon Glass <sjg@chromium.org>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _PMIC_RK808_H_
#define _PMIC_RK808_H_

enum {
	REG_DCDC_EN			= 0x23,
	REG_LDO_EN,
	REG_SLEEP_SET_OFF1,
	REG_SLEEP_SET_OFF2,
	REG_DCDC_UV_STS,

	REG_DCDC_UV_ACT,
	REG_LDO_UV_STS,
	REG_LDO_UV_ACT,
	REG_DCDC_PG,
	REG_LDO_PG,
	REG_VOUT_MON_TDB,
	REG_BUCK1_CONFIG,
	REG_BUCK1_ON_VSEL,

	REG_BUCK1_SLP_VSEL,
	REG_BUCK1_DVS_VSEL,
	REG_BUCK2_CONFIG,
	REG_BUCK2_ON_VSEL,
	REG_BUCK2_SLP_VSEL,
	REG_BUCK2_DVS_VSEL,
	REG_BUCK3_CONFIG,
	REG_BUCK4_CONFIG,

	REG_BUCK4_ON_VSEL,
	REG_BUCK4_SLP_VSEL,
	LDO1_ON_VSEL			= 0x3b,
	LDO1_SLP_VSEL,
	LDO2_ON_VSEL,
	LDO2_SLP_VSEL,
	LDO3_ON_VSEL,

	LDO3_SLP_VSEL,
	LDO4_ON_VSEL,
	LDO4_SLP_VSEL,
	LDO5_ON_VSEL,
	LDO5_SLP_VSEL,
	LDO6_ON_VSEL,
	LDO6_SLP_VSEL,
	LDO7_ON_VSEL,

	LDO7_SLP_VSEL,
	LDO8_ON_VSEL,
	LDO8_SLP_VSEL,
	DEVCTRL,
	INT_STS1,
	INT_STS_MSK1,
	INT_STS2,
	INT_STS_MSK2,
	IO_POL,

	/* Not sure what this does */
	DCDC_ILMAX			= 0x90,

	RK808_NUM_OF_REGS,
};

struct rk808_reg_table {
	char *name;
	u8 reg_ctl;
	u8 reg_vol;
};

int rk808_spl_configure_buck(struct udevice *pmic, int buck, int uvolt);

#endif
