/*
 * Copyright (C) 2015 Masahiro Yamada <yamada.masahiro@socionext.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __MACH_SOC_INFO_H__
#define __MACH_SOC_INFO_H__

enum uniphier_soc_id {
	SOC_UNIPHIER_PH1_SLD3,
	SOC_UNIPHIER_PH1_LD4,
	SOC_UNIPHIER_PH1_PRO4,
	SOC_UNIPHIER_PH1_SLD8,
	SOC_UNIPHIER_PH1_PRO5,
	SOC_UNIPHIER_PROXSTREAM2,
	SOC_UNIPHIER_PH1_LD6B,
	SOC_UNIPHIER_UNKNOWN,
};

#define UNIPHIER_NR_ENABLED_SOCS		\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PH1_SLD3) +	\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PH1_LD4) +	\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PH1_PRO4) +	\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PH1_SLD8) +	\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PH1_PRO5) +	\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PROXSTREAM2) +	\
	IS_ENABLED(CONFIG_ARCH_UNIPHIER_PH1_LD6B)

#define UNIPHIER_MULTI_SOC	((UNIPHIER_NR_ENABLED_SOCS) > 1)

#if UNIPHIER_MULTI_SOC
enum uniphier_soc_id uniphier_get_soc_type(void);
#else
static inline enum uniphier_soc_id uniphier_get_soc_type(void)
{
#if defined(CONFIG_ARCH_UNIPHIER_PH1_SLD3)
	return SOC_UNIPHIER_PH1_SLD3;
#endif
#if defined(CONFIG_ARCH_UNIPHIER_PH1_LD4)
	return SOC_UNIPHIER_PH1_LD4;
#endif
#if defined(CONFIG_ARCH_UNIPHIER_PH1_PRO4)
	return SOC_UNIPHIER_PH1_PRO4;
#endif
#if defined(CONFIG_ARCH_UNIPHIER_PH1_SLD8)
	return SOC_UNIPHIER_PH1_SLD8;
#endif
#if defined(CONFIG_ARCH_UNIPHIER_PH1_PRO5)
	return SOC_UNIPHIER_PH1_PRO5;
#endif
#if defined(CONFIG_ARCH_UNIPHIER_PROXSTREAM2)
	return SOC_UNIPHIER_PROXSTREAM2;
#endif
#if defined(CONFIG_ARCH_UNIPHIER_PH1_LD6B)
	return SOC_UNIPHIER_PH1_LD6B;
#endif

	return SOC_UNIPHIER_UNKNOWN;
}
#endif

#endif /* __MACH_SOC_INFO_H__ */
