/*
 * Freescale i.MX28 Peripheral Base Addresses
 *
 * Copyright (C) 2011 Marek Vasut <marek.vasut@gmail.com>
 * on behalf of DENX Software Engineering GmbH
 *
 * Based on code from LTIB:
 * Copyright (C) 2008 Embedded Alley Solutions Inc.
 *
 * (C) Copyright 2009-2010 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MX28_REGS_BASE_H__
#define __MX28_REGS_BASE_H__

/*
 * Register base address
 */
#define	MXS_ICOL_BASE		0x80000000
#define	MXS_HSADC_BASE		0x80002000
#define	MXS_APBH_BASE		0x80004000
#define	MXS_PERFMON_BASE	0x80006000
#define	MXS_BCH_BASE		0x8000A000
#define	MXS_GPMI_BASE		0x8000C000
#define	MXS_SSP0_BASE		0x80010000
#define	MXS_SSP1_BASE		0x80012000
#define	MXS_SSP2_BASE		0x80014000
#define	MXS_SSP3_BASE		0x80016000
#define	MXS_PINCTRL_BASE	0x80018000
#define	MXS_DIGCTL_BASE		0x8001C000
#define	MXS_ETM_BASE		0x80022000
#define	MXS_APBX_BASE		0x80024000
#define	MXS_DCP_BASE		0x80028000
#define	MXS_PXP_BASE		0x8002A000
#define	MXS_OCOTP_BASE		0x8002C000
#define	MXS_AXI_AHB0_BASE	0x8002E000
#define	MXS_LCDIF_BASE		0x80030000
#define	MXS_CAN0_BASE		0x80032000
#define	MXS_CAN1_BASE		0x80034000
#define	MXS_SIMDBG_BASE		0x8003C000
#define	MXS_SIMGPMISEL_BASE	0x8003C200
#define	MXS_SIMSSPSEL_BASE	0x8003C300
#define	MXS_SIMMEMSEL_BASE	0x8003C400
#define	MXS_GPIOMON_BASE	0x8003C500
#define	MXS_SIMENET_BASE	0x8003C700
#define	MXS_ARMJTAG_BASE	0x8003C800
#define	MXS_CLKCTRL_BASE	0x80040000
#define	MXS_SAIF0_BASE		0x80042000
#define	MXS_POWER_BASE		0x80044000
#define	MXS_SAIF1_BASE		0x80046000
#define	MXS_LRADC_BASE		0x80050000
#define	MXS_SPDIF_BASE		0x80054000
#define	MXS_RTC_BASE		0x80056000
#define	MXS_I2C0_BASE		0x80058000
#define	MXS_I2C1_BASE		0x8005A000
#define	MXS_PWM_BASE		0x80064000
#define	MXS_TIMROT_BASE		0x80068000
#define	MXS_UARTAPP0_BASE	0x8006A000
#define	MXS_UARTAPP1_BASE	0x8006C000
#define	MXS_UARTAPP2_BASE	0x8006E000
#define	MXS_UARTAPP3_BASE	0x80070000
#define	MXS_UARTAPP4_BASE	0x80072000
#define	MXS_UARTDBG_BASE	0x80074000
#define	MXS_USBPHY0_BASE	0x8007C000
#define	MXS_USBPHY1_BASE	0x8007E000
#define	MXS_USBCTRL0_BASE	0x80080000
#define	MXS_USBCTRL1_BASE	0x80090000
#define	MXS_DFLPT_BASE		0x800C0000
#define	MXS_DRAM_BASE		0x800E0000
#define	MXS_ENET0_BASE		0x800F0000
#define	MXS_ENET1_BASE		0x800F4000

#endif /* __MX28_REGS_BASE_H__ */
