/*--------------------------------------------------------------------------*/
/*                                                                          */
/*               The Opus Computer-Based Conversation System                */
/*    (c) Copyright 1986-1991, Wynn Wagner III, All Rights Reserved         */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/* This material is available for use by anybody with no strings and        */
/* no guarantees.                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.20 Message/File area database structures.                         */
/* Copyright 1991 Wynn Wagner III, Doug Boone and John Valentyn.            */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#define  THIS_CTL_VERSION  18       /* PRM structure version number         */

#if      COMPILER
#           define CTLSIZE 0x7fff   /* Only used when compiling OPUS_CTL    */
#           define OFS     int
#elif    UTILS
#           define CTLSIZE 1   /* Only used when compiling Utilities*/
#           define OFS     int
#else
#           define CTLSIZE 1
#           define OFS     char*
#endif


#define  MAX_EXTERN        16       /* max. number of external programs     */
#define  MAXCLASS          12       /* number of possible priv levels       */
#define  ALIAS_CNT         15       /* number of matrix addresses           */

#define  _TWIT             0x10
#define  _DISGRACE         0x30
#define  _LIMITED          0x40
#define  _NORMAL           0x50
#define  _WORTHY           0x60
#define  _PRIVEL           0x70
#define  _FAVORED          0x80
#define  _EXTRA            0x90
#define  _CLERK            0xA0
#define  _ASSTSYSOP        0xB0
#define  _SYSOP            0xD0
#define  _HIDDEN           0xE0

#define  Twit              _TWIT
#define  Disgrace          _DISGRACE
#define  Limited           _LIMITED
#define  Normal            _NORMAL
#define  Worthy            _WORTHY
#define  Privil            _PRIVEL
#define  Favored           _FAVORED
#define  Extra             _EXTRA
#define  Clerk             _CLERK
#define  AsstSysop         _ASSTSYSOP
#define  Sysop             _SYSOP
#define  Hidden            _HIDDEN



struct   class_rec
   begin
      byte  ClassPriv;
      byte  class_fill;
      int   max_time;      /* max cume time per day         */
      int   max_call;      /* max time for one call         */
      word  max_dl;        /* max dl bytes per day          */
      byte  ratio_down;
      byte  ratio_up;
      word  min_baud;      /* speed needed for logon        */
      word  min_file_baud; /* speed needed for file xfer    */
   end;

struct _FOSREGS
   begin
      word  ax;
      word  bx;
      word  cx;
      word  dx;
   end;


/*--------------------------------------------------------------------------*/
/* The format of the PRM file, VERSION 18                                   */
/*                                                                          */
/* THIS IS AN EXPLOSIVE STRUCTURE.  IT IS SUBJECT TO CHANGE WITH NO NOTICE. */
/*                                                                          */
/* Offsets to the following item(s) are guaranteed:                         */
/*                                                                          */
/*      byte   version;           OFFSET 0, all versions                    */
/*      byte   task_num;          OFFSET 1, 16+                             */
/*                                                                          */
/*--------------------------------------------------------------------------*/
struct _PRM
   begin
               /*-----------------------------------------------------------*/
               /* DATA                                                      */
               /*-----------------------------------------------------------*/
         byte  version;        /* for safety                          STABLE*/
         byte  task_num;       /* for multi-tasking systems           STABLE*/
         ADDR  alias[ALIAS_CNT];

         byte  video;          /* 0=Dos, 1=Fossil 2=IBM                     */
         byte  testmode;       /* input from keyboard, not modem            */

         word  carrier_mask;
         word  handshake_mask;
         word  max_baud;       /* fastest speed we can use                  */
         word  com_port;       /* Com1=0, Com2=1, FF=keyboard               */

         byte  multitasker;    /* flag for DoubleDos (see below)            */
         byte  mailer_type;    /* 0=Opus, 1=load external, 2=call external  */

         byte  ModemFlag;      /* (See MODEM FLAG below)                    */
         byte  LogFlag;        /* (See LOG FLAG below)                      */

         byte  StyleFlag;      /* (See STYLE FLAG below)                    */
         byte  FWDflag;        /* Bits to control IN TRANSIT messages       */

         byte  Flags;          /* See "FLAGS" below                         */
         byte  Flags2;         /* See "FLAGS 2" below                       */

         byte  edit_exit;      /* ERRORLEVEL to use if Matrix area changed  */
         byte  exit_val;       /* ERRORLEVEL to use after caller            */

         byte  crashexit;      /* non-zero= ErrorLevel exit                 */
         byte  arc_exit;       /* ErrorLevel for after incomming ARCmail    */

         byte  echo_exit;      /* ERRORLEVEL for after inbound echomail     */
         byte  UDB_Flags;      /* User data base flags                      */

         word  min_baud;       /* minimum baud to get on-line               */
         word  color_baud;     /* min baud for graphics                     */
         word  date_style;     /* Used for FILES.BBS display                */

         byte  logon_priv;     /* Access level for new users                */
         byte  seenby_priv;    /* Min priv to see SEEN_BY line              */

         byte  ctla_priv;      /* Priv to see CONTROL-A lines in messages   */
         byte  Interline_Flags;  /* Flags relating to interline systems     */

         byte  AskPrivs[16];   /* Array of privs. for message attr ask's    */
         byte  AssumePrivs[16];/* Array of privs. for message attr assume's */

         word  logon_time;     /* time to give for logons                   */

         word  matrix_mask;

         word  MinNetBaud;     /* minimum baud rate for remote netmail      */
         byte   exit_mailer;		/* Exit when mailer is running        */
         byte   num_crashes;		/* Number of tries when sending crash */

         struct class_rec class[MAXCLASS];
         struct _FOSREGS FosRegs[10];

         word  F_Reward;       /* File upload time reward percentage        */
         word  last_area;      /* Highest msg area presumed to exist        */
         word  last_farea;     /* Highest file area presumed to exist       */

         byte  return_secure;  /* 0=ignore LASTUSER, >1 re-read LASTUSER    */

       /*  New for Version 17 */

         byte xuflags;         /* ExtUser Flags: 1=Alias, 2=UserTel         */
         word xlmin;           /* Lead mins for expiry warning              */
         char xlday;           /* Lead days for expiry warning              */
         byte expriv;          /* Expiry privilege                          */
         char totlang;         /* Total languages present (1-6)             */
         byte sylno;           /* Def Sysop Language no.  (0-5)             */
         byte uslno;           /* Def User Language no.   (0-5)             */
         byte relog_exit;      /* Exit after -o relog                       */
         word Scrn_Size;		/* Local monitor's size, high byte = len    */

/* New for version 18 */

         word default_expire_days;    	/* Number of days before new users  */
         word default_expire_mins;    	/* Number of days before new users  */
         long default_keys;		/* New user's default keys                  */
         long default_section; 	/* New user's default section               */
         word   Point_Net;		/* My point net                             */
         word   Boss_Node;		/* My point net                             */
         byte   NoPwd_Priv;		/* Priv if you want to allow users without password */
         byte   Local_Exit;		/* Exit after local messages                */
         byte   Upload_Exit;		/* Exit after an upload for checking  */
         byte   ExtMail_Exit;		/* Exit for externmail                */
         byte   Max_Echo;		/* Longest echomail message to handle 3-60k */
         byte   WhoPriv;		/* Priv to see who uploaded a file           */

         ADDR   GUUCP;		/* Where to send gated UUCP messages             */
         long   making_section;
         byte   ListSysop;		/* Privilege neeeded to see sysops in net list */
         byte   rawpriv;		/* Privilege needed to see/download files not listed */
         byte   uucp_priv;		/* Privilege needed to turn off uucp addresses */
         byte   Flags3;		/* More flags.                               */
         byte   Mail_Exit;		/* Exit after mail connect                   */
         byte   byte_fill;
           
         word   PRM_FILL3[18];  


               /*-----------------------------------------------------------*/
               /* OFFSETS                                                   */
               /*-----------------------------------------------------------*/

                               /*-------------------------------------------*/
                               /* MODEM COMMAND STRINGS                     */
                               /*-------------------------------------------*/
         OFS   MDM_Init;       /* modem initialization string               */
         OFS   MDM_PreDial;    /* modem dial command sent before number     */
         OFS   MDM_PostDial;   /* modem command sent after dialed number    */
         OFS   MDM_LookBusy;   /* mdm cmd to take modem off hook            */

                               /*-------------------------------------------*/
                               /* PRIMROSE PATHS                            */
                               /*-------------------------------------------*/
         OFS   misc_path;      /* path to BBS/GBS files                     */
         OFS   sys_path;       /* path to SYSTEM?.BBS files                 */
         OFS   temppath;       /* place to put temporary files              */
         OFS   net_info;       /* path to NODELIST files                    */
         OFS   mailpath;       /* place to put received netmail bundles     */
         OFS   filepath;       /* place to put received netmail files       */
         OFS   hold_area;      /* path to pending outbound matrix traffic   */

                               /*-------------------------------------------*/
                               /* DATA FILE NAMES                           */
                               /*-------------------------------------------*/
         OFS   user_file;      /* path/filename of User.Bbs                 */
         OFS   sched_name;     /* name of file with _sched array            */
         OFS   langdir;        /* Langauge file dir. (Was Syl in v16)       */
         OFS   spcldir;        /* Spcl Ann Text dir. (Was Usl in v16)       */

                               /*-------------------------------------------*/
                               /* MISCELLANEOUS TEXT                        */
                               /*-------------------------------------------*/
         OFS   system_name;    /* board's name                              */
         OFS   sysop;          /* sysop's name                              */
         OFS   timeformat;
         OFS   dateformat;
         OFS   OFS_Filler1[8];  

                               /*-------------------------------------------*/
                               /* BBS/GBS SUPPORT FILES                     */
                               /*-------------------------------------------*/
         OFS   logo;           /* first file shown to a caller              */
         OFS   welcome;        /* shown after logon                         */
         OFS   newuser1;
         OFS   newuser2;
         OFS   rookie;

         OFS   HLP_Editor;     /* Intro to msg editor for novices.          */
         OFS   HLP_Replace;    /* Explain the Msg.Editor E)dit command      */
         OFS   HLP_Inquire;    /* Explain the Msg. I)nquire command         */
         OFS   HLP_Locate;     /* Explain the Files L)ocate command         */
         OFS   HLP_Contents;   /* Explain the Files C)ontents command       */
         OFS   HLP_OPed;       /* help file for the full-screen editor      */
         OFS   OUT_Leaving;    /* Bon Voyage                                */
         OFS   OUT_Return;     /* Welcome back from O)utside                */
         OFS   ERR_DayLimit;   /* Sorry, you've been on too long...         */
         OFS   ERR_TimeWarn;   /* warning about forced hangup               */
         OFS   ERR_TooSlow;    /* explains minimum logon baud rate          */
         OFS   ERR_XferBaud;   /* explains minimum file transfer baud rate  */
         OFS   LIST_MsgAreas;  /* dump file... used instead of Dir.Bbs      */
         OFS   LIST_FileAreas; /* dump file... used instead of Dir.Bbs      */

         OFS   FREQ_MyFiles;   /* file to send when FILES is file requested */
         OFS   FREQ_OKList;    /* list of files approved for file requests  */
         OFS   FREQ_About;     /* File Request: ABOUT file                  */

         OFS   OEC_Quotes;
         OFS   byebye;         /* file displayed at logoff                  */
         OFS   local_editor;   /* text editor to use in keyboard mode       */
         OFS   barricade;
         OFS   STATUS_dir;     /* Where to find INMAIL/ACTIVE/LASTUSER      */
         OFS   mailer;         /* full external mailer command              */
         OFS   common;         /* File with data common to all tasks        */

             /*  New for Version 17 */
      
         OFS   xdwarn;         /* Date Warning OEC BBS                      */
         OFS   xtwarn;         /* Time Warning OEC BBS                      */
         OFS   xdexpd;         /* Expired due-to-Date OEC BBS               */
         OFS   xtexpd;         /* Expired due-to-Time used OEC BBS          */
         OFS   lang[12];       /* 12 Language File Root Name pointers       */
      
         OFS   badpath; 		/* Path for unrecognized echo names         */
/*--------------------------------------------------------------------------*/
/* New for version 18                                                       */
/*--------------------------------------------------------------------------*/
         OFS   ConfHelp;		/* Help file for newuser configure          */
         OFS   Mainmenu;		/* ASCII menu at MAIN                       */
         OFS   Confmenu;		/* ASCII menu at Config                     */
         OFS   Sectmenu;		/* ASCII menu at Section menu               */
         OFS   Sysopmenu;		/* ASCII menu at Sysop menu                 */
         OFS   Echotoss;       /* Where to find EchoToss.Log               */
         OFS   MDM_Answer;     /* String to force autoanswer               */
         OFS   BAD_PWD;		/* File shown to users who've forgottent thiers */
         OFS   Charset;		/* File that contains character translation tables */
         OFS   DL_Log;		    /* Who's downloaded what                    */
         OFS   UL_Log;		    /* Who uploaded what                        */
         OFS   Name_Filter;	/* Old USERNAME.TXT                         */
         OFS   Bad_Name;		/* What to show user if filter catches them */
         OFS   CUSTOM1_menu;	/* What to show before CUSTOM1 menu         */
         OFS   CUSTOM2_menu;	/* What to show before CUSTOM2 menu         */
         OFS   CUSTOM3_menu;	/* What to show before CUSTOM3 menu         */
         OFS   CUSTOM4_menu;	/* What to show before CUSTOM4 menu         */
         OFS   CUSTOM5_menu;	/* What to show before CUSTOM5 menu         */
         OFS   CUSTOM6_menu;	/* What to show before CUSTOM6 menu         */
         OFS   EXT_mail_string;		/* What we see when UUCP is coming    */
         OFS   MaybeNew;		/* File shown if didn't find user name       */
         OFS   Histmenu;		/* ASCII menu at History                     */
         OFS   My_Question;		/* Sysop configured question             */
         OFS   HLP_make;		/* How to make a section                     */
         OFS   MDM_FDial[4];		/* Special dialing instructions          */
         OFS   Yell;		/* Yell OEC                                      */
         OFS   HLP_Macro;		/* Help for macro menu                       */
         OFS   UUCP_list;		/* Address list for UUCP                     */
         OFS   HLP_IChat;		/* Interline chat help                       */
         OFS   protocols[MAX_EXTERN]; /* external file protocol programs    */

/*v18*/  OFS   OFS_Filler[7];  

               /*-----------------------------------------------------------*/
               /* Log_Name must always be the last offset in this struct    */
               /* because Bbs_Init uses that symbol to flag the end of      */
               /* the offsets.                                              */
               /*-----------------------------------------------------------*/
         OFS   log_name;       /* name of the log file                      */


               /*-----------------------------------------------------------*/
               /* Big blob of stuff                                         */
               /* It's a sequence of null-terminated character arrays...    */
               /* pointed-to by the offsets (above).                        */
               /*-----------------------------------------------------------*/
         char  buf[CTLSIZE];
   end;

#define ASK_PHONE       0x01		/* Used with xuflags                  */
#define ASK_ALIAS       0x02		/* Used with xuflags                  */
#define ASK_REAL        0x04		/* Used with xuflags                  */
#define ASK_CITY        0x08		/* Used with xuflags                  */
#define CAN_ALIAS       0x10		/* Allow ALIAS' in some situations    */
#define ASK_BDAY        0x20		/* Ask user for birthday              */
#define ASK_ADDRESS     0x40		/* Ask user for street address        */

         /* Means no privilege level is set and/or applicable At LOGON,     */
         /* for example, it means system is for PRE-REGISTERED users only.  */
#define  NO_PRIV  0xFF

struct _common_data {

   char  Opus[16];        /* "OPUS-CBCS 1.20"                               */
   long  QuotePosition;   /* Quote file position                            */
   long  CallerCount;     /* Number of callers                              */
   long  Caller_ID;		  /* ID of current newest user                      */
   long  MSG_ID;		  /* Last used MSGID                                */
   word  FILLER[15];      /* RESERVED - do not use                          */
   word  MAX_task;        /* Highest task number                            */
};

/* Explanation of _common_data:

   Opus will EXPECT to find "OPUS-CBCS 1.20" at the beginning of this file.
   If it does not find it, Opus will assume the file belongs to someone
   else and will ignore the file.

   File ctl.common is optional. It should be used only by systems that
   multitask. Its purpose is to allow separate schedule files for each
   task. If the file does not exist, Last quote pointer and Caller count
   are read from and updated in the scheduler.

   On the other hand, if this file exists the quote pointer is only updated
   in this file. Caller Count is updated separately both in the scheduler
   and this file, to allow separate statistics for each task, plus total
   statistics.

   MAX_task is informative only and should be set by the sysop. Its purpose
   is to help external intertask programs figure out how many tasks there
   exist. Its purpose is defeated if task numbers are not consecutive.

   More data may be added in the future. If so, either the FILLER field
   will be used, or the data will be appended. Existing definitions will
   remain it their respective places. Any FILLER bytes will be set to 0.
                                                                            */



/*--------------------------------------------------------------------------*/
/* MATRIX_CHANGED flags                                                     */
/*--------------------------------------------------------------------------*/

#define     MATRIX_CHANGED  0x0001    /* Changed matrix area. Scan          */
#define     LOCAL_CHANGED   0x0002    /* Changed Local area.                */
#define     GOT_BUNDLE      0x0100		/* Received a PKT file              */
#define     GOT_ARCMAIL     0x0200		/* Received an archived file        */
#define     GOT_REQUESTS    0x0400		/* Got file requests to handle      */
#define     GOT_ECHOMAIL    0x1000		/* Received Echomail                */

/*--------------------------------------------------------------------------*/
/* INTERLINE FLAGS                                                          */
/*--------------------------------------------------------------------------*/
#define     CAN_CHAT    0x01		/* Multiline systems can do chats     */

