/*--------------------------------------------------------------------------*/
/*                                                                          */
/*               The Opus Computer-Based Conversation System                */
/*    (c) Copyright 1986-1991, Wynn Wagner III, All Rights Reserved         */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/* This material is available for use by anybody with no strings and        */
/* no guarantees.                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.20 FILESBBS database structures. Copyright 1991 Wynn Wagner III,  */
/* Doug Boone and John Valentyn.                                            */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* nfile.h */
/* preliminary definitions for the opus 1.20 files.bbs handler */
/* after these structures settle down, they should be moved to system.h */
 
#define MAX_DESCR 512	/* max description length allowed */
 
#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif
 
/*--------------------------------------------------------------*/
typedef struct _afile {		/* define a files info entry */
    word    area_number;	/* area number where file resides */
    byte    name[13];		/* file name */
    byte    dl_priv;		/* Privilege needed to download this file */
    long    size;		/* file size */
    word    date;		/* file date */
    word    time;		/* file time */
    word    aflag;		/* flag (see aflag definitions) */
    long    dl_lock;		/* Lock to download this file */
    word    up_date;		/* Datestamp when file was uploaded */
    word    up_time;		/* Timestamp when file was uploaded */
    word    down_cntr;		/* # of downloads/requests */
    word    descr_len;		/* length of file description */
    byte    altpath_len;	/* File not in default dir, where is it */
    byte    upld_by_len;	/* length of uploader name */
    long    nxt_key;		/* linked list for area */
    byte    filler[20];		/* fill to 64 byte block */
} AFILE;
 
 /* description      */
 /* alternate path   */
 /* uploaded-by      */

/*--------------------------------------------------------------*/
/*		 _afile aflag definitions			*/
/*--------------------------------------------------------------*/
#define IS_FILE     0x0001	/* This is a file listing	*/
#define IS_COMMENT  0x0002	/* A comment line		*/
#define EMBEDDED    0x0004	/* This line has embedded cmnds */
#define ORPHAN      0x0008	/* Orphan file (no description)	*/
#define MISSING     0x0010	/* Missing file			*/
#define STAR_NAME   0x0020	/* File name is wildcard name	*/
#define EXPANDED    0x0040	/* expanded from wildcard name	*/
#define DELETED     0x0080	/* this entry has been deleted  */
#define AS_IS       0x0100 /* Don't wrap this line. Used with graphics */
/*		    0x0100	reserved by Opus-FAM		*/
/*		    0x0200	reserved by Opus-FAM		*/
/* the other 6 bits are not designated yet
   they can be used for such things as:
	file checked out by a virus-checker
	sysop has checked the file
*/

/*--------------------------------------------------------------*/
typedef struct _numb_idx {	/* Structure for FILESBBS.ADX */
    word    area_number;	/* area number where files reside */
    byte    area_priv;  /* Access priv */ 
    byte    filler;  /* To keep it aligned */ 
    long    area_lock;  /* Access lock */ 
    long    pos;		/* start of area in FILESBBS.DAT */
    long    insert_pos;		/* where to insert new files	*/
    word    nflag;		/* flags for this area		*/
} ANUMB;

/*--------------------------------------------------------------*/
/*		 _numb_idx nflag definitions			*/
/*--------------------------------------------------------------*/
#define HAS_AT      0x0001	/* @ Area hides uploads		*/
#define HAS_GT      0x0002	/* > Area has insert pointer	*/
 
/*--------------------------------------------------------------*/
/* alternate download path
   for use by sysops who have files on CD-ROMS or other storage devices
   where the file directories do not "map" to file area subjects.
   it is also a handy way to have a file listed in more than one area,
   yet have only one copy of the actual file.
   Opus and Opus-FAM look at altpath first to find the file, and if
   there's no altpath, look in the download directory.
*/
 
/* nxt_key
   is used to create a linked list for the overflow area. Only the first
   data record (pointed to by the numb_idx) will be used to point to the
   first record for this area in the overflow area. There's no reason to
   maintain a linked list within the data file, since all the records for
   an area are sequential. The overflow area is simply at the end of the
   data file, and contains new records that are added after the database
   has been built.
*/
 
/* DELETED flag
   is used when an entry (comment or file) is deleted. Rather than rewrite
   the entire file each time an entry is deleted, which can get rather
   time consuming, the re-index function during maintenance will purge
   the deleted records.
*/
 
/* wildcard filenames and descriptions
   are kept in the database with the STAR_NAME and MISSING flags set.
   the filenames that are expanded from the wildcards are flagged
   with IS_FILE and EXPANDED.  The re-index database utility always
   rebuilds from the wilcard name (except in quick mode).
*/
 
