
/* Functions to calculate differences in days and minutes from an ASCII string:

	"dd Mon yy  hh:mm:ss"	(exactly)

	[0]	day of month,
	[3]	Month, (3 char ASCII MSDOS name)
	[7]	year, two digits,
	[11]	hours,
	[14]	minutes,
	[17]	seconds.

Unfortunately, this gets worse. Thom Henderson fucked up the format like
so:
	"dwk dd Mon yy hh:mm"	SEADOG

	[0]	day of WEEK,
	[4]	day of month, SPACE FILLED NOT ZERO FILLED
	[7]	Month, (3 char ASCII MSDOS name)
	[11]	year, two digits,
	[14]	hours,
	[17]	minutes.


01 Jan 89  23:59:59		fido
Sun  1 Jan 89 23:59:59		seadog, variant of ...
Sun 31 Jan 89 23:59:59		...
1 Jan 89 23:59:59		... d'bridge
01 Jan 89 23:59:59		?
1 Jan 89  23:59:59		?
*/

/* Calculate the number of days between two dates, L - F. No check for overflow
or underflow is made. */

days(oldest,newest)
char *oldest;		/* say, 01 Jan 87, or seadog Tue  1 Mar 88 */
char *newest;		/* say, 20 Jan 87, or seadog Mon 23 Jan 89 */
{
unsigned yr1;
unsigned yr2;
long t1,t2;

/* Skip the day of the week if a seadog date. */

	if (! isdigit(*oldest)) oldest += 4;	/* point to seadog day of month */
	if (! isdigit(*newest)) newest += 4;	/* point to seadog day of month */

	yr1= atoi(&oldest[7]); yr2= atoi(&newest[7]);

	t1= yr1; t1 *= 365L; t1 += (yr1 / 4); t1+= getmn(&oldest[3]);
	t2= yr2; t2 *= 365L; t2 += (yr2 / 4); t2+= getmn(&newest[3]);


/* Seadog dates are space filled; if the day of the month starts with a space
skip the space. */

	if (*oldest == ' ') ++oldest; t1+= atoi(oldest); 
	if (*newest == ' ') ++newest; t2+= atoi(newest);

	if (t2 < t1) return(0);

	yr1= t2 - t1;
	return(yr1);
}

/* Given the month, return the number of days since 1 Jan. Does not do leap
year februarys. */

struct {
	char mon[4];
	int days;

} dateshit[] = {
	"Jan",31,
	"Feb",28,
	"Mar",31,
	"Apr",30,
	"May",31,
	"Jun",30,
	"Jul",31,
	"Aug",31,
	"Sep",30,
	"Oct",31,
	"Nov",30,
	"Dec",31
};

static getmn(s)
char *s;
{
int i,days;

	days= 0;
	for (i= 0; i < 12; i++) {
		if (stcpma(s,dateshit[i].mon)) break;
		days+= dateshit[i].days;
	}
	return(days);
}
