/*
	These are the definitions for string table access. Since there
	are four different tables that mprintf() must access, we pack
	the table ID and string ID into one integer. 


	 t t t t s s s s s s s s s s s s

	Where:
		t == table offset
		s == string ID (offset)

Fido loads it's necessary language files, and keeps a short table of
pointers to the basic tables:

table-table:
	FM-table ptr to FM strings...
	LM-table ...
	SM-table ...
	CM-table ...

Each .??G file consists of two parts; a table of offsets to the text, and
the text itself. The offsets are relative to the start of the file, and when
loaded, are converted into pointers to the text:

	string address = &table + table[offset]

Where offset is the string offset, above. Therefore, mprintf(SM999) becomes:

	t= table-table[ID >> 12]			;pointer to right table
	t= t[ID & 0x0fff]				;pointer to Nth string

(The stationary tables FMtable and LMtable are already pointers -- they simply
need to be linked in.)
*/

#define _TBLID 12		/* table ID shift */
#define _TBLIDM (0x0fff)	/* mask off table ID */

/* (These run 1 - N so that none of them equal 0 (ahem FM+0), which
is the literal-string indicator.) */

#define FM (1 << _TBLID)	/* built-in, fixed strings */
#define	SM (2 << _TBLID)	/* Sysop Message strings */
#define LM (3 << _TBLID)	/* Log Message strings */
#define CM (4 << _TBLID)	/* Caller Message strings */

#define LANGVER 1		/* current version */

/* This is the structure prepended to each .??G file: */

struct _lang_hdr {		/* 256 bytes */
	char junk[200];		/* disclaimer, etc */
	char extra[30];
	char compiler[22];	/* who's compiler */
	unsigned version;	/* version ID */
	unsigned crc;		/* 16 bit CRC */
};
