/*
	Big Fido v11 include file. Some of it is pre v12.
	T. Jennings 1 Aug 86 

NOTE: "OBSO" means "Obsolete"; they exist currently, but may not 
in the future. Please use only structures defined as "PUBLIC".
Structures not marked "PUBLIC" may change at any time.

*/

#define SS 80			/* standard, universal, string size */
#define SF (sizeof("FILENAME.EXT")+1) /* space needed for a full filename */

#define NULL 0			/* nothing */
#define CBSIZE 64		/* console ring buffer size */
#define MAXAREA 99		/* maximum message/file areas */

/* Text buffer stuff */

#define LINES 47		/* default number of lines */
#define COLS SS			/* number of columns (fixed) */
#define TEXTSIZE (LINES * COLS)

/* Standard node structure used throughout Fido. */

/* PUBLIC */

struct _node {
	int zone;		/* zone number */
	int net;		/* net number */
	int number;		/* node number */
};

#define FIDO 1			/* infernal mode values */
#define FIDONET 2

#define FLAG char		/* define 1/0 type flags */

char *str_node();
char *skip_delim();
char *next_arg();
char *strip_path();
long _fsize();
long lseek();
long sizmem();
char *getml();
char *getmem();
char *getarg();

/* Callin users record. */

/* PUBLIC */

#define MAXLREAD 10

struct  _usr {
	char name[36];		/* users ASCII name, */
	char city[36];		/* city and state, */

/* This structure takes exactly 40 bytes, and replaces the old 
first date. (Which was luckily int[20] by mistake!) */

	struct {
		int area;	/* message area */
		int msg;	/* last msg read */
	} lastmsg[MAXLREAD];

	char pwd[16];		/* what else, */
	int times;		/* # times called, */
	int help;		/* last help setting, */
	int tabs;		/* 1 == expand tabs, */
	int nulls;		/* number of nulls after CR, */
	int msg;		/* last selected message area, */
	int more;		/* last MORE setting, */
	int priv;		/* user privelege level, */
	char ldate[20];		/* last time called, */
	int time;		/* total time on system in 1 day, */
	unsigned bits;		/* various bit flags, */
	unsigned upld;		/* total K byte uploaded, */
	unsigned dnld;		/* total K bytes downloaded, */
	unsigned dnldl;		/* download, for limiting, */
	int files;		/* last selected file area, */
	char width;		/* screen width, */
	char len;		/* screen length, */
	int credit;		/* credit, in cents, */
	int debit;		/* debit, in cents, */
};

/* User privileges */

#define TWIT -2			/* total asshole */
#define DISGRACE 0		/* disgraced user, */
#define NORMAL 2		/* normal user, */
#define PRIVEL 4		/* priveleged user, */
#define EXTRA 6			/* extra priveleges, */
#define SYSOP 10		/* SYSOP proveleges, */

/* User help levels */

#define EXPERT 2		/* user help level: expert */
#define REGULAR 4		/* experienced */
#define NOVICE 6		/* new user */

/* Structure for the time log: first access, last access, and an integer
counter for each hour of each day of the week. */

/* PUBLIC */

struct _tlog {
	int calls;		/* # calls in log, */
	char fdate[20];		/* logging started, */
	char ldate[20];		/* logging ended, */
	int log[7][24];		/* the counters, */
};

/* Structure for each virtual bulletin board. */

/* OBSO */

struct _sys {
	unsigned ls_caller;	/* LS word of callers */
	int priv;		/* min. privelege to access this */
	char msgpath[40];	/* path for message base, */
	char bbspath[40];	/* path for .BBS files, */
	char hlppath[40];	/* path for HLP files, */
	char uppath[40];	/* path for uploads, */
	char filepath[40];	/* path for file area, */
	int attrib;		/* attributes */
	unsigned ms_caller;	/* MS word of callers */
	long quote_pos;		/* quote file index */
};
#define SYSMAIL 1		/* is a mail area */

/* Tables of command names and privelege levels for each. */

struct _cmd {
	char name[20];
	int priv;
};

/* Message header structure. The message text is just a long string. The
zone:net/node of course do not conform to the new (v12) standard. */

/* PUBLIC */

struct _msg {
	char from[36];		/* who from, */
	char to[36];		/* who to, */
	char subj[72];		/* message subject, */
	char date[20];		/* creation date, */
	int times;		/* number of times read, */
	int dest_number;	/* destination node, */
	int orig_number;	/* originating node */
	int cost;		/* actual cost of this msg */
	int orig_net;		/* v10 originating net */
	int dest_net;		/* v10 destination net */
	int dest_zone;		/* v12 originating zone */
	int orig_zone;		/* v12 destination zone */
	int caca[2];		/* extra space */
	unsigned reply;		/* thread to previous msg. (reply-to) */
	int attr;		/* message type, see below */
	int up;			/* thread to next msg. (replied-to) */
};

/* Message attribute bits */

#define MSGPRIVATE 1		/* private message, */
#define MSGREAD 4		/* read by addressee */
#define MSGSENT 8		/* sent OK (remote) */
#define MSGFILE 16		/* file attached to msg */
/* OBSO */ 
#define MSGFWD 32		/* being forwarded */
#define MSGORPHAN 64		/* unknown dest node */
#define MSGKILL 128		/* kill after mailing */
#define MSGLOCAL 256		/* FidoNet vs. local */

/* Message bits used by SeaDog. (Not used by Fido) */

#define MSGFOK 2		/* accept for forwarding */
#define MSGFRQ 2048		/* file request */
#define MSGRRQ 4096		/* receipt requested */
#define MSGCPT 8192		/* is a return receipt */
#define MSGARQ 16384		/* audit trail requested */
#define MSGURQ 32768		/* update request */

/* Modem type values */

#define HAYES 1			/* DC Hayes and clones */
#define DF03 2			/* DEC DF 03 */
#define VA212 3			/* Racal Vadic VA 212 */
#define SMARTCAT 4		/* Novation SmartCat */
#define USR 5			/* US Robotics */
#define ANCHOR 6		/* Anchor Automation */
#define POPCOM 7		/* Popcom */
#define IBMJR 8			/* IBM PC Junior version of SmartCat */
#define VENTEL 9		/* Ventel MD212 with WECO ROM */
#define GDC 10
#define SM24 11			/* Hayes 2400 */
#define USR24 12		/* USR 2400 */
#define MT24 13			/* Multi Tech 2400 */

/* MAIL.SYS file structure. The contents of this does not conform
to internal standards; it is for export to other programs. */

/* OBSO */

struct _mail {
	int node;		/* local node number, */
	float fudge;		/* obs */
	int rate;		/* obs */
	char msgpath[80];	/* path to find mail in */
	char filepath[80];	/* mail file path */
	int net;		/* net number */
	int alt_node;		/* alternate node number */
	int alt_net;		/* alternate net number */

/* extended length */

	int zone;
	int alt_zone;
};

/* FIDO.SYS: This is where Fido keeps global things. External programs
should use FIDO.SYS, not MAIL.SYS or any of the OBSO structures. This file 
is generated every time Fido is run. */

/* PUBLIC */

struct _fido {
	int flag;		/* -1 for a FIDO.SYS file */
	int version;		/* FIDO.SYS version number */
	struct _node id;	/* our node ID */
	struct _node altid;	/* our secondary node ID */
	struct _node x1[4];	/* extra */

	long quote_pos;		/* quote file position */
	long callers;		/* number of callers */
	long x2[8];		/* extra */

	int netmarea;		/* number of Fidonet msg area */
	int netdarea;		/* number of FidoNet download area */
	int netuarea;		/* numberof FidoNet upload area */
	int xi[20];		/* extra */

	char nodepath[SS];	/* nodelist work path */
	char x3[8][SS];		/* extra */

	char msgpath[MAXAREA][SS];	/* message areas, */
	char dlpath[MAXAREA][SS];	/* download areas */
	char ulpath[MAXAREA][SS];	/* upload areas */
};

/* NODELIST.SYS: this file is a little wierd; in order to keep the size down,
the net/node number is not stored in the record; it is kept in the index
file only, and filled in by the get_node() routine. */

/* PUBLIC */

struct _ndat {
	struct _node node;	/* faked */

	int cost;		/* cost to call */
	int rate;		/* baud rate */
	char name[20];		/* node name */
	char phone[40];		/* phone number */
	char city[40];		/* city and state, */
};
#define NDAT_SIZE (sizeof(struct _ndat)-sizeof(struct _node))

/* Node map; NODEMAP.SYS */

/* PUBLIC */

struct _nmap {
	struct _node node;	/* actual address (-1 for regions, etc) */
	struct _node route;	/* route-to address */
	char bits;		/* see below */
	unsigned time;		/* total time to send, */
	char msgs;		/* number of messages in the packet, */
	char files;		/* files in the packet, */
	char tries;		/* number of attempts to send, */
	char connects;		/* number of actual connections */
};

#define NODE_ACCEPT 1		/* ACCEPT-FROM this node */
#define NODE_PU 2		/* PICKUP from this node */
#define NODE_POLL 4		/* POLL this node */
#define NODE_NR 8		/* NO-ROUTE this node */
#define NODE_SEND 16		/* is marked as SEND-TO */
#define NODE_HOLD 32		/* HOLD mail for this node */
#define NODE_SUCCESS 64		/* sucessful transmission */
#define NODE_PD 128		/* mail was picked up, dont send */

/* Message packet header. */

#define PKTVER 3		/* v11 = 2, v12 = 3 */

/* PUBLIC */

struct _pkthdr {
	int orig_number;	/* originating Node # */
	int dest_number;	/* destination node */
	int year,month,day,hour,minute,second;
	int rate;		/* OBS baud rate */
	int ver;		/* packet version */

	int orig_net;		/* v11 originating net number */
	int dest_net;		/* v11 destination net number */
	char product;		/* v11 product type */
	char x1;		/* v11 extra byte */

	int orig_zone;		/* v12 originating zone */
	int dest_zone;		/* v12 destination zone */

	char extra[28];		/* extra bytes */
};


/* Scheduled events, tag definitions. */

#define MIN_EVENT 'A'		/* minimum result to trigger an event */
#define MAX_EVENT 'W'		/* maximum */
#define EXT_EVENT 'X'		/* return to DOS event */
#define YELL_EVENT 'Y'		/* Yell command enable */
#define EXI_EVENT '!'		/* terminate via 0 command */

#define MINS_HR	60		/* minutes in an hour */
#define DAYS_WK 7		/* days in a week */
#define MINS_DAY (24 * 60)	/* minutes in an hour */
#define MINS_WK (MINS_DAY * DAYS_WK)

#define SCHEDS (5 * DAYS_WK)	/* size of time table */

/* Standard time of day structure. */

struct _time {
	int year,month,day,daywk;
	int hour,mins,sec;
};

/* Scheduler time structure. */

struct _sched {
	struct _time time;
	int len;
	int enable;		/* 1 == enabled -1 == disabled 0 == deleted */
	int trigger;
	int result;		/* returned value */
	char tag;		/* schedule tag */
	int a,b,c,d,e;

};
