#include "fido.h"
#include "fidomem.h"
#include <xfbuf.h>
#include "proto.h"

/* Clear all IN-TRANSIT and ORPHAN message bits. */

void clearmsg() {
char name[SS];
struct _xfbuf xfbuf;
int n,i;

	makemname(name,"*.MSG");				/* setup for raw */
	i= 0; xfbuf.s_attrib= 0; 				/* msg file search */
	while (_find(name,i++,&xfbuf)) {			/* take em as we find em */
		n= findmsg(atoi(xfbuf.name),0);			/* load the msg */
		if (! n) continue;				/* huh? */
		if (msg.attr & (MSGFWD | MSGORPHAN)) {
			msg.attr &= ~(MSGORPHAN | MSGFWD);
			wrtmsg();				/* zap ORPHAN and IN TRANSIT */
		}
		closemsg();
	}
}

/* After successful transmission of a packet to a given node, mark
all messages to the given node as SENT. The destination node numbers get
translated through the routing list, so do it here also. Note that only 
messages with MSGFWD (IN TRANSIT) are so marked; messages to the given
node may have been entered since the other messages were packeted and sent.

If we forwarded any messages, delete those, of course. */

void markmsg(m)
struct _node *m;
{
struct _node nd;
int i,n,t;
char name[SS];
struct _xfbuf xfbuf;

	cpy_node(&nd,m);					/* make a safe copy */

	makemname(name,"*.MSG");				/* setup for raw */
	t= 0; xfbuf.s_attrib= 0; 				/* msg file search */
	while (_find(name,t++,&xfbuf)) {			/* take em as we find em */
		i= findmsg(atoi(xfbuf.name),0);			/* load the msg */
		if (! i) continue;

/* Ignore messages already marked (SENT), and messages not marked (IN TRANSIT);
the latter are messages destined to this node, but entered after the packet we
are now processing was created -- they have NOT been sent yet! */

		if (!(msg.attr & MSGFWD) || (msg.attr & MSGSENT)) {
			n= -1;					/* not active this sched */

		} else n= out_xlate();				/* check dest */

		if (n > 0) {					/* if sendable, */
			if (same_node(&nmap.node,&nd)) {
				clprintf(0,"    Msg #%d --> %s ",i,str_node(&msg_dest));

				if (! is_us(&msg_orig)) {
					killmailmsg(i);
					clprintf(SM+209);	/* in transit killed */

				} else if (msg.attr & MSGKILL) { /* if marked KILL */
					killmailmsg(i);		/* kill it */
					clprintf(SM+212);	/* kill/sent */

				} else {			/* originated here */
					msg.attr |= MSGSENT;	/* mark as SENT */
					msg.attr &= ~(MSGORPHAN | MSGFWD);
					wrtmsg();		/* zap ORPHAN and IN TRANSIT */
					clprintf(SM+214);	/* "sent" */
				}
			}
		}
		closemsg();
	}
}

static killmailmsg(msgnbr)
int msgnbr;
{
int reply,up,thisn;

	closemsg();			/* close it first */

	up= msg.up;
	reply= msg.reply;		/* get pointers, */
	killmsg(msgnbr);		/* delete msg, */
	msg.reply= 0;			/* (in case not found) */
	msg.up= 0;

/* Now fix the reply pointers. If this msg had a reply, change the reply to
point to the deleted msgs reply number. (If 0, no reply) */

	if (up) {			/* if it had a reply, */
		if (thisn= findmsg(up,0)) { /* and correct #, */
			if (msg.reply == msgnbr) {
				if (reply == thisn) msg.reply= 0;
				else msg.reply= reply;
				wrtmsg();
			}
		}
		closemsg();
	}

/* If this msg was a reply, then change the replied to's msg up pointer to
point to the ext in the chain. (If 0, then no chain.) */

	if (reply) {
		if (thisn= findmsg(reply,0)) {
			if (msg.up == msgnbr) {
				if (up == thisn) msg.up= 0;
				else msg.up= up;
				wrtmsg();
			}
		}
		closemsg();
	} 
}
