#include "fido.h"
#include "fidomem.h"
#include "proto.h"

extern char banner[];

/* Fido Main Menu. Dispatch to system type commands, or the
message and file areas. */

void main_menu() {

int i;
char *cp;

	while (1) {
		if (! isargs()) mcrlf();		/* separates commands */
		switch (prompt(fido.cmd.main,CM+32,"main.hlp",0)) {
			case 2: msg_menu(); break;
			case 3: file_menu(); break;
			case 4: bulletins(); break;
			case 5: stats(0); break;
			case 6: switches(); break;
			case 7: change(); break;
			case 8: chat(); break;
			case 9: callers(); break;
			case 10: if (! question("mainsect.qes","mainsect.ans")) 
					mprintf(CM+37); break;

			case 11: mprintf(0,"%sFido/FidoNet %d%c\377",banner,FIDOVER,96+FILEVER); 
				break;

			case 12: dosexit1(); break;
			case 13: dosexit2(); break;
			case 14: goodbye(""); break;
		}
	}
}

/* Exit to MSDOS */

static dosexit1() {

	if (fido.outcode > 0) {
		mprintf(CM+38);
		lprintf(LM+15);
		logoff(fido.outcode,0);

	} else mprintf(CM+39);
}
/* Exit to MSDOS */

static dosexit2() {

	if (fido.termcode > 0) {
		mprintf(CM+40);
		lprintf(LM+15);
		logoff(fido.termcode,0);

	} else mprintf(CM+41);
}

