#include "fido.h"
#include "fidomem.h"
#include <xfbuf.h>
#include "proto.h"

#define BMAX 100	/* number of bulletins max */

/*
	Bulletin command for Fido.

Displays the active bulletin files and lets the caller pick & choose.
Each file number is displayed along with the first non-blank line from
each file. If there are no bulletin files, nothing is displayed.
Bulletin filenames are:

	BULLETIN.001		First (optional) bulletin ...
	...
	BULLETIN.009		... last bulletin

	This repeats until a blank line is entered.
*/

void bulletin() {

int i,f,n;
FLAG b[BMAX];		/* b[0] is number of bulletins */
int highest;		/* highest numbered bulletin */
char *cp,ln[SS],buff[SS];
struct _xfbuf xfbuf;
FLAG lang;		/* 0 == search TEXT path; 1 == search LANGUAGE path */

	for (i= 0; i < BMAX; i++) b[i]= 0;		/* none found yet */
	highest= n= 0;					/* b[0] is 0 ... */

/* Make a table of the bulletin files that exist. This makes one pass
for the text-path and the language path, if defined. If either file
(say BULLETIN.22) exists, the b[22] flag is set. If that bulletin is
later selected by the caller, opentf() tries the language-specific one
first, then the text-path default one. */

	lang= 0;					/* do text-path first */
	maketname(buff,"BULLETIN.*");

again:;	i= 0; xfbuf.s_attrib= 0;			/* find available */
	while (_find(buff,i++,&xfbuf)) {		/* bulletin files */
		for (cp= xfbuf.name; *cp; cp++) {	/* find its number */
			if (*cp == '.') {		/* must be .1 - .99 */
				n= atoi(++cp);
				if ((n < BMAX) && (n > 0)) {
					b[n]= 1;	/* mark as available, */
					++b[0];		/* total bulletins */
					if (n > highest) highest= n;
				}
				break;
			}
		}
	}

/* Kludgey but easy: if we haven't checked the language-path, do so now. */

	if (!lang++ && *langpath) {			/* do it a 2nd time */
		makexname(buff,langpath,"BULLETIN.*");	/* with language path */
		goto again;
	}
	if (! b[0]) {
		if (!dispbbs("BULLETIN.BBS"))		/* display this, */
			mprintf(CM+11);			/* else "no bulletins" */
		return;
	}

/* Command loop. I know there's a lot of goto's lately, but why should I
duplicate code just to conform to somebody's arbitrary idea of "correct"?

A few things are unavoidably hard-coded here. [CR] is assumed to default to
M)ain-Menu; !*cp is taken as an explicit return. Also command 3, M)ain-Menu,
is coded as return in the switch(). */

	while (1) {					/* until aborted ... */
		if (! isargs()) {
			mprintf(CM+118,highest);	/* "Bulletin 1 - N" */
			sprompt(fido.cmd.bulletin,CM+116,3);/* 3 == M)ain-Menu */
			mprintf(CM+103);		/* "(?=help): " */
		}
		cp= getarg(FM+0);				/* get response */
		if (! *cp) return;			/* CR == last command ... */

		if (isdigit(*cp)) {
			n= atoi(cp);
			if (n < 1) continue;		/* at least 1 */
			sprintf(ln,0,"BULLETIN.%d",n);	/* make bulletin name, */
			dispbbs(ln);			/* display it (no display if it doesnt exist), */
			mcrlf();
			continue;
		}
		i= is_cmd(*cp,fido.cmd.bulletin);
		if (cp[1] == '?') help(cp,fido.cmd.bulletin,"BULLETIN.HLP");
		else switch (i) {
			case 0: 
				mprintf(CM+36,*cp);		/* "not a command" */
				cmdflush();
				break;
			case 1:
				help("",fido.cmd.bulletin,"BULLETIN.HLP"); break;

			case 2:
list:;				abort= 0;
				for (i= 1; i < BMAX; i++) {	/* list all bulletins */
					if (abort) break;
					if (! b[i]) continue;	/* 0 == doesnt exist */

					sprintf(ln,0,"BULLETIN.%d",i);
					f= opentf(ln,0);	/* find/open bulletin */
					if (f == -1) {
						mprintf(CM+23,buff);
						lprintf(LM+31,buff); /* "not found!" */
						continue;
					}
					cp= "";			/* find first */
					while (rline(f,ln,sizeof(ln))) {
						cp= skip_delim(ln);/* non-blank line */
						if (*cp) break;
					}
					close(f);
					mprintf(0,"%2d) %s\377",i,cp);/* display this one, */
				}
				break;

			case 3:	return;
		}
	}
}
