/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*                          Opus!Comm definitions                           */
/*--------------------------------------------------------------------------*/

#ifdef NEVER
#define COM1            0
#define COM2            1
#define COM1_BASE       0x3f8
#define COM2_BASE       0x2f8
#define COM1_IMR	      0x10
#define COM2_IMR	      0x08
#define PASS_THRU_PORT  0x238
#define BITS_7          0x02
#define STOP_2	         0x04
#define ODD_PARITY      0x08
#define EVEN_PARITY     0x18
#define BAUD_150        0x020
#define BAUD_600        0x060
#define BAUD_19200      0x000
#define DELTA_CTS			0x01
#define DELTA_DSR			0x02
#define TRAIL_EDGE_RI	0x04
#define DELTA_CD			0x08
#define CTS					0x10 /* Bits for the Modem Status Register... */
#define DSR					0x20
#define RI					0x40
#define DCD					0x80    /* <--- some cheap modems use 0x20 for this */
#endif



#define BITS_8          0x03
#define STOP_1	         0x00
#define NO_PARITY       0x00
#define BAUD_300        0x040
#define BAUD_1200       0x080
#define BAUD_2400       0x0A0
#define BAUD_4800       0x0C0
#define BAUD_9600       0x0E0
#define BAUD_19200      0x000
#define BAUD_38400      0x020

/* Bit definitions for the Line Status Register */

#define DATA_READY	 	0x0100
#define OVERRUN_ERR	 	0x0200
#define PARITY_ERR	 	0x0400
#define FRAMING_ERR	 	0x0800
#define BREAK_INT		 	0x1000
#define TX_HOLD_EMPTY 	0x2000
#define TX_SHIFT_EMPTY	0x4000

/* Bit definitions for the driver flags */

#define USE_XON			0x01
#define USE_CTS			0x02
#define USE_DSR			0x04

#define BRK             0x01
#define MDM             0x02

struct CONTROL
	{
	int carrier_mask;
	int handshake_mask;
	};

extern struct CONTROL ctl;


/*--------------------------------------------------------------------------*/
/* MACROS that call the routines in COM_ASM                                 */
/*--------------------------------------------------------------------------*/
extern      Com_           (byte,...);
extern      Cominit        (byte);
extern  int pascal READBYTE();
#define M_INSTALL(b)       {Cominit(ctl.com_port);Com_(0x0f,0);Com_(0x0f,ctl.handshake_mask);new_baud(0,b);}


                           /*-----------------------------------------------*/
                           /* Service 0: SET BAUD(etc)                      */
                           /*-----------------------------------------------*/
#define MDM_ENABLE(b)      (Com_(0x00,b|NO_PARITY|STOP_1|BITS_8))

                           /*-----------------------------------------------*/
                           /* Service 1: SEND CHAR (wait)                   */
                           /*-----------------------------------------------*/
#define SENDBYTE(x)	   (Com_(0x01,x))
                           /*-----------------------------------------------*/
                           /* Service 2: GET CHAR (wait)                    */
                           /*-----------------------------------------------*/
#define MODEM_IN()         (Com_(0x02)&0x00ff)

                           /*-----------------------------------------------*/
                           /* Service 3: GET STATUS                         */
                           /*-----------------------------------------------*/
#define MODEM_STATUS()     (Com_(0x03))
#define CARRIER            (Com_(0x03)&ctl.carrier_mask)
#define CHAR_AVAIL()       (Com_(0x03)&DATA_READY)
#define OUT_EMPTY()        (Com_(0x03)&TX_SHIFT_EMPTY)
#define OUT_FULL()         (!(Com_(0x03)&TX_HOLD_EMPTY))

                           /*-----------------------------------------------*/
                           /* Service 4: INIT/INSTALL                       */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 5: UNINSTALL                          */
                           /*-----------------------------------------------*/
#define MDM_DISABLE()      (Com_(0x05,BAUD_2400|NO_PARITY|STOP_1|BITS_8))

                           /*-----------------------------------------------*/
                           /* Service 6: SET DTR                            */
                           /*-----------------------------------------------*/
#define DTR_OFF()          (Com_(0x06,0))
#define DTR_ON()           (Com_(0x06,1))

                           /*-----------------------------------------------*/
                           /* Service 7: GET TIMER TICK PARMS               */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 8: FLUSH OUTBOUND RING-BUFFER         */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 9: NUKE OUTBOUND RING-BUFFER          */
                           /*-----------------------------------------------*/
#define CLEAR_OUTBOUND()   (Com_(0x09))

                           /*-----------------------------------------------*/
                           /* Service a: NUKE INBOUND RING-BUFFER           */
                           /*-----------------------------------------------*/
#define CLEAR_INBOUND()    (Com_(0x0a))

                           /*-----------------------------------------------*/
                           /* Service b: SEND CHAR (no wait)                */
                           /*-----------------------------------------------*/
#define Com_Tx_NW(c)       (Com_(0x0b,c))

                           /*-----------------------------------------------*/
                           /* Service c: GET CHAR (no wait)                 */
                           /*-----------------------------------------------*/
#define PEEKBYTE()         (Com_(0x0c))

                           /*-----------------------------------------------*/
                           /* Service d: GET KEYBOARD STATUS                */
                           /*-----------------------------------------------*/
#define KEYPRESS()         (Com_(0x0d)!=(-1))
#define FOSSIL_PEEKKB()    (Com_(0x0d))

                           /*-----------------------------------------------*/
                           /* Service e: GET KEYBOARD CHARACTER (wait)      */
                           /*-----------------------------------------------*/
#define READKB()           (Com_(0x0e)&0xff)
#define READSCAN()         (Com_(0x0e))
#define FOSSIL_CHAR()      (Com_(0x0e))


                           /*-----------------------------------------------*/
                           /* Service f: SET/GET FLOW CONTROL STATUS        */
                           /*-----------------------------------------------*/
#define XON_ENABLE()       (Com_(0x0f,ctl.handshake_mask))
#define XON_DISABLE()      (Com_(0x0f,(ctl.handshake_mask&(~USE_XON))))

                           /*-----------------------------------------------*/
                           /* Service 10: SET/GET CTL-BREAK CONTROLS        */
                           /*             Note that the "break" here refers */
                           /*             to ^C and ^K rather than the      */
                           /*             tradition modem BREAK.            */
                           /*-----------------------------------------------*/
#define _BRK_ENABLE()      (Com_(0x10,BRK))
#define _BRK_DISABLE()     (Com_(0x10,0))
#define RECVD_BREAK()      (Com_(0x10,BRK)&BRK)

                           /*-----------------------------------------------*/
                           /* Service 11: SET LOCAL VIDEO CURSOR POSITION   */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 12: GET LOCAL VIDEO CURSOR POSITION   */
                           /*-----------------------------------------------*/

                           /*-----------------------------------------------*/
                           /* Service 13: WRITE LOCAL ANSI CHARACTER        */
                           /*-----------------------------------------------*/
#define WRITE_ANSI(c)	   (Com_(0x13,c))
                           /*-----------------------------------------------*/
                           /* Service 14: WATCHDOG on/off                   */
                           /*-----------------------------------------------*/
#define WATCHDOG(x)        (Com_(0x14,x))


/*--------------------------------------------------------------------------*/
/*                                                                          */
/* A no-stall ReadByte routine might look like this:                        */
/*                                                                          */
/*    int READBYTE()                                                        */
/*       begin                                                              */
/*          return( CHAR_AVAIL() ? MODEM_IN() : (-1) );                     */
/*       end                                                                */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/* END OF FILE: com.h */

