# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# Version: MPL 1.1 / GPLv3+ / LGPLv3+
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License or as specified alternatively below. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# Major Contributor(s):
# Copyright (C) 2011 Matúš Kukan <matus.kukan@gmail.com>
#
# All Rights Reserved.
#
# For minor contributions see the git repository.
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 3 or later (the "GPLv3+"), or
# the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
# in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
# instead of those above.

# Extension class

gb_Extension_ZIPCOMMAND := zip $(if $(findstring s,$(MAKEFLAGS)),-q)
ifeq ($(GUI),WNT)
gb_Extension_LICENSEFILE := license.txt
else
gb_Extension_LICENSEFILE := LICENSE
endif
gb_Extension_XRMEXTARGET := $(call gb_Executable_get_target_for_build,xrmex)
gb_Extension_XRMEXCOMMAND := \
	$(gb_Helper_set_ld_path) $(gb_Extension_XRMEXTARGET)
# propmerge is a perl script
gb_Extension_PROPMERGETARGET := $(OUTDIR_FOR_BUILD)/bin/propmerge
gb_Extension_PROPMERGECOMMAND := \
	$(PERL) $(gb_Extension_PROPMERGETARGET)
gb_Extension_HELPEXTARGET := $(call gb_Executable_get_target_for_build,helpex)
gb_Extension_HELPEXCOMMAND := \
	$(gb_Helper_set_ld_path) $(gb_Extension_HELPEXTARGET)
gb_Extension_HELPINDEXERTARGET := \
    $(call gb_Executable_get_target_for_build,HelpIndexer)
gb_Extension_HELPINDEXERCOMMAND := \
       $(gb_Helper_set_ld_path) $(gb_Extension_HELPINDEXERTARGET)
gb_Extension_HELPLINKERTARGET := \
    $(call gb_Executable_get_target_for_build,HelpLinker)
gb_Extension_HELPLINKERCOMMAND := \
       $(gb_Helper_set_ld_path) $(gb_Extension_HELPLINKERTARGET)
# does not contain en-US because it is special cased in gb_Extension_Extension
gb_Extension_TRANS_LANGS := $(filter-out en-US,$(gb_WITH_LANG))
gb_Extension_ALL_LANGS := en-US $(gb_Extension_TRANS_LANGS)

# Substitute platform or copy if no platform has been set
define gb_Extension__subst_platform
$(if $(PLATFORM),\
	sed \
		-e 's/@PLATFORM@/$(PLATFORM)/' \
		-e 's/@EXEC_EXTENSION@/$(gb_Executable_EXT)/' \
		-e 's/@SHARED_EXTENSION@/$(gb_Library_DLLEXT)/' \
		$(1) > $(2),\
	cp -f $(1) $(2))
endef

$(call gb_Extension_get_workdir,%)/.dir :
	$(if $(wildcard $(dir $@)),,mkdir -p $(dir $@))

# remove extension directory in workdir and oxt file in workdir and outdir
$(call gb_Extension_get_clean_target,%) :
	$(call gb_Output_announce,$*,$(false),OXT,3)
	$(call gb_Helper_abbreviate_dirs,\
		rm -f -r $(call gb_Extension_get_workdir,$*) && \
		rm -f $(call gb_Extension_get_target,$*) && \
		rm -f $(call gb_Extension_get_outdir_target,$*))

ifeq ($(strip $(gb_WITH_LANG)),)
$(call gb_Extension_get_workdir,%)/description.xml :
	$(call gb_Output_announce,$*/description.xml,$(true),CPY,3)
	$(call gb_Helper_abbreviate_dirs,\
		mkdir -p $(call gb_Extension_get_workdir,$*) && \
		cp -f $(LOCATION)/description.xml $@)
else
$(call gb_Extension_get_workdir,%)/description.xml : $(gb_Extension_XRMEXTARGET)
	$(call gb_Output_announce,$*/description.xml,$(true),XRM,3)
	$(call gb_Helper_abbreviate_dirs,\
		mkdir -p $(call gb_Extension_get_workdir,$*) && \
		$(gb_Extension_XRMEXCOMMAND) \
			-p $(PRJNAME) \
			-i $(filter %.xml,$^) \
			-o $@ \
			-m $(SDF) \
			-l all)
endif

# rule to create oxt package in workdir
# --filesync makes sure that all files in the oxt package will be removed that no longer are in $(FILES)
$(call gb_Extension_get_target,%) : \
		$(call gb_Extension_get_workdir,%)/description.xml
	$(call gb_Output_announce,$*,$(true),OXT,3)
	$(call gb_Helper_abbreviate_dirs,\
		mkdir -p $(call gb_Extension_get_rootdir,$*)/META-INF \
			$(call gb_Extension_get_rootdir,$*)/registration && \
		$(call gb_Extension__subst_platform,$(call gb_Extension_get_workdir,$*)/description.xml,$(call gb_Extension_get_rootdir,$*)/description.xml) && \
		$(call gb_Extension__subst_platform,$(LOCATION)/manifest.xml,$(call gb_Extension_get_rootdir,$*)/META-INF/manifest.xml) && \
		cp -f $(OUTDIR)/bin/osl/$(gb_Extension_LICENSEFILE) $(call gb_Extension_get_rootdir,$*)/registration && \
		$(if $(gb_WITH_LANG),cp $(foreach lang,$(gb_Extension_TRANS_LANGS),$(call gb_Extension_get_workdir,$*)/description-$(lang).txt) $(call gb_Extension_get_rootdir,$*) &&) \
		cd $(call gb_Extension_get_rootdir,$*) && \
		$(gb_Extension_ZIPCOMMAND) -rX --filesync \
			$(call gb_Extension_get_target,$*) \
			$(sort $(FILES)))

# TODO: needs dependency on $(OUTDIR)/bin/osl/$(gb_Extension_LICENSEFILE) once readlicense_oo will be gbuildized
# or just another simpler solution

# set file list and location of manifest and description files
# register target and clean target
# add deliverable
# add dependency for outdir target to workdir target (pattern rule for delivery is in Package.mk)
define gb_Extension_Extension
$(call gb_Extension_get_target,$(1)) : FILES := META-INF description.xml registration
$(call gb_Extension_get_target,$(1)) : LOCATION := $(SRCDIR)/$(2)
$(call gb_Extension_get_target,$(1)) : PLATFORM :=
$(call gb_Extension_get_target,$(1)) : PRJNAME := $(firstword $(subst /, ,$(2)))
$(call gb_Extension_get_workdir,$(1))/description.xml : $(SRCDIR)/$(2)/description.xml
ifneq ($(strip $(gb_WITH_LANG)),)
$(call gb_Extension_get_target,$(1)) : FILES += $(foreach lang,$(gb_Extension_TRANS_LANGS),description-$(lang).txt)
$(call gb_Extension_get_target,$(1)) : SDF := $(gb_SDFLOCATION)/$(2)/localize.sdf
$(call gb_Extension_get_workdir,$(1))/description.xml : $$(SDF)
endif
$(call gb_Extension_add_file,$(1),description-en-US.txt,$(SRCDIR)/$(2)/description-en-US.txt)
$(eval $(call gb_Module_register_target,$(call gb_Extension_get_outdir_target,$(1)),$(call gb_Extension_get_clean_target,$(1))))
$(call gb_Deliver_add_deliverable,$(call gb_Extension_get_outdir_target,$(1)),$(call gb_Extension_get_target,$(1)),$(1))
$(call gb_Extension_get_outdir_target,$(1)) : $(call gb_Extension_get_target,$(1))

$(foreach lang,$(gb_Extension_ALL_LANGS), \
    $(call gb_Extension__compile_help_onelang,$(1),$(lang)))
endef

# Set platform.
#
# Only use this if the extension is platform-dependent.
define gb_Extension_set_platform
$(call gb_Extension_get_target,$(1)) : PLATFORM := $(2)

endef

# adding a file creates a dependency to it
# file is copied to $(WORKDIR)
# $(3) is the target of the copied file, and $(4) can be used to override that
# with a different actual file, which is needed in gb_Extension_add_library
# to make it work on Windows where the DLL doesn't have a gbuild target...
define gb_Extension_add_file
$(call gb_Extension_get_target,$(1)) : FILES += $(2)
$(call gb_Extension_get_target,$(1)) : $(call gb_Extension_get_rootdir,$(1))/$(2)
$(call gb_Extension_get_rootdir,$(1))/$(2) : $(3)
	mkdir -p $$(dir $$@) && \
	cp -f $(if $(4),$(4),$(3)) $$@

endef

# Add several files at once
#
# This function avoids the need to specify each file's name twice. The
# files are added directly under specified path in the extension,
# without any subpath. If no path is specified, they are added directly
# to the root dir of the extension.
define gb_Extension_add_files
$(foreach file,$(3),$(call gb_Extension_add_file,$(1),$(if $(strip $(2)),$(strip $(2))/)$(notdir $(file)),$(file)))

endef

# add a library from the solver; DO NOT use gb_Library_get_target
define gb_Extension_add_library
$(call gb_Extension_add_file,$(1),$(call gb_Library_get_runtime_filename,$(2)),\
	$(call gb_Library_get_target,$(2)),\
	$(gb_Helper_OUTDIRLIBDIR)/$(call gb_Library_get_runtime_filename,$(2)))
endef

define gb_Extension_add_libraries
$(foreach lib,$(2),$(call gb_Extension_add_library,$(1),$(lib)))
endef

# add an executable from the solver
define gb_Extension_add_executable
$(call gb_Extension_add_file,$(1),$(notdir $(call gb_Executable_get_target,$(2))),\
	$(call gb_Executable_get_target,$(2)),\
	$(call gb_Executable_get_target,$(2)))
endef

define gb_Extension_add_executables
$(foreach exe,$(2),$(call gb_Extension_add_executable,$(1),$(exe)))
endef

# localize .properties file
# source file is copied to $(WORKDIR)
define gb_Extension_localize_properties
$(call gb_Extension_get_target,$(1)) : FILES += $(2)
ifneq ($(strip $(gb_WITH_LANG)),)
$(call gb_Extension_get_target,$(1)) : FILES += $(foreach lang,$(subst -,_,$(gb_Extension_TRANS_LANGS)),$(subst en_US,$(lang),$(2)))
$(call gb_Extension_get_rootdir,$(1))/$(2) : SDF := $(gb_SDFLOCATION)$(subst $(SRCDIR),,$(dir $(3)))localize.sdf
$(call gb_Extension_get_rootdir,$(1))/$(2) : $$(SDF)
endif
$(call gb_Extension_get_target,$(1)) : $(call gb_Extension_get_rootdir,$(1))/$(2)
$(call gb_Extension_get_rootdir,$(1))/$(2) : $(3) \
		$(gb_Extension_PROPMERGETARGET)
	$$(call gb_Output_announce,$(2),$(true),PRP,3)
	mkdir -p $$(dir $$@) && \
	cp -f $$< $$@ \
	$(if $(strip $(gb_WITH_LANG)),&& $(gb_Extension_PROPMERGECOMMAND) -i $$@ -m $$(SDF))

endef

# add an .xhp help file, to be localized and compiled
# $(1): extension identifier
# $(2): absolute path prefix of en-US source file without $(3) (resp. $(4))
#     suffix
# $(3): relative path of (target) .xhp file (e.g.,
#     com.sun.wiki-publisher/wiki.xhp)
# $(4): optional relative path of source .xhp file, when it differs from $(3)
#     (i.e., if $(4) is empty the en-US source file is $(2)/$(3), otherwise it
#     is $(2)/$(4))
define gb_Extension_add_helpfile
$(foreach lang,$(gb_Extension_ALL_LANGS), \
    $(call gb_Extension__localize_helpfile_onelang,$(1),$(2),$(3),$(4),$(lang)) \
    $(call gb_Extension__add_compiled_help_dependency_onelang,$(1),$(lang)))
endef

# add a list of .xhp help files, to be localized and compiled
# $(1): extension identifier
# $(2): absolute path prefix of en-US source files without $(3) suffixes
# $(3): list of relative paths of .xhp files (see gb_Extension_add_helpfile)
define gb_Extension_add_helpfiles
$(foreach helpfile,$(3), \
    $(call gb_Extension_add_helpfile,$(1),$(2),$(helpfile),))
endef

# localize one .xhp help file for one language; the result is stored as
# help/$(4)/$(3) in the extension's workdir; as a special case, if $(4) is
# "en-US", the source file is just copied, not passed through helpex
# $(1): extension identifier
# $(2): absolute path prefix of en-US source file without $(3) (resp. $(4))
#     suffix
# $(3): relative path of (target) .xhp file (see gb_Extension_add_helpfile)
# $(4): optional relative path of source .xhp file (see
#     gb_Extension_add_helpfile)
# $(5): language
define gb_Extension__localize_helpfile_onelang
$(call gb_Extension_get_rootdir,$(1))/help/$(5).done : HELPFILES += $(3)
$(call gb_Extension_get_rootdir,$(1))/help/$(5).done : \
        $(call gb_Extension_get_workdir,$(1))/help/$(5)/$(3)
$(call gb_Extension_get_workdir,$(1))/help/$(5)/$(3) : \
        SDF := $(gb_SDFLOCATION)$(subst $(SRCDIR),,$(subst $(WORKDIR)/CustomTarget,,$(2)/$(dir $(or $(4),$(3)))))localize.sdf
$(call gb_Extension_get_workdir,$(1))/help/$(5)/$(3) : $$(SDF)
$(call gb_Extension_get_workdir,$(1))/help/$(5)/$(3) : \
        $(if $(filter-out en-US,$(5)),$(gb_Extension_HELPEXTARGET)) | \
        $(call gb_Extension_get_workdir,$(1))/help/.dir
$(call gb_Extension_get_workdir,$(1))/help/$(5)/$(3) : \
        $(2)/$(or $(4),$(3))
	$$(call gb_Output_announce,$(1) $(3) $(5),$(true),XHP,3)
	$$(call gb_Helper_abbreviate_dirs, \
        mkdir -p $$(dir $$@) && \
        $(if $(filter-out en-US,$(5)), \
            $(gb_Extension_HELPEXCOMMAND) -i $$< -o $$@ -l $(5) -m $$(SDF), \
            cp $$< $$@))

endef

# compile help for one language; the result is stored as help/$(3)/ in the
# extension's rootdir and marked for zipping into the .oxt
# $(1): extension identifier
# $(2): language
# Target-specific HELPFILES: list of relative paths of .xhp files (see
#     gb_Extension_add_helpfile)
define gb_Extension__compile_help_onelang
$(call gb_Extension_get_rootdir,$(1))/help/$(2).done : \
        $(gb_Extension_HELPINDEXERTARGET) \
        $(gb_Extension_HELPLINKERTARGET) \
        $(OUTDIR_FOR_BUILD)/bin/embed.xsl \
        $(OUTDIR_FOR_BUILD)/bin/idxcaption.xsl \
        $(OUTDIR_FOR_BUILD)/bin/idxcontent.xsl | \
        $(call gb_Extension_get_rootdir,$(1))/help/.dir
	$$(call gb_Output_announce,$(1) $(2),$(true),XHC,3)
	$$(call gb_Helper_abbreviate_dirs, \
        rm -rf $$(basename $$@) && \
        mkdir $$(basename $$@) && \
        $(gb_Extension_HELPLINKERCOMMAND) -mod help \
            -extlangsrc $(call gb_Extension_get_workdir,$(1))/help/$(2) \
            -sty $(OUTDIR_FOR_BUILD)/bin/embed.xsl \
            -extlangdest $$(basename $$@) \
            -idxcaption $(OUTDIR_FOR_BUILD)/bin/idxcaption.xsl \
            -idxcontent $(OUTDIR_FOR_BUILD)/bin/idxcontent.xsl \
            $$(HELPFILES) && \
        (cd $(call gb_Extension_get_workdir,$(1))/help/$(2) && \
            $(gb_Extension_ZIPCOMMAND) -r $$(basename $$@)/help.jar \
            $$(HELPFILES)) && \
        $(gb_Extension_HELPINDEXERCOMMAND) -lang $(2) -mod help \
            -dir $$(basename $$@) && \
        touch $$@)

endef

# establish the dependency that actually causes inclusion of the compiled help
# into the .oxt, for one language; in principle, this would only need to be done
# once per language iff the extension uses any help -- currently it is done from
# each individual gb_Extension_add_helpfile call (and thus requires $strip
# to remove duplicates from FILES)
# $(1): extension identifier
# $(2): language
define gb_Extension__add_compiled_help_dependency_onelang
$(call gb_Extension_get_target,$(1)) : FILES += help/$(2)
$(call gb_Extension_get_target,$(1)) : \
        $(call gb_Extension_get_rootdir,$(1))/help/$(2).done

endef

define gb_Extension_add_package_dependency
$$(call gb_Output_error,\
 gb_Extension_add_package_dependency: use gb_Extension_use_package instead.)
endef

define gb_Extension_use_package
$(call gb_Extension_get_target,$(1)) : $(call gb_Package_get_target,$(2))

endef

define gb_Extension_add_package_dependencies
$$(call gb_Output_error,\
 gb_Extension_add_package_dependencies: use gb_Extension_use_packages instead.)
endef

define gb_Extension_use_packages
$(foreach package,$(2),$(call gb_Extension_use_package,$(1),$(package)))

endef

# vim: set noet sw=4 ts=4:
