/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class EncryptedPrivateKeyInfo {
    private AlgorithmId algid;
    private byte[] encryptedData;
    private byte[] encoded;

    public EncryptedPrivateKeyInfo(byte[] encoded) throws IOException {
        if (encoded == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        DerValue val = new DerValue(encoded);
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new IOException("overrun, bytes = " + val.data.available());
        }
        this.algid = AlgorithmId.parse(seq[0]);
        if (seq[0].data.available() != 0) {
            throw new IOException("encryptionAlgorithm field overrun");
        }
        this.encryptedData = seq[1].getOctetString();
        if (seq[1].data.available() != 0) {
            throw new IOException("encryptedData field overrun");
        }
        this.encoded = (byte[])encoded.clone();
    }

    public EncryptedPrivateKeyInfo(AlgorithmId algid, byte[] encryptedData) {
        this.algid = algid;
        this.encryptedData = (byte[])encryptedData.clone();
    }

    public AlgorithmId getAlgorithm() {
        return this.algid;
    }

    public byte[] getEncryptedData() {
        return (byte[])this.encryptedData.clone();
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.algid.encode(tmp);
        tmp.putOctetString(this.encryptedData);
        out.write((byte)48, tmp);
        this.encoded = out.toByteArray();
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptedPrivateKeyInfo)) {
            return false;
        }
        try {
            byte[] thisEncrInfo = this.getEncoded();
            byte[] otherEncrInfo = ((EncryptedPrivateKeyInfo)other).getEncoded();
            if (thisEncrInfo.length != otherEncrInfo.length) {
                return false;
            }
            for (int i = 0; i < thisEncrInfo.length; ++i) {
                if (thisEncrInfo[i] == otherEncrInfo[i]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 0; i < this.encryptedData.length; ++i) {
            retval += this.encryptedData[i] * i;
        }
        return retval;
    }
}

