/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCRep;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;

public class Credentials {
    PrincipalName cname;
    PrincipalName sname;
    EncryptionKey key;
    KerberosTime authtime;
    KerberosTime starttime;
    KerberosTime endtime;
    KerberosTime renewTill;
    HostAddresses caddr;
    AuthorizationData authorizationData;
    public boolean isEncInSKey;
    TicketFlags flags;
    Ticket ticket;
    Ticket secondTicket;
    private boolean DEBUG = Krb5.DEBUG;

    public Credentials(PrincipalName new_cname, PrincipalName new_sname, EncryptionKey new_key, KerberosTime new_authtime, KerberosTime new_starttime, KerberosTime new_endtime, KerberosTime new_renewTill, boolean new_isEncInSKey, TicketFlags new_flags, HostAddresses new_caddr, AuthorizationData new_authData, Ticket new_ticket, Ticket new_secondTicket) {
        this.cname = (PrincipalName)new_cname.clone();
        this.sname = (PrincipalName)new_sname.clone();
        this.key = (EncryptionKey)new_key.clone();
        this.authtime = new_authtime;
        this.starttime = new_starttime;
        this.endtime = new_endtime;
        this.renewTill = new_renewTill;
        if (new_caddr != null) {
            this.caddr = (HostAddresses)new_caddr.clone();
        }
        if (new_authData != null) {
            this.authorizationData = (AuthorizationData)new_authData.clone();
        }
        this.isEncInSKey = new_isEncInSKey;
        this.flags = (TicketFlags)new_flags.clone();
        this.ticket = (Ticket)new_ticket.clone();
        if (new_secondTicket != null) {
            this.secondTicket = (Ticket)new_secondTicket.clone();
        }
    }

    public Credentials(KDCRep kdcRep, Ticket new_secondTicket, AuthorizationData new_authorizationData, boolean new_isEncInSKey) {
        if (kdcRep.encKDCRepPart == null) {
            return;
        }
        this.cname = (PrincipalName)kdcRep.cname.clone();
        this.ticket = (Ticket)kdcRep.ticket.clone();
        this.key = (EncryptionKey)kdcRep.encKDCRepPart.key.clone();
        this.flags = (TicketFlags)kdcRep.encKDCRepPart.flags.clone();
        this.authtime = kdcRep.encKDCRepPart.authtime;
        this.starttime = kdcRep.encKDCRepPart.starttime;
        this.endtime = kdcRep.encKDCRepPart.endtime;
        this.renewTill = kdcRep.encKDCRepPart.renewTill;
        this.sname = (PrincipalName)kdcRep.encKDCRepPart.sname.clone();
        this.caddr = (HostAddresses)kdcRep.encKDCRepPart.caddr.clone();
        this.secondTicket = (Ticket)new_secondTicket.clone();
        this.authorizationData = (AuthorizationData)new_authorizationData.clone();
        this.isEncInSKey = new_isEncInSKey;
    }

    public Credentials(KDCRep kdcRep) {
        this(kdcRep, null);
    }

    public Credentials(KDCRep kdcRep, Ticket new_ticket) {
        this.sname = (PrincipalName)kdcRep.encKDCRepPart.sname.clone();
        this.cname = (PrincipalName)kdcRep.cname.clone();
        this.key = (EncryptionKey)kdcRep.encKDCRepPart.key.clone();
        this.authtime = kdcRep.encKDCRepPart.authtime;
        this.starttime = kdcRep.encKDCRepPart.starttime;
        this.endtime = kdcRep.encKDCRepPart.endtime;
        this.renewTill = kdcRep.encKDCRepPart.renewTill;
        this.flags = kdcRep.encKDCRepPart.flags;
        this.caddr = kdcRep.encKDCRepPart.caddr != null ? (HostAddresses)kdcRep.encKDCRepPart.caddr.clone() : null;
        this.ticket = (Ticket)kdcRep.ticket.clone();
        if (new_ticket != null) {
            this.secondTicket = (Ticket)new_ticket.clone();
            this.isEncInSKey = true;
        } else {
            this.secondTicket = null;
            this.isEncInSKey = false;
        }
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.endtime.getTime() < System.currentTimeMillis()) {
            valid = false;
        } else if (this.starttime != null) {
            if (this.starttime.getTime() > System.currentTimeMillis()) {
                valid = false;
            }
        } else if (this.authtime.getTime() > System.currentTimeMillis()) {
            valid = false;
        }
        return valid;
    }

    public PrincipalName getServicePrincipal() throws RealmException {
        return this.sname;
    }

    public sun.security.krb5.Credentials setKrbCreds() {
        return new sun.security.krb5.Credentials(this.ticket, this.cname, this.sname, this.key, this.flags, this.authtime, this.starttime, this.endtime, this.renewTill, this.caddr);
    }

    public KerberosTime getStartTime() {
        return this.starttime;
    }

    public KerberosTime getAuthTime() {
        return this.authtime;
    }

    public KerberosTime getEndTime() {
        return this.endtime;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public int getEType() {
        return this.key.getEType();
    }

    public int getTktEType() {
        return this.ticket.encPart.getEType();
    }
}

