/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import javax.management.openmbean.CompositeData;
import sun.management.ManagementFactoryHelper;
import sun.management.ThreadInfoCompositeData;

public class ThreadInfo {
    private String threadName;
    private long threadId;
    private long blockedTime;
    private long blockedCount;
    private long waitedTime;
    private long waitedCount;
    private LockInfo lock;
    private String lockName;
    private long lockOwnerId;
    private String lockOwnerName;
    private boolean inNative;
    private boolean suspended;
    private Thread.State threadState;
    private StackTraceElement[] stackTrace;
    private MonitorInfo[] lockedMonitors;
    private LockInfo[] lockedSynchronizers;
    private static MonitorInfo[] EMPTY_MONITORS = new MonitorInfo[0];
    private static LockInfo[] EMPTY_SYNCS = new LockInfo[0];
    private static final int MAX_FRAMES = 8;
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];

    private ThreadInfo(Thread t, int state, Object lockObj, Thread lockOwner, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace) {
        this.initialize(t, state, lockObj, lockOwner, blockedCount, blockedTime, waitedCount, waitedTime, stackTrace, EMPTY_MONITORS, EMPTY_SYNCS);
    }

    private ThreadInfo(Thread t, int state, Object lockObj, Thread lockOwner, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace, Object[] monitors, int[] stackDepths, Object[] synchronizers) {
        LockInfo[] lockedSynchronizers;
        int numSyncs;
        MonitorInfo[] lockedMonitors;
        int numMonitors;
        int n = numMonitors = monitors == null ? 0 : monitors.length;
        if (numMonitors == 0) {
            lockedMonitors = EMPTY_MONITORS;
        } else {
            lockedMonitors = new MonitorInfo[numMonitors];
            for (int i = 0; i < numMonitors; ++i) {
                Object lock = monitors[i];
                String className = lock.getClass().getName();
                int identityHashCode = System.identityHashCode(lock);
                int depth = stackDepths[i];
                StackTraceElement ste = depth >= 0 ? stackTrace[depth] : null;
                lockedMonitors[i] = new MonitorInfo(className, identityHashCode, depth, ste);
            }
        }
        int n2 = numSyncs = synchronizers == null ? 0 : synchronizers.length;
        if (numSyncs == 0) {
            lockedSynchronizers = EMPTY_SYNCS;
        } else {
            lockedSynchronizers = new LockInfo[numSyncs];
            for (int i = 0; i < numSyncs; ++i) {
                Object lock = synchronizers[i];
                String className = lock.getClass().getName();
                int identityHashCode = System.identityHashCode(lock);
                lockedSynchronizers[i] = new LockInfo(className, identityHashCode);
            }
        }
        this.initialize(t, state, lockObj, lockOwner, blockedCount, blockedTime, waitedCount, waitedTime, stackTrace, lockedMonitors, lockedSynchronizers);
    }

    private void initialize(Thread t, int state, Object lockObj, Thread lockOwner, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        this.threadId = t.getId();
        this.threadName = t.getName();
        this.threadState = ManagementFactoryHelper.toThreadState(state);
        this.suspended = ManagementFactoryHelper.isThreadSuspended(state);
        this.inNative = ManagementFactoryHelper.isThreadRunningNative(state);
        this.blockedCount = blockedCount;
        this.blockedTime = blockedTime;
        this.waitedCount = waitedCount;
        this.waitedTime = waitedTime;
        if (lockObj == null) {
            this.lock = null;
            this.lockName = null;
        } else {
            this.lock = new LockInfo(lockObj);
            this.lockName = this.lock.getClassName() + '@' + Integer.toHexString(this.lock.getIdentityHashCode());
        }
        if (lockOwner == null) {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        } else {
            this.lockOwnerId = lockOwner.getId();
            this.lockOwnerName = lockOwner.getName();
        }
        this.stackTrace = stackTrace == null ? NO_STACK_TRACE : stackTrace;
        this.lockedMonitors = lockedMonitors;
        this.lockedSynchronizers = lockedSynchronizers;
    }

    private ThreadInfo(CompositeData cd) {
        ThreadInfoCompositeData ticd = ThreadInfoCompositeData.getInstance(cd);
        this.threadId = ticd.threadId();
        this.threadName = ticd.threadName();
        this.blockedTime = ticd.blockedTime();
        this.blockedCount = ticd.blockedCount();
        this.waitedTime = ticd.waitedTime();
        this.waitedCount = ticd.waitedCount();
        this.lockName = ticd.lockName();
        this.lockOwnerId = ticd.lockOwnerId();
        this.lockOwnerName = ticd.lockOwnerName();
        this.threadState = ticd.threadState();
        this.suspended = ticd.suspended();
        this.inNative = ticd.inNative();
        this.stackTrace = ticd.stackTrace();
        if (ticd.isCurrentVersion()) {
            this.lock = ticd.lockInfo();
            this.lockedMonitors = ticd.lockedMonitors();
            this.lockedSynchronizers = ticd.lockedSynchronizers();
        } else {
            if (this.lockName != null) {
                String[] result = this.lockName.split("@");
                if (result.length == 2) {
                    int identityHashCode = Integer.parseInt(result[1], 16);
                    this.lock = new LockInfo(result[0], identityHashCode);
                } else {
                    assert (result.length == 2);
                    this.lock = null;
                }
            } else {
                this.lock = null;
            }
            this.lockedMonitors = EMPTY_MONITORS;
            this.lockedSynchronizers = EMPTY_SYNCS;
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public LockInfo getLockInfo() {
        return this.lock;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public String toString() {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + this.getThreadName() + "\"" + " Id=" + this.getThreadId() + " " + (Object)((Object)this.getThreadState()));
        if (this.getLockName() != null) {
            sb.append(" on " + this.getLockName());
        }
        if (this.getLockOwnerName() != null) {
            sb.append(" owned by \"" + this.getLockOwnerName() + "\" Id=" + this.getLockOwnerId());
        }
        if (this.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (this.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < this.stackTrace.length && i < 8; ++i) {
            StackTraceElement ste = this.stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && this.getLockInfo() != null) {
                Thread.State ts = this.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + this.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + this.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + this.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : this.lockedMonitors) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + lockInfo);
                sb.append('\n');
            }
        }
        if (i < this.stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = this.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static ThreadInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof ThreadInfoCompositeData) {
            return ((ThreadInfoCompositeData)cd).getThreadInfo();
        }
        return new ThreadInfo(cd);
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }
}

