/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.IOException;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.JNIHandles;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.HeapGraphWriter;

public abstract class AbstractHeapGraphWriter
implements HeapGraphWriter {
    protected Symbol javaLangClass;
    protected Symbol javaLangString;
    protected Symbol javaLangThread;

    protected void write() throws IOException {
        SymbolTable symTbl = VM.getVM().getSymbolTable();
        this.javaLangClass = symTbl.probe("java/lang/Class");
        this.javaLangString = symTbl.probe("java/lang/String");
        this.javaLangThread = symTbl.probe("java/lang/Thread");
        ObjectHeap heap = VM.getVM().getObjectHeap();
        try {
            heap.iterate(new DefaultHeapVisitor(){

                @Override
                public void prologue(long usedSize) {
                    try {
                        AbstractHeapGraphWriter.this.writeHeapHeader();
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public boolean doObj(Oop oop) {
                    try {
                        if (oop instanceof TypeArray) {
                            AbstractHeapGraphWriter.this.writePrimitiveArray((TypeArray)oop);
                        } else if (oop instanceof ObjArray) {
                            Klass klass = oop.getKlass();
                            ObjArrayKlass oak = (ObjArrayKlass)klass;
                            Klass bottomType = oak.getBottomKlass();
                            if (bottomType instanceof InstanceKlass || bottomType instanceof TypeArrayKlass) {
                                AbstractHeapGraphWriter.this.writeObjectArray((ObjArray)oop);
                            } else {
                                AbstractHeapGraphWriter.this.writeInternalObject(oop);
                            }
                        } else if (oop instanceof Instance) {
                            Instance instance = (Instance)oop;
                            Klass klass = instance.getKlass();
                            Symbol name = klass.getName();
                            if (name.equals(AbstractHeapGraphWriter.this.javaLangString)) {
                                AbstractHeapGraphWriter.this.writeString(instance);
                            } else if (name.equals(AbstractHeapGraphWriter.this.javaLangClass)) {
                                AbstractHeapGraphWriter.this.writeClass(instance);
                            } else if (name.equals(AbstractHeapGraphWriter.this.javaLangThread)) {
                                AbstractHeapGraphWriter.this.writeThread(instance);
                            } else {
                                for (klass = klass.getSuper(); klass != null; klass = klass.getSuper()) {
                                    name = klass.getName();
                                    if (!name.equals(AbstractHeapGraphWriter.this.javaLangThread)) continue;
                                    AbstractHeapGraphWriter.this.writeThread(instance);
                                    return false;
                                }
                                AbstractHeapGraphWriter.this.writeInstance(instance);
                            }
                        } else {
                            AbstractHeapGraphWriter.this.writeInternalObject(oop);
                        }
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                    return false;
                }

                @Override
                public void epilogue() {
                    try {
                        AbstractHeapGraphWriter.this.writeHeapFooter();
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            });
            this.writeJavaThreads();
            this.writeGlobalJNIHandles();
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
    }

    protected void writeJavaThreads() throws IOException {
        Threads threads = VM.getVM().getThreads();
        int index = 1;
        for (JavaThread jt = threads.first(); jt != null; jt = jt.next()) {
            if (jt.getThreadObj() == null) continue;
            this.writeJavaThread(jt, index);
            ++index;
        }
    }

    protected void writeJavaThread(JavaThread jt, int index) throws IOException {
    }

    protected void writeGlobalJNIHandles() throws IOException {
        JNIHandles handles = VM.getVM().getJNIHandles();
        JNIHandleBlock blk = handles.globalHandles();
        if (blk != null) {
            try {
                blk.oopsDo(new AddressVisitor(){

                    @Override
                    public void visitAddress(Address handleAddr) {
                        try {
                            if (handleAddr != null) {
                                AbstractHeapGraphWriter.this.writeGlobalJNIHandle(handleAddr);
                            }
                        }
                        catch (IOException exp) {
                            throw new RuntimeException(exp);
                        }
                    }

                    @Override
                    public void visitCompOopAddress(Address handleAddr) {
                        throw new RuntimeException("Should not reach here. JNIHandles are not compressed");
                    }
                });
            }
            catch (RuntimeException re) {
                this.handleRuntimeException(re);
            }
        }
    }

    protected void writeGlobalJNIHandle(Address handleAddr) throws IOException {
    }

    protected void writeHeapHeader() throws IOException {
    }

    protected void writeInternalObject(Oop oop) throws IOException {
    }

    protected void writePrimitiveArray(TypeArray array) throws IOException {
        this.writeObject(array);
    }

    protected void writeObjectArray(ObjArray array) throws IOException {
        this.writeObject(array);
    }

    protected void writeInstance(Instance instance) throws IOException {
        this.writeObject(instance);
    }

    protected void writeString(Instance instance) throws IOException {
        this.writeInstance(instance);
    }

    protected void writeClass(Instance instance) throws IOException {
        this.writeInstance(instance);
    }

    protected void writeThread(Instance instance) throws IOException {
        this.writeInstance(instance);
    }

    protected void writeObject(Oop oop) throws IOException {
        this.writeObjectHeader(oop);
        this.writeObjectFields(oop);
        this.writeObjectFooter(oop);
    }

    protected void writeObjectHeader(Oop oop) throws IOException {
    }

    protected void writeObjectFields(final Oop oop) throws IOException {
        try {
            oop.iterate(new DefaultOopVisitor(){

                @Override
                public void doOop(OopField field, boolean isVMField) {
                    try {
                        Oop ref = field.getValue(oop);
                        if (ref instanceof TypeArray || ref instanceof ObjArray || ref instanceof Instance) {
                            AbstractHeapGraphWriter.this.writeReferenceField(oop, field);
                        } else {
                            AbstractHeapGraphWriter.this.writeInternalReferenceField(oop, field);
                        }
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doByte(ByteField field, boolean isVMField) {
                    try {
                        AbstractHeapGraphWriter.this.writeByteField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doChar(CharField field, boolean isVMField) {
                    try {
                        AbstractHeapGraphWriter.this.writeCharField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doBoolean(BooleanField field, boolean vField) {
                    try {
                        AbstractHeapGraphWriter.this.writeBooleanField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doShort(ShortField field, boolean isVMField) {
                    try {
                        AbstractHeapGraphWriter.this.writeShortField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doInt(IntField field, boolean isVMField) {
                    try {
                        AbstractHeapGraphWriter.this.writeIntField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doLong(LongField field, boolean isVMField) {
                    try {
                        AbstractHeapGraphWriter.this.writeLongField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doFloat(FloatField field, boolean isVMField) {
                    try {
                        AbstractHeapGraphWriter.this.writeFloatField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }

                @Override
                public void doDouble(DoubleField field, boolean vField) {
                    try {
                        AbstractHeapGraphWriter.this.writeDoubleField(oop, field);
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            }, false);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
    }

    protected void writeInternalReferenceField(Oop oop, OopField field) throws IOException {
    }

    protected void writeReferenceField(Oop oop, OopField field) throws IOException {
    }

    protected void writeByteField(Oop oop, ByteField field) throws IOException {
    }

    protected void writeCharField(Oop oop, CharField field) throws IOException {
    }

    protected void writeBooleanField(Oop oop, BooleanField field) throws IOException {
    }

    protected void writeShortField(Oop oop, ShortField field) throws IOException {
    }

    protected void writeIntField(Oop oop, IntField field) throws IOException {
    }

    protected void writeLongField(Oop oop, LongField field) throws IOException {
    }

    protected void writeFloatField(Oop oop, FloatField field) throws IOException {
    }

    protected void writeDoubleField(Oop oop, DoubleField field) throws IOException {
    }

    protected void writeObjectFooter(Oop oop) throws IOException {
    }

    protected void writeHeapFooter() throws IOException {
    }

    protected void handleRuntimeException(RuntimeException re) throws IOException {
        Throwable cause = re.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw re;
    }

    protected boolean isJavaVisible(Oop oop) {
        if (oop instanceof Instance || oop instanceof TypeArray) {
            return true;
        }
        if (oop instanceof ObjArray) {
            ObjArrayKlass oak = (ObjArrayKlass)oop.getKlass();
            Klass bottomKlass = oak.getBottomKlass();
            return bottomKlass instanceof InstanceKlass || bottomKlass instanceof TypeArrayKlass;
        }
        return false;
    }
}

