/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.GenerationFactory;
import sun.jvm.hotspot.memory.GenerationSpec;
import sun.jvm.hotspot.memory.SharedHeap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class GenCollectedHeap
extends SharedHeap {
    private static CIntegerField nGensField;
    private static long gensOffset;
    private static AddressField genSpecsField;
    private static GenerationFactory genFactory;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("GenCollectedHeap");
        nGensField = type.getCIntegerField("_n_gens");
        gensOffset = type.getField("_gens").getOffset();
        genSpecsField = type.getAddressField("_gen_specs");
        genFactory = new GenerationFactory();
    }

    public GenCollectedHeap(Address addr) {
        super(addr);
    }

    public int nGens() {
        return (int)nGensField.getValue(this.addr);
    }

    public Generation getGen(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(i >= 0 && i < this.nGens(), "Index " + i + " out of range (should be between 0 and " + this.nGens() + ")");
        }
        if (i < 0 || i >= this.nGens()) {
            return null;
        }
        Address genAddr = this.addr.getAddressAt(gensOffset + (long)i * VM.getVM().getAddressSize());
        return GenerationFactory.newObject(this.addr.getAddressAt(gensOffset + (long)i * VM.getVM().getAddressSize()));
    }

    @Override
    public boolean isIn(Address a) {
        for (int i = 0; i < this.nGens(); ++i) {
            Generation gen = this.getGen(i);
            if (!gen.isIn(a)) continue;
            return true;
        }
        return this.permGen().isIn(a);
    }

    @Override
    public long capacity() {
        long capacity = 0L;
        for (int i = 0; i < this.nGens(); ++i) {
            capacity += this.getGen(i).capacity();
        }
        return capacity;
    }

    @Override
    public long used() {
        long used = 0L;
        for (int i = 0; i < this.nGens(); ++i) {
            used += this.getGen(i).used();
        }
        return used;
    }

    GenerationSpec spec(int level) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(level >= 0 && level < this.nGens(), "Index " + level + " out of range (should be between 0 and " + this.nGens() + ")");
        }
        if (level < 0 || level >= this.nGens()) {
            return null;
        }
        Address ptrList = genSpecsField.getValue(this.addr);
        if (ptrList == null) {
            return null;
        }
        return (GenerationSpec)VMObjectFactory.newObject(GenerationSpec.class, ptrList.getAddressAt((long)level * VM.getVM().getAddressSize()));
    }

    @Override
    public CollectedHeapName kind() {
        return CollectedHeapName.GEN_COLLECTED_HEAP;
    }

    @Override
    public void printOn(PrintStream tty) {
        for (int i = 0; i < this.nGens(); ++i) {
            tty.print("Gen " + i + ": ");
            this.getGen(i).printOn(tty);
            tty.println("Invocations: " + this.getGen(i).invocations());
            tty.println();
        }
        this.permGen().printOn(tty);
        tty.println("Invocations: " + this.permGen().invocations());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                GenCollectedHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

