/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DetectorTest {
    private static final String TRAINING_EN = "a a a b b c c d e";
    private static final String TRAINING_FR = "a b b c c c d d d";
    private static final String TRAINING_JA = "\u3042 \u3042 \u3042 \u3044 \u3046 \u3048 \u3048";
    private static final String JSON_LANG1 = "{\"freq\":{\"A\":3,\"B\":6,\"C\":3,\"AB\":2,\"BC\":1,\"ABC\":2,\"BBC\":1,\"CBA\":1},\"n_words\":[12,3,4],\"name\":\"lang1\"}";
    private static final String JSON_LANG2 = "{\"freq\":{\"A\":6,\"B\":3,\"C\":3,\"AA\":3,\"AB\":2,\"ABC\":1,\"ABA\":1,\"CAA\":1},\"n_words\":[12,5,3],\"name\":\"lang2\"}";

    @Before
    public void setUp() throws Exception {
        DetectorFactory.clear();
        LangProfile profile_en = new LangProfile("en");
        String[] stringArray = TRAINING_EN.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            profile_en.add(w);
            ++n2;
        }
        DetectorFactory.addProfile(profile_en, 0, 3);
        LangProfile profile_fr = new LangProfile("fr");
        String[] stringArray2 = TRAINING_FR.split(" ");
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String w = stringArray2[n];
            profile_fr.add(w);
            ++n;
        }
        DetectorFactory.addProfile(profile_fr, 1, 3);
        LangProfile profile_ja = new LangProfile("ja");
        String[] stringArray3 = TRAINING_JA.split(" ");
        int n4 = stringArray3.length;
        n3 = 0;
        while (n3 < n4) {
            String w = stringArray3[n3];
            profile_ja.add(w);
            ++n3;
        }
        DetectorFactory.addProfile(profile_ja, 2, 3);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testDetector1() throws LangDetectException {
        Detector detect = DetectorFactory.create();
        detect.append("a");
        Assert.assertEquals((Object)detect.detect(), (Object)"en");
    }

    @Test
    public final void testDetector2() throws LangDetectException {
        Detector detect = DetectorFactory.create();
        detect.append("b d");
        Assert.assertEquals((Object)detect.detect(), (Object)"fr");
    }

    @Test
    public final void testDetector3() throws LangDetectException {
        Detector detect = DetectorFactory.create();
        detect.append("d e");
        Assert.assertEquals((Object)detect.detect(), (Object)"en");
    }

    @Test
    public final void testDetector4() throws LangDetectException {
        Detector detect = DetectorFactory.create();
        detect.append("\u3042\u3042\u3042\u3042a");
        Assert.assertEquals((Object)detect.detect(), (Object)"ja");
    }

    @Test
    public final void testLangList() throws LangDetectException {
        List<String> langList = DetectorFactory.getLangList();
        Assert.assertEquals((long)langList.size(), (long)3L);
        Assert.assertEquals((Object)langList.get(0), (Object)"en");
        Assert.assertEquals((Object)langList.get(1), (Object)"fr");
        Assert.assertEquals((Object)langList.get(2), (Object)"ja");
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void testLangListException() throws LangDetectException {
        List<String> langList = DetectorFactory.getLangList();
        langList.add("hoge");
    }

    @Test
    public final void testFactoryFromJsonString() throws LangDetectException {
        DetectorFactory.clear();
        ArrayList<String> profiles = new ArrayList<String>();
        profiles.add(JSON_LANG1);
        profiles.add(JSON_LANG2);
        DetectorFactory.loadProfile(profiles);
        List<String> langList = DetectorFactory.getLangList();
        Assert.assertEquals((long)langList.size(), (long)2L);
        Assert.assertEquals((Object)langList.get(0), (Object)"lang1");
        Assert.assertEquals((Object)langList.get(1), (Object)"lang2");
    }
}

