/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.BoolVector;
import SevenZip.Archive.Common.OutStreamWithCRC;
import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.SevenZip.ArchiveDB;
import SevenZip.Archive.SevenZip.FileItem;
import java.io.IOException;
import java.io.OutputStream;

public class FolderOutStream
extends OutputStream {
    private OutStreamWithCRC outStreamWithHashSpec;
    private ArchiveDB archiveDatabase;
    private BoolVector extractStatuses;
    private int startIndex;
    private int ref2Offset;
    private IArchiveExtractCallback extractCallback;
    private boolean testMode;
    private int currentIndex;
    private boolean fileIsOpen;
    private long filePos;

    public FolderOutStream(ArchiveDB archiveDatabase, int ref2Offset, int startIndex, BoolVector extractStatuses, IArchiveExtractCallback extractCallback, boolean testMode) throws IOException {
        this(new OutStreamWithCRC(), archiveDatabase, ref2Offset, startIndex, extractStatuses, extractCallback, testMode);
    }

    public FolderOutStream(OutStreamWithCRC os, ArchiveDB archiveDatabase, int ref2Offset, int startIndex, BoolVector extractStatuses, IArchiveExtractCallback extractCallback, boolean testMode) throws IOException {
        if (os == null) {
            throw new NullPointerException();
        }
        this.outStreamWithHashSpec = os;
        this.archiveDatabase = archiveDatabase;
        this.ref2Offset = ref2Offset;
        this.startIndex = startIndex;
        this.extractStatuses = extractStatuses;
        this.extractCallback = extractCallback;
        this.testMode = testMode;
        this.currentIndex = 0;
        this.fileIsOpen = false;
        this.WriteEmptyFiles();
    }

    private void OpenFile() throws IOException {
        int askMode = this.extractStatuses.get(this.currentIndex) ? (this.testMode ? 1 : 0) : 2;
        int index = this.startIndex + this.currentIndex;
        OutputStream realOutStream = this.extractCallback.GetStream(this.ref2Offset + index, askMode);
        this.outStreamWithHashSpec.setStream(realOutStream);
        this.outStreamWithHashSpec.reset();
        if (realOutStream == null && askMode == 0) {
            FileItem fileInfo = this.archiveDatabase.Files.get(index);
            if (!fileInfo.IsAnti && !fileInfo.IsDirectory) {
                askMode = 2;
            }
        }
        this.extractCallback.PrepareOperation(askMode);
    }

    private int WriteEmptyFiles() throws IOException {
        int begin = this.currentIndex;
        while (this.currentIndex < this.extractStatuses.size()) {
            int index = this.startIndex + this.currentIndex;
            FileItem fileInfo = this.archiveDatabase.Files.get(index);
            if (!fileInfo.IsAnti && !fileInfo.IsDirectory && fileInfo.UnPackSize != 0L) {
                return -1;
            }
            this.OpenFile();
            this.extractCallback.SetOperationResult(0);
            this.outStreamWithHashSpec.releaseStream();
            ++this.currentIndex;
        }
        return this.extractStatuses.size() - begin;
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("FolderOutStream - write() not implemented");
    }

    @Override
    public void write(byte[] data, int off, int size) throws IOException {
        int realProcessedSize = 0;
        while (this.currentIndex < this.extractStatuses.size()) {
            if (this.fileIsOpen) {
                int index = this.startIndex + this.currentIndex;
                FileItem fileInfo = this.archiveDatabase.Files.get(index);
                int tmp = size - realProcessedSize;
                long fileSize = fileInfo.UnPackSize;
                long numBytesToWrite2 = fileSize - this.filePos;
                if ((long)tmp < numBytesToWrite2) {
                    numBytesToWrite2 = tmp;
                }
                int processedSizeLocal = (int)numBytesToWrite2;
                this.outStreamWithHashSpec.write(data, realProcessedSize + off, (int)numBytesToWrite2);
                this.filePos += (long)processedSizeLocal;
                realProcessedSize += processedSizeLocal;
                if (this.filePos == fileSize) {
                    boolean digestsAreEqual = !fileInfo.IsFileCRCDefined || fileInfo.FileCRC == this.outStreamWithHashSpec.getCRC();
                    this.extractCallback.SetOperationResult(digestsAreEqual ? 0 : 3);
                    this.outStreamWithHashSpec.releaseStream();
                    this.fileIsOpen = false;
                    ++this.currentIndex;
                }
                if (realProcessedSize != size) continue;
                this.WriteEmptyFiles();
                return;
            }
            this.OpenFile();
            this.fileIsOpen = true;
            this.filePos = 0L;
        }
    }

    public void FlushCorrupted(int resultEOperationResult) throws IOException {
        while (this.currentIndex < this.extractStatuses.size()) {
            if (this.fileIsOpen) {
                this.extractCallback.SetOperationResult(resultEOperationResult);
                this.outStreamWithHashSpec.releaseStream();
                this.fileIsOpen = false;
                ++this.currentIndex;
                continue;
            }
            this.OpenFile();
            this.fileIsOpen = true;
        }
    }

    public boolean IsWritingFinished() {
        return this.currentIndex == this.extractStatuses.size();
    }
}

