/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.Common;

import Common.CRC;
import java.io.IOException;
import java.io.OutputStream;

public class OutStreamWithCRC
extends OutputStream {
    private OutputStream _stream;
    private long _size;
    private CRC _crc = new CRC();
    private boolean _calculateCrc;

    @Override
    public void write(int b) throws IOException {
        throw new IOException("OutStreamWithCRC - write() not implemented");
    }

    @Override
    public void write(byte[] data, int off, int size) throws IOException {
        if (this._stream != null) {
            this._stream.write(data, off, size);
        }
        if (this._calculateCrc) {
            this._crc.Update(data, off, size);
        }
        this._size += (long)size;
    }

    public void setStream(OutputStream stream) {
        this._stream = stream;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean calculateCrc) {
        this._size = 0L;
        this._calculateCrc = calculateCrc;
        this._crc.Init();
    }

    public void releaseStream() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
        this._stream = null;
    }

    public long getSize() {
        return this._size;
    }

    public int getCRC() {
        return this._crc.GetDigest();
    }

    public void resetCRC() {
        this._crc.Init();
    }
}

