/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;

public class TempoCode
extends AbstractDataType {
    private static final int MINIMUM_NO_OF_DIGITS = 1;
    private static final int MAXIMUM_NO_OF_DIGITS = 2;

    public TempoCode(TempoCode copy) {
        super(copy);
    }

    public TempoCode(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody, 0);
    }

    public TempoCode(String identifier, AbstractTagFrameBody frameBody, Object value) {
        super(identifier, frameBody, value);
    }

    @Override
    public int getSize() {
        if (this.value == null) {
            return 0;
        }
        return ID3Tags.getWholeNumber(this.value) < 255L ? 1 : 2;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof TempoCode && super.equals(that);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("negative offset into an array offset:" + offset);
        }
        if (offset >= arr.length) {
            throw new InvalidDataTypeException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        long lvalue = 0L;
        if ((lvalue += (long)(arr[offset] & 0xFF)) == 255L) {
            lvalue += (long)(arr[offset + 1] & 0xFF);
        }
        this.value = lvalue;
    }

    @Override
    public byte[] writeByteArray() {
        int size = this.getSize();
        byte[] arr = new byte[size];
        long temp = ID3Tags.getWholeNumber(this.value);
        int offset = 0;
        if (temp >= 255L) {
            arr[offset] = -1;
            ++offset;
            temp -= 255L;
        }
        arr[offset] = (byte)(temp & 0xFFL);
        return arr;
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }
}

