/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.chunk.WavInfoChunk;
import org.jaudiotagger.tag.wav.WavTag;

public class WavListChunk
extends Chunk {
    private boolean isValid = false;
    private WavTag tag;

    public WavListChunk(ByteBuffer chunkData, ChunkHeader chunkHeader, WavTag tag) throws IOException {
        super(chunkData, chunkHeader);
        this.tag = tag;
    }

    @Override
    public boolean readChunk() throws IOException {
        String subIdentifier = Utils.readFourBytesAsChars(this.chunkData);
        if (subIdentifier.equals(WavChunkType.INFO.getCode())) {
            WavInfoChunk chunk = new WavInfoChunk(this.tag);
            chunk.readChunks(this.chunkData);
            this.tag.getInfoTag().setStartLocationInFile(this.chunkHeader.getStartLocationInFile());
            this.tag.getInfoTag().setEndLocationInFile(this.chunkHeader.getStartLocationInFile() + 8L + this.chunkHeader.getSize());
            this.tag.setExistingInfoTag(true);
        }
        return true;
    }

    public String toString() {
        String out = "RIFF-WAVE Header:\n";
        out = out + "Is valid?: " + this.isValid;
        return out;
    }
}

