/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.NumberEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TangentEvaluator
extends NumberEvaluator {
    protected static final long serialVersionUID = 1L;

    public TangentEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one value but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Number evaluate(Tuple tuple) throws IOException {
        List<BigDecimal> results = this.evaluateAll(tuple);
        if (1 != results.size()) {
            throw new IOException(String.format(Locale.ROOT, "%s(...) only works with a 1 value but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), results.size()));
        }
        if (null == results.get(0)) {
            return null;
        }
        return Math.tan(results.get(0).doubleValue());
    }
}

