/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerNodePrioritizer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZkStateReader zkStateReader;
    private final String adminPath;
    private final ShardHandlerFactory shardHandlerFactory;

    public OverseerNodePrioritizer(ZkStateReader zkStateReader, String adminPath, ShardHandlerFactory shardHandlerFactory) {
        this.zkStateReader = zkStateReader;
        this.adminPath = adminPath;
        this.shardHandlerFactory = shardHandlerFactory;
    }

    public synchronized void prioritizeOverseerNodes(String overseerId) throws KeeperException, InterruptedException {
        SolrZkClient zk = this.zkStateReader.getZkClient();
        if (!zk.exists("/roles.json", true).booleanValue()) {
            return;
        }
        Map m = (Map)Utils.fromJSON((byte[])zk.getData("/roles.json", null, new Stat(), true));
        List overseerDesignates = (List)m.get("overseer");
        if (overseerDesignates == null || overseerDesignates.isEmpty()) {
            return;
        }
        String ldr = OverseerTaskProcessor.getLeaderNode(zk);
        if (overseerDesignates.contains(ldr)) {
            return;
        }
        log.info("prioritizing overseer nodes at {} overseer designates are {}", (Object)overseerId, (Object)overseerDesignates);
        List<String> electionNodes = OverseerTaskProcessor.getSortedElectionNodes(zk, "/overseer_elect/election");
        if (electionNodes.size() < 2) {
            return;
        }
        log.info("sorted nodes {}", electionNodes);
        String designateNodeId = null;
        for (String electionNode : electionNodes) {
            if (!overseerDesignates.contains(LeaderElector.getNodeName(electionNode))) continue;
            designateNodeId = electionNode;
            break;
        }
        if (designateNodeId == null) {
            log.warn("No live overseer designate ");
            return;
        }
        if (!designateNodeId.equals(electionNodes.get(1))) {
            log.info("asking node {} to come join election at head", (Object)designateNodeId);
            this.invokeOverseerOp(designateNodeId, "rejoinAtHead");
            log.info("asking the old first in line {} to rejoin election  ", (Object)electionNodes.get(1));
            this.invokeOverseerOp(electionNodes.get(1), "rejoin");
        }
        Overseer.getStateUpdateQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON((Object)new ZkNodeProps(new String[]{"operation", OverseerAction.QUIT.toLower(), "id", OverseerTaskProcessor.getLeaderId(this.zkStateReader.getZkClient())})));
    }

    private void invokeOverseerOp(String electionNode, String op) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.OVERSEEROP.toString()});
        params.set("op", new String[]{op});
        params.set("qt", new String[]{this.adminPath});
        params.set("electionNode", new String[]{electionNode});
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        String replica = this.zkStateReader.getBaseUrlForNodeName(LeaderElector.getNodeName(electionNode));
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        shardHandler.submit(sreq, replica, sreq.params);
        shardHandler.takeCompletedOrError();
    }
}

