/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;
    private SolrZkClient zkClient;

    public CreateCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
        this.zkClient = ocmh.zkStateReader.getZkClient();
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("name");
        log.info("Create collection {}", (Object)collectionName);
        if (clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        String configName = this.getConfigName(collectionName, message);
        if (configName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No config set found to associate with the collection.");
        }
        this.ocmh.validateConfigOrThrowSolrException(configName);
        try {
            Map<Object, Object> positionVsNodes;
            int repFactor = message.getInt("replicationFactor", Integer.valueOf(1));
            ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
            String async = message.getStr("async");
            Integer numSlices = message.getInt("numShards", null);
            String router = message.getStr("router.name", "compositeId");
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(router)) {
                ClusterStateMutator.getShardNames(shardNames, message.getStr("shards", null));
                numSlices = shardNames.size();
            } else {
                if (numSlices == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param (when using CompositeId router).");
                }
                ClusterStateMutator.getShardNames(numSlices, shardNames);
            }
            int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(1));
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "replicationFactor must be greater than 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            List<String> nodeList = OverseerCollectionMessageHandler.getLiveOrLiveAndCreateNodeSetList(clusterState.getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM);
            if (nodeList.isEmpty()) {
                log.warn("It is unusual to create a collection (" + collectionName + ") without cores.");
                positionVsNodes = new HashMap();
            } else {
                int requestedShardsToCreate;
                int maxShardsAllowedToCreate;
                if (repFactor > nodeList.size()) {
                    log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or live and part of your " + "createNodeSet" + "(" + nodeList.size() + "). It's unusual to run two replica of the same slice on the same Solr-instance.");
                }
                if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + "maxShardsPerNode" + " is " + maxShardsPerNode + ", and the number of nodes currently live or live and part of your " + "createNodeSet" + " is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + "numShards" + " is " + numSlices + " and value of " + "replicationFactor" + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
                }
                positionVsNodes = this.ocmh.identifyNodes(clusterState, nodeList, message, shardNames, repFactor);
            }
            ZkStateReader zkStateReader = this.ocmh.zkStateReader;
            boolean isLegacyCloud = Overseer.isLegacy(zkStateReader);
            this.ocmh.createConfNode(configName, collectionName, isLegacyCloud);
            HashMap<String, String> collectionParams = new HashMap<String, String>();
            Map collectionProps = message.getProperties();
            for (String propName : collectionProps.keySet()) {
                if (!propName.startsWith("collection.")) continue;
                collectionParams.put(propName.substring("collection.".length()), (String)collectionProps.get(propName));
            }
            CreateCollectionCmd.createCollectionZkNode(this.zkClient, collectionName, collectionParams);
            Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)message));
            TimeOut waitUntil = new TimeOut(30L, TimeUnit.SECONDS);
            boolean created = false;
            while (!waitUntil.hasTimedOut()) {
                Thread.sleep(100L);
                created = zkStateReader.getClusterState().hasCollection(collectionName);
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create collection: " + collectionName);
            }
            if (nodeList.isEmpty()) {
                log.debug("Finished create command for collection: {}", (Object)collectionName);
                return;
            }
            HashMap<String, String> requestMap = new HashMap<String, String>();
            log.debug(StrUtils.formatString((String)"Creating SolrCores for new collection {0}, shardNames {1} , replicationFactor : {2}", (Object[])new Object[]{collectionName, shardNames, repFactor}));
            LinkedHashMap<String, ShardRequest> coresToCreate = new LinkedHashMap<String, ShardRequest>();
            for (Map.Entry<Object, Object> e : positionVsNodes.entrySet()) {
                ReplicaAssigner.Position position = (ReplicaAssigner.Position)e.getKey();
                String nodeName = (String)e.getValue();
                String coreName = collectionName + "_" + position.shard + "_replica" + (position.index + 1);
                log.debug(StrUtils.formatString((String)"Creating core {0} as part of shard {1} of collection {2} on {3}", (Object[])new Object[]{coreName, position.shard, collectionName, nodeName}));
                String baseUrl = zkStateReader.getBaseUrlForNodeName(nodeName);
                if (!isLegacyCloud) {
                    ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collectionName, "shard", position.shard, "core", coreName, "state", Replica.State.DOWN.toString(), "base_url", baseUrl});
                    Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)props));
                }
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                params.set("name", new String[]{coreName});
                params.set("collection.configName", new String[]{configName});
                params.set("collection", new String[]{collectionName});
                params.set("shard", new String[]{position.shard});
                params.set("numShards", numSlices.intValue());
                params.set("newCollection", new String[]{"true"});
                if (async != null) {
                    String coreAdminAsyncId = async + Math.abs(System.nanoTime());
                    params.add("async", new String[]{coreAdminAsyncId});
                    requestMap.put(nodeName, coreAdminAsyncId);
                }
                this.ocmh.addPropertyParams(message, params);
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = nodeName;
                params.set("qt", new String[]{this.ocmh.adminPath});
                sreq.purpose = 1;
                sreq.shards = new String[]{baseUrl};
                sreq.actualShards = sreq.shards;
                sreq.params = params;
                if (isLegacyCloud) {
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                    continue;
                }
                coresToCreate.put(coreName, sreq);
            }
            if (!isLegacyCloud) {
                Map<String, Replica> replicas = this.ocmh.waitToSeeReplicasInState(collectionName, coresToCreate.keySet());
                for (Map.Entry e : coresToCreate.entrySet()) {
                    ShardRequest sreq = (ShardRequest)e.getValue();
                    sreq.params.set("coreNodeName", new String[]{replicas.get(e.getKey()).getName()});
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                }
            }
            this.ocmh.processResponses(results, shardHandler, false, null, async, requestMap, Collections.emptySet());
            if (results.get("failure") != null && ((SimpleOrderedMap)results.get("failure")).size() > 0) {
                this.ocmh.cleanupCollection(collectionName, new NamedList());
                log.info("Cleaned up artifacts for failed create collection for [{}]", (Object)collectionName);
            } else {
                log.debug("Finished create command on all shards for collection: {}", (Object)collectionName);
            }
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    String getConfigName(String coll, ZkNodeProps message) throws KeeperException, InterruptedException {
        String configName = message.getStr("collection.configName");
        if (configName == null) {
            List configNames = null;
            try {
                configNames = this.ocmh.zkStateReader.getZkClient().getChildren("/configs", null, true);
                if (configNames != null && configNames.size() == 1) {
                    configName = (String)configNames.get(0);
                    log.info("Only one config set found in zk - using it:" + configName);
                } else if (configNames.contains(coll)) {
                    configName = coll;
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        return configName;
    }

    public static void createCollectionZkNode(SolrZkClient zkClient, String collection, Map<String, String> params) {
        block17: {
            log.debug("Check for collection zkNode:" + collection);
            String collectionPath = "/collections/" + collection;
            try {
                if (!zkClient.exists(collectionPath, true).booleanValue()) {
                    log.debug("Creating collection in ZooKeeper:" + collection);
                    try {
                        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
                        String defaultConfigName = System.getProperty("collection.configName", collection);
                        if (params.size() > 0) {
                            collectionProps.putAll(params);
                            if (!collectionProps.containsKey("configName")) {
                                CreateCollectionCmd.getConfName(zkClient, collection, collectionPath, collectionProps);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            log.info("Setting config for collection:" + collection + " to " + defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith("collection.")) continue;
                                collectionProps.put(sprop.substring("collection.".length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey("configName")) {
                                collectionProps.put("configName", defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put("configName", collection);
                        } else {
                            CreateCollectionCmd.getConfName(zkClient, collection, collectionPath, collectionProps);
                        }
                        collectionProps.remove("numShards");
                        ZkNodeProps zkProps = new ZkNodeProps(collectionProps);
                        zkClient.makePath(collectionPath, Utils.toJSON((Object)zkProps), CreateMode.PERSISTENT, null, true);
                        break block17;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block17;
                    }
                }
                log.debug("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
        }
    }

    private static void getConfName(SolrZkClient zkClient, String collection, String collectionPath, Map<String, Object> collectionProps) throws KeeperException, InterruptedException {
        ZkNodeProps cProps;
        int retry;
        log.debug("Looking for collection configName");
        if (collectionProps.containsKey("configName")) {
            log.info("configName was passed as a param {}", collectionProps.get("configName"));
            return;
        }
        List configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || zkClient.exists(collectionPath, true).booleanValue() && (cProps = ZkNodeProps.load((byte[])zkClient.getData(collectionPath, null, null, true))).containsKey("configName")); ++retry) {
            try {
                configNames = zkClient.getChildren("/configs", null, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            if (configNames != null && configNames.size() == 1) {
                log.info("Only one config set found in zk - using it:" + (String)configNames.get(0));
                collectionProps.put("configName", configNames.get(0));
                break;
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put("configName", collection);
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: " + retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection " + collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + configNames);
        }
    }
}

