/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureETC.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureETCPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureETCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureETCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureETCPrototype>(vm)) JSWebGLCompressedTextureETCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureETCPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureETCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureETCPrototype, JSWebGLCompressedTextureETCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureETCPrototypeTableValues[] =
{
    { "COMPRESSED_R11_EAC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9270 } },
    { "COMPRESSED_SIGNED_R11_EAC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9271 } },
    { "COMPRESSED_RG11_EAC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9272 } },
    { "COMPRESSED_SIGNED_RG11_EAC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9273 } },
    { "COMPRESSED_RGB8_ETC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9274 } },
    { "COMPRESSED_SRGB8_ETC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9275 } },
    { "COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9276 } },
    { "COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9277 } },
    { "COMPRESSED_RGBA8_ETC2_EAC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9278 } },
    { "COMPRESSED_SRGB8_ALPHA8_ETC2_EAC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9279 } },
};

const ClassInfo JSWebGLCompressedTextureETCPrototype::s_info = { "WebGLCompressedTextureETC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETCPrototype) };

void JSWebGLCompressedTextureETCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureETC::info(), JSWebGLCompressedTextureETCPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLCompressedTextureETC::s_info = { "WebGLCompressedTextureETC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETC) };

JSWebGLCompressedTextureETC::JSWebGLCompressedTextureETC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureETC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureETC>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureETC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLCompressedTextureETC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLCompressedTextureETCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLCompressedTextureETCPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLCompressedTextureETC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureETC>(vm, globalObject);
}

void JSWebGLCompressedTextureETC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureETC* thisObject = static_cast<JSWebGLCompressedTextureETC*>(cell);
    thisObject->JSWebGLCompressedTextureETC::~JSWebGLCompressedTextureETC();
}

JSC::GCClient::IsoSubspace* JSWebGLCompressedTextureETC::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLCompressedTextureETC, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLCompressedTextureETC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLCompressedTextureETC = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLCompressedTextureETC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLCompressedTextureETC = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLCompressedTextureETC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureETC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureETCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLCompressedTextureETC = jsCast<JSWebGLCompressedTextureETC*>(handle.slot()->asCell());
    auto& owner = jsWebGLCompressedTextureETC->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLCompressedTextureETC"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLCompressedTextureETCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureETC = static_cast<JSWebGLCompressedTextureETC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLCompressedTextureETC->protectedWrapped().ptr(), jsWebGLCompressedTextureETC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureETC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebGLCompressedTextureETCE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLCompressedTextureETC>, void>> static inline void verifyVTable(WebGLCompressedTextureETC* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureETC@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25WebGLCompressedTextureETCE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLCompressedTextureETC has subclasses. If WebGLCompressedTextureETC has subclasses that get passed
        // to toJS() we currently require WebGLCompressedTextureETC you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureETC>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLCompressedTextureETC>(impl.ptr());
#endif
    return createWrapper<WebGLCompressedTextureETC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureETC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureETC* JSWebGLCompressedTextureETC::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureETC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
