/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.JaninoRuntimeException;

public final class Descriptor {
    public static final String VOID_ = "V";
    public static final String BYTE_ = "B";
    public static final String CHAR_ = "C";
    public static final String DOUBLE_ = "D";
    public static final String FLOAT_ = "F";
    public static final String INT_ = "I";
    public static final String LONG_ = "J";
    public static final String SHORT_ = "S";
    public static final String BOOLEAN_ = "Z";
    public static final String OBJECT = "Ljava/lang/Object;";
    public static final String STRING = "Ljava/lang/String;";
    public static final String STRING_BUFFER = "Ljava/lang/StringBuffer;";
    public static final String STRING_BUILDER = "Ljava/lang/StringBuilder;";
    public static final String CLASS = "Ljava/lang/Class;";
    public static final String THROWABLE = "Ljava/lang/Throwable;";
    public static final String RUNTIME_EXCEPTION = "Ljava/lang/RuntimeException;";
    public static final String ERROR = "Ljava/lang/Error;";
    public static final String CLONEABLE = "Ljava/lang/Cloneable;";
    public static final String SERIALIZABLE = "Ljava/io/Serializable;";
    public static final String BOOLEAN = "Ljava/lang/Boolean;";
    public static final String BYTE = "Ljava/lang/Byte;";
    public static final String CHARACTER = "Ljava/lang/Character;";
    public static final String SHORT = "Ljava/lang/Short;";
    public static final String INTEGER = "Ljava/lang/Integer;";
    public static final String LONG = "Ljava/lang/Long;";
    public static final String FLOAT = "Ljava/lang/Float;";
    public static final String DOUBLE = "Ljava/lang/Double;";
    private static final Map classNameToDescriptor = new HashMap();
    private static final Map descriptorToClassName = new HashMap();

    private Descriptor() {
    }

    public static boolean isReference(String d) {
        return d.length() > 1;
    }

    public static boolean isClassOrInterfaceReference(String d) {
        return d.charAt(0) == 'L';
    }

    public static boolean isArrayReference(String d) {
        return d.charAt(0) == '[';
    }

    public static String getComponentDescriptor(String d) {
        if (d.charAt(0) != '[') {
            throw new JaninoRuntimeException("Cannot determine component descriptor from non-array descriptor \"" + d + "\"");
        }
        return d.substring(1);
    }

    public static short size(String d) {
        if (d.equals(VOID_)) {
            return 0;
        }
        if (Descriptor.hasSize1(d)) {
            return 1;
        }
        if (Descriptor.hasSize2(d)) {
            return 2;
        }
        throw new JaninoRuntimeException("No size defined for type \"" + Descriptor.toString(d) + "\"");
    }

    public static boolean hasSize1(String d) {
        if (d.length() == 1) {
            return "BCFISZ".indexOf(d) != -1;
        }
        return Descriptor.isReference(d);
    }

    public static boolean hasSize2(String d) {
        return d.equals(LONG_) || d.equals(DOUBLE_);
    }

    public static String toString(String d) {
        int idx = 0;
        StringBuffer sb = new StringBuffer();
        if (d.charAt(0) == '(') {
            ++idx;
            sb.append("(");
            while (idx < d.length() && d.charAt(idx) != ')') {
                if (idx != 1) {
                    sb.append(", ");
                }
                idx = Descriptor.toString(d, idx, sb);
            }
            if (idx >= d.length()) {
                throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
            }
            sb.append(") => ");
            ++idx;
        }
        Descriptor.toString(d, idx, sb);
        return sb.toString();
    }

    private static int toString(String d, int idx, StringBuffer sb) {
        int dimensions = 0;
        while (idx < d.length() && d.charAt(idx) == '[') {
            ++dimensions;
            ++idx;
        }
        if (idx >= d.length()) {
            throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
        }
        switch (d.charAt(idx)) {
            case 'L': {
                int idx2 = d.indexOf(59, idx);
                if (idx2 == -1) {
                    throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
                }
                sb.append(d.substring(idx + 1, idx2).replace('/', '.'));
                idx = idx2;
                break;
            }
            case 'V': {
                sb.append("void");
                break;
            }
            case 'B': {
                sb.append("byte");
                break;
            }
            case 'C': {
                sb.append("char");
                break;
            }
            case 'D': {
                sb.append("double");
                break;
            }
            case 'F': {
                sb.append("float");
                break;
            }
            case 'I': {
                sb.append("int");
                break;
            }
            case 'J': {
                sb.append("long");
                break;
            }
            case 'S': {
                sb.append("short");
                break;
            }
            case 'Z': {
                sb.append("boolean");
                break;
            }
            default: {
                throw new JaninoRuntimeException("Invalid descriptor \"" + d + "\"");
            }
        }
        while (dimensions > 0) {
            sb.append("[]");
            --dimensions;
        }
        return idx + 1;
    }

    public static String fromClassName(String className) {
        String res = (String)classNameToDescriptor.get(className);
        if (res != null) {
            return res;
        }
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        return 'L' + className.replace('.', '/') + ';';
    }

    public static String fromInternalForm(String internalForm) {
        if (internalForm.charAt(0) == '[') {
            return internalForm;
        }
        return 'L' + internalForm + ';';
    }

    public static String toClassName(String d) {
        String res = (String)descriptorToClassName.get(d);
        if (res != null) {
            return res;
        }
        char firstChar = d.charAt(0);
        if (firstChar == 'L' && d.endsWith(";")) {
            return d.substring(1, d.length() - 1).replace('/', '.');
        }
        if (firstChar == '[') {
            return d.replace('/', '.');
        }
        throw new JaninoRuntimeException("(Invalid field descriptor \"" + d + "\")");
    }

    public static String toInternalForm(String d) {
        if (d.charAt(0) != 'L') {
            throw new JaninoRuntimeException("Attempt to convert non-class descriptor \"" + d + "\" into internal form");
        }
        return d.substring(1, d.length() - 1);
    }

    public static boolean isPrimitive(String d) {
        return d.length() == 1 && "VBCDFIJSZ".indexOf(d.charAt(0)) != -1;
    }

    public static boolean isPrimitiveNumeric(String d) {
        return d.length() == 1 && "BDFIJSC".indexOf(d.charAt(0)) != -1;
    }

    public static String getPackageName(String d) {
        if (d.charAt(0) != 'L') {
            throw new JaninoRuntimeException("Attempt to get package name of non-class descriptor \"" + d + "\"");
        }
        int idx = d.lastIndexOf(47);
        return idx == -1 ? null : d.substring(1, idx).replace('/', '.');
    }

    public static boolean areInSamePackage(String d1, String d2) {
        String packageName1 = Descriptor.getPackageName(d1);
        String packageName2 = Descriptor.getPackageName(d2);
        return packageName1 == null ? packageName2 == null : packageName1.equals(packageName2);
    }

    static {
        descriptorToClassName.put(VOID_, "void");
        descriptorToClassName.put(BYTE_, "byte");
        descriptorToClassName.put(CHAR_, "char");
        descriptorToClassName.put(DOUBLE_, "double");
        descriptorToClassName.put(FLOAT_, "float");
        descriptorToClassName.put(INT_, "int");
        descriptorToClassName.put(LONG_, "long");
        descriptorToClassName.put(SHORT_, "short");
        descriptorToClassName.put(BOOLEAN_, "boolean");
        descriptorToClassName.put(OBJECT, "java.lang.Object");
        descriptorToClassName.put(STRING, "java.lang.String");
        descriptorToClassName.put(STRING_BUFFER, "java.lang.StringBuffer");
        descriptorToClassName.put(STRING_BUILDER, "java.lang.StringBuilder");
        descriptorToClassName.put(CLASS, "java.lang.Class");
        descriptorToClassName.put(THROWABLE, "java.lang.Throwable");
        descriptorToClassName.put(RUNTIME_EXCEPTION, "java.lang.RuntimeException");
        descriptorToClassName.put(ERROR, "java.lang.Error");
        descriptorToClassName.put(CLONEABLE, "java.lang.Cloneable");
        descriptorToClassName.put(SERIALIZABLE, "java.io.Serializable");
        descriptorToClassName.put(BOOLEAN, "java.lang.Boolean");
        descriptorToClassName.put(BYTE, "java.lang.Byte");
        descriptorToClassName.put(CHARACTER, "java.lang.Character");
        descriptorToClassName.put(SHORT, "java.lang.Short");
        descriptorToClassName.put(INTEGER, "java.lang.Integer");
        descriptorToClassName.put(LONG, "java.lang.Long");
        descriptorToClassName.put(FLOAT, "java.lang.Float");
        descriptorToClassName.put(DOUBLE, "java.lang.Double");
        Iterator it = descriptorToClassName.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            classNameToDescriptor.put(e.getValue(), e.getKey());
        }
    }
}

