/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void handleImportClassFailure(Throwable throwable, String string) {
        ReflectionUtils.handle(throwable, string, ClassNotFoundException.class, ExceptionInInitializerError.class, LinkageError.class, NoSuchMethodException.class, SecurityException.class, IllegalAccessException.class, IllegalArgumentException.class, InstantiationException.class, InvocationTargetException.class);
    }

    public static void handleNewInstanceFailure(Throwable throwable, Class<?> clazz) {
        ReflectionUtils.handle(throwable, clazz.getName(), IllegalAccessException.class, IllegalArgumentException.class, InstantiationException.class, InvocationTargetException.class, NoSuchMethodException.class, SecurityException.class, ExceptionInInitializerError.class);
    }

    private static void handle(Throwable throwable, String string, Class<?> ... classArray) {
        ThrowableUtils.throwRecent(OutOfMemoryError.class, throwable);
        if (string.startsWith("VASSAL.")) {
            ErrorDialog.bug(throwable);
            return;
        }
        for (Class<?> clazz : classArray) {
            if (!clazz.isInstance(throwable)) continue;
            ErrorDialog.showDetailsDisableable(throwable, ThrowableUtils.getStackTrace(throwable), (Object)string, "Error.custom_class_error", string);
            return;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new IllegalStateException(throwable);
    }
}

