/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.Info;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.LocaleConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.TranslateWindow;
import VASSAL.i18n.Translation;
import VASSAL.i18n.VassalTranslation;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.io.IOUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class TranslateVassalWindow
extends TranslateWindow {
    private static final long serialVersionUID = 1L;
    protected LocaleConfigurer localeConfig;
    protected FileChooser fileChooser;

    public TranslateVassalWindow(Frame frame, boolean bl, Translatable translatable, HelpWindow helpWindow, ConfigureTree configureTree) {
        super(frame, bl, translatable, helpWindow, configureTree);
    }

    public TranslateVassalWindow(Frame frame) {
        super(frame, false, new VassalTranslation(), null, null);
        this.currentTranslation = (Translation)this.target;
        this.keyTable.setEnabled(true);
        this.newTranslation();
    }

    protected FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = FileChooser.createFileChooser(this, null);
        } else {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    protected Component buildMainPanel() {
        JSplitPane jSplitPane = (JSplitPane)super.buildMainPanel();
        return jSplitPane.getBottomComponent();
    }

    protected Component getHeaderPanel() {
        JPanel jPanel = new JPanel();
        this.localeConfig = new LocaleConfigurer(null, "", new Locale(Locale.getDefault().getLanguage()));
        this.localeConfig.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block5: {
                    block6: {
                        Locale locale = TranslateVassalWindow.this.localeConfig.getValueLocale();
                        if (!Resources.getSupportedLocales().contains(locale)) {
                            locale = new Locale(locale.getLanguage());
                        }
                        if (!Resources.getSupportedLocales().contains(locale)) break block6;
                        String string = "VASSAL_" + locale + ".properties";
                        InputStream inputStream = this.getClass().getResourceAsStream(string);
                        if (inputStream == null) break block5;
                        BufferedInputStream bufferedInputStream = null;
                        try {
                            bufferedInputStream = new BufferedInputStream(inputStream);
                            ((VassalTranslation)TranslateVassalWindow.this.target).loadProperties(bufferedInputStream);
                            ((TranslateWindow.MyTableModel)TranslateVassalWindow.this.keyTable.getModel()).fireTableDataChanged();
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {
                            try {
                                ReadErrorDialog.error(iOException, string);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(bufferedInputStream);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)bufferedInputStream);
                            break block5;
                        }
                        IOUtils.closeQuietly((InputStream)bufferedInputStream);
                        break block5;
                    }
                    ((VassalTranslation)TranslateVassalWindow.this.target).clearProperties();
                    ((TranslateWindow.MyTableModel)TranslateVassalWindow.this.keyTable.getModel()).fireTableDataChanged();
                }
            }
        });
        jPanel.add(this.localeConfig.getControls());
        return jPanel;
    }

    protected Component getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Resources.getString("General.help"));
        jButton.addActionListener(new ShowHelpAction(HelpFile.getReferenceManualPage("Translations.htm", "application").getContents(), null));
        JButton jButton2 = new JButton(Resources.getString("General.load"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslateVassalWindow.this.loadTranslation();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(Resources.getString("General.save"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TranslateVassalWindow.this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton(Resources.getString("General.cancel"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslateVassalWindow.this.cancel();
            }
        });
        jPanel.add(jButton4);
        return jPanel;
    }

    protected void newTranslation() {
        ((VassalTranslation)this.target).clearProperties();
        ArrayList<String> arrayList = new ArrayList<String>(Resources.getVassalKeys());
        Collections.sort(arrayList);
        this.keys = arrayList.toArray(new String[arrayList.size()]);
        this.copyButtons = new TranslateWindow.CopyButton[this.keys.length];
        ((TranslateWindow.MyTableModel)this.keyTable.getModel()).update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTranslation() {
        if (this.currentTranslation.isDirty()) {
            try {
                if (!this.querySave()) {
                    return;
                }
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, this.currentTranslation.getBundleFileName());
                return;
            }
        }
        FileChooser fileChooser = this.getFileChooser();
        fileChooser.setFileFilter(new ExtensionFileFilter("Property Files", new String[]{".properties"}));
        fileChooser.setCurrentDirectory(Info.getHomeDir());
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (!file.getName().endsWith(".properties")) {
            this.loadError("Module Properties files must end in '.properties'.");
            return;
        }
        Object object = file.getName().substring(7, 9);
        String string = "";
        if (file.getName().charAt(9) == '_') {
            string = file.getName().substring(10, 12);
        }
        Locale locale = new Locale((String)object, string);
        this.localeConfig.setValue(locale);
        object = null;
        try {
            object = new BufferedInputStream(new FileInputStream(file));
            ((VassalTranslation)this.target).loadProperties((InputStream)object);
            ((BufferedInputStream)object).close();
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file);
        }
        finally {
            IOUtils.closeQuietly((InputStream)object);
        }
        ((TranslateWindow.MyTableModel)this.keyTable.getModel()).fireTableDataChanged();
    }

    protected void loadError(String string) {
        JOptionPane.showMessageDialog(this, string, "Invalid Properties file name", 0);
    }

    protected boolean saveTranslation() {
        FileChooser fileChooser = this.getFileChooser();
        Locale locale = this.localeConfig.getValueLocale();
        String string = "VASSAL_" + locale.getLanguage();
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            string = string + "_" + locale.getCountry();
        }
        string = string + ".properties";
        fileChooser.setSelectedFile(new File(Info.getHomeDir(), string));
        if (fileChooser.showSaveDialog(this) != 0) {
            return false;
        }
        File file = fileChooser.getSelectedFile();
        try {
            ((VassalTranslation)this.target).saveProperties(file, this.localeConfig.getValueLocale());
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, file);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TranslateVassalWindow translateVassalWindow = new TranslateVassalWindow(null);
                translateVassalWindow.setVisible(true);
            }
        });
    }
}

