/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class SimpleStatusControlsInitializer
implements ChatControlsInitializer {
    private ChatServerConnection client;
    private boolean includeLooking;
    private JButton lookingBox;
    private JButton awayButton;

    public SimpleStatusControlsInitializer(ChatServerConnection chatServerConnection, boolean bl) {
        this.client = chatServerConnection;
        this.includeLooking = bl;
    }

    public SimpleStatusControlsInitializer(ChatServerConnection chatServerConnection) {
        this(chatServerConnection, true);
    }

    public void initializeControls(final ChatServerControls chatServerControls) {
        URL uRL;
        if (this.includeLooking) {
            this.lookingBox = new JButton(Resources.getString("Chat.looking_for_a_game"));
            this.lookingBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SimpleStatusControlsInitializer.this.client != null) {
                        Player player = SimpleStatusControlsInitializer.this.client.getUserInfo();
                        SimpleStatus simpleStatus = (SimpleStatus)player.getStatus();
                        simpleStatus = new SimpleStatus(!simpleStatus.isLooking(), simpleStatus.isAway(), simpleStatus.getProfile(), simpleStatus.getClient(), simpleStatus.getIp(), simpleStatus.getModuleVersion(), simpleStatus.getCrc());
                        SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(player.getId(), player.getName(), simpleStatus));
                    }
                }
            });
            this.lookingBox.setSize(this.lookingBox.getMinimumSize());
            uRL = this.getClass().getResource("/images/playerLooking.gif");
            if (uRL != null) {
                this.lookingBox.setToolTipText(this.lookingBox.getText());
                this.lookingBox.setText("");
                this.lookingBox.setIcon(new ImageIcon(uRL));
            }
        }
        this.awayButton = new JButton(Resources.getString("Chat.away_from_keyboard"));
        this.awayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleStatusControlsInitializer.this.client != null) {
                    Player player = SimpleStatusControlsInitializer.this.client.getUserInfo();
                    SimpleStatus simpleStatus = (SimpleStatus)player.getStatus();
                    simpleStatus = new SimpleStatus(simpleStatus.isLooking(), true, simpleStatus.getProfile(), simpleStatus.getClient(), simpleStatus.getIp(), simpleStatus.getModuleVersion(), simpleStatus.getCrc());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(player.getId(), player.getName(), simpleStatus));
                    JOptionPane.showMessageDialog(chatServerControls.getRoomTree(), Resources.getString("Chat.im_back"), Resources.getString("Chat.away_from_keyboard"), -1);
                    simpleStatus = (SimpleStatus)player.getStatus();
                    simpleStatus = new SimpleStatus(simpleStatus.isLooking(), false, simpleStatus.getProfile(), simpleStatus.getClient(), simpleStatus.getIp(), simpleStatus.getModuleVersion(), simpleStatus.getCrc());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(player.getId(), player.getName(), simpleStatus));
                }
            }
        });
        uRL = this.getClass().getResource("/images/playerAway.gif");
        if (uRL != null) {
            this.awayButton.setToolTipText(this.awayButton.getText());
            this.awayButton.setText("");
            this.awayButton.setIcon(new ImageIcon(uRL));
        }
        if (this.includeLooking) {
            chatServerControls.getToolbar().add(this.lookingBox);
        }
        chatServerControls.getToolbar().add(this.awayButton);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        if (this.includeLooking) {
            chatServerControls.getToolbar().remove(this.lookingBox);
        }
        chatServerControls.getToolbar().remove(this.awayButton);
    }
}

