/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.BufferedSocketHandler;
import VASSAL.chat.node.LockWatcher;
import VASSAL.chat.node.PlayerNode;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.tools.ArgsParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

public class Server
extends Thread {
    private AsynchronousServerNode rootNode;
    private ServerSocket socket;

    public Server(AsynchronousServerNode asynchronousServerNode, int n) throws IOException {
        this.rootNode = asynchronousServerNode;
        this.socket = new ServerSocket(n);
        System.err.println("Started server on port " + n);
        this.start();
    }

    public void run() {
        int n = 0;
        while (n < 10) {
            try {
                Socket socket = this.socket.accept();
                new PlayerNode(socket, this.rootNode);
                n = 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ++n;
            }
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new ArgsParser(stringArray).getProperties();
        int n = Integer.parseInt(properties.getProperty("port", "5050"));
        String string = properties.getProperty("URL", "http://www.vassalengine.org/util/");
        if ("null".equals(string)) {
            string = null;
        }
        if (!"true".equals(properties.getProperty("test"))) {
            new Server(new AsynchronousServerNode(string), n);
            new LockWatcher(1800000L, 60000L, n).start();
        }
        if (properties.getProperty("test") != null) {
            Socket socket = new Socket("localHost", n);
            BufferedSocketHandler bufferedSocketHandler = new BufferedSocketHandler(socket, new SocketWatcher(){

                public void handleMessage(String string) {
                    System.err.println(string);
                }

                public void socketClosed(SocketHandler socketHandler) {
                }
            });
            bufferedSocketHandler.start();
            bufferedSocketHandler.writeLine(Protocol.encodeRegisterCommand("rk", "test/Main Room", ""));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("JOIN")) {
                        String string3 = string2.substring("JOIN".length()).trim();
                        bufferedSocketHandler.writeLine(Protocol.encodeJoinCommand("test/" + string3));
                        continue;
                    }
                    if (string2.startsWith("BYE")) {
                        bufferedSocketHandler.close();
                        continue;
                    }
                    if (string2.startsWith("HELLO")) {
                        socket = new Socket("localHost", n);
                        bufferedSocketHandler = new BufferedSocketHandler(socket, new SocketWatcher(){

                            public void handleMessage(String string) {
                                System.err.println(string);
                            }

                            public void socketClosed(SocketHandler socketHandler) {
                            }
                        });
                        bufferedSocketHandler.start();
                        bufferedSocketHandler.writeLine(Protocol.encodeRegisterCommand("rk", "test/Main Room", ""));
                        continue;
                    }
                    if (string2.startsWith("*")) {
                        int n2 = Integer.parseInt(string2.substring(1));
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < n2; ++i) {
                            char c = (char)(97 + i % 10);
                            if (c == 'a') {
                                c = 'A';
                            }
                            stringBuilder.append(c);
                        }
                        String string4 = Protocol.encodeForwardCommand("test/*", stringBuilder.toString());
                        bufferedSocketHandler.writeLine(string4);
                        continue;
                    }
                    bufferedSocketHandler.writeLine(string2);
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

