/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZonedGridHighlighter;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZonedGrid
extends AbstractConfigurable
implements GeometricGrid,
GridContainer {
    protected List<Zone> zones = new ArrayList<Zone>();
    protected MapGrid background;
    protected GridContainer container;
    protected ZonedGridHighlighter zoneHighlighters;
    protected Area scaledZones = null;
    protected Area translatedZones = null;
    protected AffineTransform scaleTransform;
    protected AffineTransform translateTransform;
    protected double lastScale = 0.0;
    protected int lastX = -1;
    protected int lastY = -1;

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String string) {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.container = (GridContainer)((Object)buildable);
        this.container.setGrid(this);
    }

    public GridContainer getContainer() {
        return this.container;
    }

    @Override
    public Dimension getSize() {
        return this.container.getSize();
    }

    @Override
    public boolean contains(Point point) {
        return this.container.contains(point);
    }

    @Override
    public void removeGrid(MapGrid mapGrid) {
        if (this.background == mapGrid) {
            this.background = null;
        }
    }

    @Override
    public Board getBoard() {
        return this.container != null ? this.container.getBoard() : null;
    }

    public Map getMap() {
        return this.getBoard() == null ? null : this.getBoard().getMap();
    }

    @Override
    public void setGrid(MapGrid mapGrid) {
        this.background = mapGrid;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.background == null) {
            Class[] classArray2 = new Class[4];
            classArray2[0] = Zone.class;
            classArray2[1] = HexGrid.class;
            classArray2[2] = SquareGrid.class;
            classArray = classArray2;
            classArray2[3] = RegionGrid.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = Zone.class;
        }
        return classArray;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MultiZoneGrid.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ZonedGrid.htm");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((GridContainer)((Object)buildable)).removeGrid(this);
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.background != null && this.background.isVisible()) {
            if (this.lastScale != d || this.scaleTransform == null) {
                this.scaleTransform = AffineTransform.getScaleInstance(d, d);
                this.scaledZones = null;
                for (Zone object2 : this.zones) {
                    if (object2.isUseParentGrid()) continue;
                    if (this.scaledZones == null) {
                        this.scaledZones = new Area(this.scaleTransform.createTransformedShape(object2.getShape()));
                        continue;
                    }
                    this.scaledZones.add(new Area(this.scaleTransform.createTransformedShape(object2.getShape())));
                }
                this.lastScale = d;
                this.translateTransform = null;
            }
            if (this.lastX != rectangle.x || this.lastY != rectangle.y || this.translateTransform == null) {
                this.translateTransform = AffineTransform.getTranslateInstance(rectangle.x, rectangle.y);
                this.translatedZones = null;
                if (this.scaledZones != null) {
                    this.translatedZones = new Area(this.translateTransform.createTransformedShape(this.scaledZones));
                }
                this.lastX = rectangle.x;
                this.lastY = rectangle.y;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            if (this.translatedZones != null && shape != null) {
                Area area = new Area(shape);
                area.subtract(this.translatedZones);
                graphics2D.setClip(area);
            }
            this.background.draw(graphics, rectangle, rectangle2, d, bl);
            graphics2D.setClip(shape);
        }
        for (Zone zone : this.zones) {
            zone.draw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    @Override
    public GridNumbering getGridNumbering() {
        return this.background != null ? this.background.getGridNumbering() : null;
    }

    @Override
    public Point getLocation(String string) throws MapGrid.BadCoords {
        for (Zone zone : this.zones) {
            try {
                Point point = zone.getLocation(string);
                if (point == null || !zone.contains(point)) continue;
                return point;
            }
            catch (MapGrid.BadCoords badCoords) {
            }
        }
        if (this.background != null) {
            return this.background.getLocation(string);
        }
        throw new MapGrid.BadCoords();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String locationName(Point point) {
        String string = null;
        for (Zone zone : this.zones) {
            if (!zone.contains(point)) continue;
            string = zone.locationName(point);
            break;
        }
        if (string == null && this.background != null) {
            string = this.background.locationName(point);
        }
        return string;
    }

    @Override
    public String localizedLocationName(Point point) {
        String string = null;
        for (Zone zone : this.zones) {
            if (!zone.contains(point)) continue;
            string = zone.localizedLocationName(point);
            break;
        }
        if (string == null && this.background != null) {
            string = this.background.localizedLocationName(point);
        }
        return string;
    }

    @Override
    public int range(Point point, Point point2) {
        Zone zone;
        MapGrid mapGrid = this.background;
        Zone zone2 = this.findZone(point);
        if (zone2 == (zone = this.findZone(point2)) && zone2 != null && zone2.getGrid() != null) {
            mapGrid = zone2.getGrid();
        }
        return mapGrid != null ? mapGrid.range(point, point2) : (int)Math.round(point.distance(point2));
    }

    @Override
    public Area getGridShape(Point point, int n) {
        Area area = null;
        Zone zone = this.findZone(point);
        if (zone != null && zone.getGrid() instanceof GeometricGrid) {
            area = ((GeometricGrid)zone.getGrid()).getGridShape(point, n);
        }
        if (area == null && this.background instanceof GeometricGrid) {
            area = ((GeometricGrid)this.background).getGridShape(point, n);
        }
        if (area == null) {
            area = new Area(new Ellipse2D.Double(point.x - n, point.y - n, n * 2, n * 2));
        }
        return area;
    }

    public Zone findZone(Point point) {
        for (Zone zone : this.zones) {
            if (!zone.contains(point)) continue;
            return zone;
        }
        return null;
    }

    public Zone findZone(String string) {
        for (Zone zone : this.zones) {
            if (!zone.getName().equals(string)) continue;
            return zone;
        }
        return null;
    }

    @Override
    public Point snapTo(Point point) {
        Point point2 = null;
        Zone zone = this.findZone(point);
        if (zone != null) {
            point2 = zone.snapTo(point);
        }
        if (point2 == null) {
            point2 = this.background != null ? this.background.snapTo(point) : point;
        }
        return point2;
    }

    @Override
    public boolean isLocationRestricted(Point point) {
        for (Zone zone : this.zones) {
            if (!zone.contains(point)) continue;
            return zone.getGrid() != null && zone.getGrid().isLocationRestricted(point);
        }
        return this.background != null && this.background.isLocationRestricted(point);
    }

    public void addZone(Zone zone) {
        this.zones.add(zone);
    }

    public void removeZone(Zone zone) {
        this.zones.remove(zone);
    }

    public Iterator<Zone> getZones() {
        return this.zones.iterator();
    }

    public MapGrid getBackgroundGrid() {
        return this.background;
    }

    public void setBackgroundGrid(MapGrid mapGrid) {
        this.background = mapGrid;
    }

    @Override
    public void build(Element element) {
        super.build(element);
        if (this.getComponentsOf(ZonedGridHighlighter.class).isEmpty()) {
            this.addChild(new ZonedGridHighlighter());
        }
    }

    private void addChild(Buildable buildable) {
        this.add(buildable);
        buildable.addTo(this);
    }

    public void setZoneHighlighter(ZonedGridHighlighter zonedGridHighlighter) {
        this.zoneHighlighters = zonedGridHighlighter;
    }

    public ZoneHighlight getZoneHighlight(String string) {
        if (this.zoneHighlighters != null) {
            return this.zoneHighlighters.getZoneHighlightByName(string);
        }
        return null;
    }
}

