/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.AddPiece;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrototypeDefinition
extends AbstractConfigurable
implements UniqueIdManager.Identifyable,
ValidityChecker {
    private String name = "Prototype";
    private Map<String, GamePiece> pieces = new HashMap<String, GamePiece>();
    private String pieceDefinition;
    private static UniqueIdManager idMgr = new UniqueIdManager("prototype-");
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    @Override
    public void setConfigureName(String string) {
        String string2 = this.name;
        this.name = string;
        this.propSupport.firePropertyChange("name", string2, this.name);
    }

    @Override
    public Configurer getConfigurer() {
        return new Config(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "Definition");
    }

    @Override
    public void remove(Buildable buildable) {
        idMgr.remove(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public void add(Buildable buildable) {
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setId(String string) {
    }

    @Override
    public void validate(Buildable buildable, ValidationReport validationReport) {
        idMgr.validate(this, validationReport);
    }

    @Override
    public void addTo(Buildable buildable) {
        idMgr.add(this);
    }

    public GamePiece getPiece() {
        return this.getPiece(this.pieceDefinition);
    }

    public GamePiece getPiece(PropertySource propertySource) {
        String string = propertySource == null ? this.pieceDefinition : new FormattedString(this.pieceDefinition).getText(propertySource);
        return this.getPiece(string);
    }

    protected GamePiece getPiece(String string) {
        GamePiece gamePiece = this.pieces.get(string);
        if (gamePiece == null && string != null) {
            try {
                AddPiece addPiece = (AddPiece)GameModule.getGameModule().decode(string);
                if (addPiece == null) {
                    ErrorDialog.dataError(new BadDataReport("Couldn't build piece ", string, null));
                } else {
                    gamePiece = addPiece.getTarget();
                    gamePiece.setState(addPiece.getState());
                }
            }
            catch (RuntimeException runtimeException) {
                ErrorDialog.dataError(new BadDataReport("Couldn't build piece", string, runtimeException));
            }
        }
        return gamePiece;
    }

    public void setPiece(GamePiece gamePiece) {
        this.pieceDefinition = gamePiece == null ? null : GameModule.getGameModule().encode(new AddPiece(gamePiece));
        this.pieces.clear();
    }

    @Override
    public void build(Element element) {
        if (element != null) {
            this.setConfigureName(element.getAttribute("name"));
            this.pieceDefinition = Builder.getText(element);
        }
    }

    @Override
    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        element.setAttribute("name", this.name);
        element.appendChild(document.createTextNode(this.pieceDefinition));
        return element;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Prototype.component_type");
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String string) {
        return this.getI18nData().getLocalUntranslatedValue(string);
    }

    @Override
    public ComponentI18nData getI18nData() {
        return new ComponentI18nData((Configurable)this, this.getPiece());
    }

    public static class Config
    extends Configurer {
        private Box box = Box.createVerticalBox();
        private PieceDefiner pieceDefiner;
        private StringConfigurer name;
        private PrototypeDefinition def;

        public Config(PrototypeDefinition prototypeDefinition) {
            super(null, null, prototypeDefinition);
            this.name = new StringConfigurer(null, Resources.getString("Editor.name_label"), prototypeDefinition.name);
            this.box.add(this.name.getControls());
            this.pieceDefiner = new Definer(GameModule.getGameModule().getGpIdSupport());
            this.pieceDefiner.setPiece(prototypeDefinition.getPiece());
            this.box.add(this.pieceDefiner);
            this.def = prototypeDefinition;
        }

        public Object getValue() {
            if (this.def != null) {
                this.def.setPiece(this.pieceDefiner.getPiece());
                this.def.setConfigureName(this.name.getValueString());
            }
            return this.def;
        }

        public Component getControls() {
            return this.box;
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }

        public static class Definer
        extends PieceDefiner {
            private static final long serialVersionUID = 1L;

            public Definer(GpIdSupport gpIdSupport) {
                super(gpIdSupport);
            }

            public void setPiece(GamePiece gamePiece) {
                if (gamePiece != null) {
                    GamePiece gamePiece2 = Decorator.getInnermost(gamePiece);
                    if (!(gamePiece2 instanceof Plain)) {
                        Plain plain = new Plain();
                        Object object = gamePiece2.getProperty("Outer");
                        if (object instanceof Decorator) {
                            ((Decorator)object).setInner(plain);
                        }
                        gamePiece = Decorator.getOutermost(plain);
                    }
                } else {
                    gamePiece = new Plain();
                }
                super.setPiece(gamePiece);
            }

            protected void removeTrait(int n) {
                if (n > 0) {
                    super.removeTrait(n);
                }
            }

            private static class Plain
            extends BasicPiece {
                public Plain() {
                    super("piece;;;;;");
                }

                public String getDescription() {
                    return "";
                }

                public PieceEditor getEditor() {
                    return null;
                }
            }
        }
    }
}

