/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.Info;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TempFileManager {
    private static final Logger logger = LoggerFactory.getLogger(TempFileManager.class);
    private final File tmpRoot;
    private File sessionRoot;
    private File lock;
    private static final String DIR_PREFIX = "vassal-";
    private static final TempFileManager instance = new TempFileManager();

    private TempFileManager() {
        if (SystemUtils.IS_OS_WINDOWS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    long l = 1L;
                    while (true) {
                        System.gc();
                        System.runFinalization();
                        try {
                            TempFileManager.this.cleanupSessionRoot();
                        }
                        catch (IOException iOException) {
                            if (l > 1024L) {
                                logger.error("", (Throwable)iOException);
                                break;
                            }
                            try {
                                Thread.sleep(l);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            l *= 2L;
                            continue;
                        }
                        break;
                    }
                }
            });
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        TempFileManager.this.cleanupSessionRoot();
                    }
                    catch (IOException iOException) {
                        logger.error("", (Throwable)iOException);
                    }
                }
            });
        }
        this.tmpRoot = Info.getTempDir();
        if (this.tmpRoot.exists() && this.tmpRoot.isDirectory()) {
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().startsWith(TempFileManager.DIR_PREFIX);
                }
            };
            for (File file : this.tmpRoot.listFiles(fileFilter)) {
                File file2 = new File(file.getParent(), file.getName() + ".lck");
                if (file2.exists()) continue;
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException iOException) {
                    logger.error("", (Throwable)iOException);
                }
            }
        }
    }

    private void cleanupSessionRoot() throws IOException {
        if (this.lock.exists()) {
            FileUtils.forceDelete((File)this.lock);
        }
        FileUtils.forceDelete((File)this.sessionRoot);
    }

    public static TempFileManager getInstance() {
        return instance;
    }

    public File getSessionRoot() throws IOException {
        if (this.sessionRoot == null) {
            this.sessionRoot = this.createSessionRoot();
        }
        return new File(this.sessionRoot.toString());
    }

    private File createSessionRoot() throws IOException {
        if (!this.tmpRoot.exists() || !this.tmpRoot.isDirectory() && !this.tmpRoot.delete()) {
            FileUtils.forceMkdir((File)this.tmpRoot);
        }
        File file = File.createTempFile(DIR_PREFIX, "", this.tmpRoot);
        file.delete();
        this.lock = new File(this.tmpRoot, file.getName() + ".lck");
        this.lock.createNewFile();
        this.lock.deleteOnExit();
        FileUtils.forceMkdir((File)file);
        return file;
    }

    public File createTempDir(String string) throws IOException {
        if (this.sessionRoot == null) {
            this.sessionRoot = this.createSessionRoot();
        }
        File file = new File(this.sessionRoot, string);
        FileUtils.forceMkdir((File)file);
        return file;
    }

    public File createTempFile(String string, String string2) throws IOException {
        if (this.sessionRoot == null) {
            this.sessionRoot = this.createSessionRoot();
        }
        return File.createTempFile(string, string2, this.sessionRoot);
    }
}

