/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports.adc2;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Inventory;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.LayerControl;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.Zoomer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.HexGridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.SquareGridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Marker;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Utils;
import VASSAL.tools.imports.adc2.SymbolSet;
import VASSAL.tools.io.IOUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class MapBoard
extends Importer {
    private static final String PLACE_NAME = "Location Names";
    private static final HashMap<Integer, Font> defaultFonts = new HashMap();
    private static final int zoomLevel = 2;
    private static final String[] defaultFontNames = new String[]{"Courier", "Fixedsys", "MS Sans Serif", "MS Serif", "Impact", "Brush Script MT", "System", "Times New Roman", "Arial"};
    private static final String PLACE_NAMES = "Place Names";
    private final ArrayList<HexData> attributes = new ArrayList();
    private String baseName;
    private Hex[] hexes;
    private final ArrayList<HexLine> hexLines = new ArrayList();
    private final ArrayList<HexSide> hexSides = new ArrayList();
    private Layout layout;
    private LineDefinition[] lineDefinitions;
    private ArrayList<MapLayer> mapElements = new ArrayList();
    private final ArrayList<MapSheet> mapSheets = new ArrayList();
    private final ArrayList<PlaceName> placeNames = new ArrayList();
    private final ArrayList<HexData> placeSymbols = new ArrayList();
    private final ArrayList<HexData> primaryMapBoardSymbols = new ArrayList();
    private final ArrayList<HexData> secondaryMapBoardSymbols = new ArrayList();
    private final ArrayList<MapBoardOverlay> overlaySymbol = new ArrayList();
    private SymbolSet set;
    private int columns;
    private int rows;
    private Color tableColor;
    private boolean isPreV208 = true;
    private String path;
    private BoardPicker boardPicker;
    private byte[] drawingPriorities = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    protected static Font getDefaultFont(int n, int n2) {
        Integer n3 = (n << 8) + n2;
        Font font = defaultFonts.get(n3);
        if (font == null) {
            int n4 = n2 & 0xF;
            assert (n4 >= 1 && n4 <= 9);
            boolean bl = (n2 & 0x10) > 0;
            boolean bl2 = (n2 & 0x20) > 0;
            boolean bl3 = (n2 & 0x40) > 0;
            String string = defaultFontNames[n4 - 1];
            int n5 = 0;
            if (bl2) {
                n5 |= 2;
            }
            if (bl) {
                n5 |= 1;
            }
            font = new Font(string, n5, n);
            if (bl3) {
                Hashtable<TextAttribute, Integer> hashtable = new Hashtable<TextAttribute, Integer>();
                hashtable.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                font = font.deriveFont(hashtable);
            }
            defaultFonts.put(n3, font);
        }
        return font;
    }

    public MapBoard() {
        this.mapElements.add(new MapLayer(this.primaryMapBoardSymbols, "Primary MapBoard Symbols", false));
        this.mapElements.add(new MapLayer(this.secondaryMapBoardSymbols, "Secondary MapBoard Symbols", false));
        this.mapElements.add(new MapLayer(this.hexSides, "Hex Sides", true));
        this.mapElements.add(new MapLayer(this.hexLines, "Hex Lines", true));
        this.mapElements.add(new MapLayer(this.placeSymbols, "Place Symbols", false));
        this.mapElements.add(new MapLayer(this.attributes, "Attributes", false));
        this.mapElements.add(new MapLayer(this.overlaySymbol, "Overlay Symbol", true));
        this.mapElements.add(new MapLayer(this.placeNames, PLACE_NAMES, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readScannedMapLayoutFile(File file, Graphics2D graphics2D) throws IOException {
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int n = ADC2Utils.readBase250Word(dataInputStream);
            for (int i = 0; i < n; ++i) {
                String string = MapBoard.stripExtension(MapBoard.readWindowsFileName(dataInputStream));
                File file2 = this.action.getCaseInsensitiveFile(new File(string + "-L" + 3 + ".bmp"), new File(this.path), true, null);
                if (file2 == null) {
                    throw new FileNotFoundException("Unable to find map image.");
                }
                BufferedImage bufferedImage = ImageIO.read(file2);
                int n2 = 0;
                int n3 = 0;
                for (int j = 0; j < 3; ++j) {
                    int n4 = ADC2Utils.readBase250Integer(dataInputStream);
                    int n5 = ADC2Utils.readBase250Integer(dataInputStream);
                    if (j != 2) continue;
                    n2 = n4;
                    n3 = n5;
                }
                graphics2D.drawImage(bufferedImage, null, n2, n3);
            }
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)dataInputStream);
    }

    protected void readMapBoardOverlaySymbolBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "MapBoard Overlay Symbol");
        SymbolSet.SymbolData symbolData = this.getSet().getMapBoardSymbol(ADC2Utils.readBase250Word(dataInputStream));
        if (symbolData != null) {
            this.overlaySymbol.add(new MapBoardOverlay(symbolData));
        }
    }

    protected void readMapItemDrawFlagBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Map Item Draw Flag");
        ArrayList<MapLayer> arrayList = new ArrayList<MapLayer>(this.mapElements);
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[0]));
        }
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[1]));
        }
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[2]));
        }
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[3]));
        }
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[4]));
        }
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[7]));
        }
        if (dataInputStream.readByte() == 0) {
            this.mapElements.remove(arrayList.get(this.drawingPriorities[5]));
        }
    }

    protected void readAttributeBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Attribute Symbol");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            SymbolSet.SymbolData symbolData = this.set.getMapBoardSymbol(ADC2Utils.readBase250Word(dataInputStream));
            if (!this.isOnMapBoard(n2) || symbolData == null) continue;
            this.attributes.add(new HexData(n2, symbolData));
        }
    }

    protected void readHexDataBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Hex Data");
        int n = this.getNColumns() * this.getNRows();
        for (int i = 0; i < n; ++i) {
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            SymbolSet.SymbolData symbolData = this.getSet().getMapBoardSymbol(n2);
            if (symbolData != null) {
                this.primaryMapBoardSymbols.add(new HexData(i, symbolData));
            }
            n2 = ADC2Utils.readBase250Word(dataInputStream);
            symbolData = this.getSet().getMapBoardSymbol(n2);
            if (symbolData != null) {
                this.secondaryMapBoardSymbols.add(new HexData(i, symbolData));
            }
            ADC2Utils.readBase250Word(dataInputStream);
            dataInputStream.readUnsignedByte();
        }
    }

    protected void readHexLineBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Hex Line");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedShort();
            if (!this.isOnMapBoard(n2)) continue;
            this.hexLines.add(new HexLine(n2, n3, n4));
        }
    }

    protected void readHexSideBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Hex Side");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedByte();
            if (!this.isOnMapBoard(n2)) continue;
            this.hexSides.add(new HexSide(n2, n3, n4));
        }
    }

    protected void readLineDefinitionBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Line Definition");
        int n = dataInputStream.readUnsignedByte();
        this.lineDefinitions = new LineDefinition[n];
        for (int i = 0; i < n; ++i) {
            LineStyle lineStyle;
            int n2;
            int n3 = dataInputStream.readUnsignedByte();
            Color color = ADC2Utils.getColorFromIndex(n3);
            byte by = 0;
            for (n2 = 0; n2 < 3; ++n2) {
                byte by2 = dataInputStream.readByte();
                if (n2 != 2) continue;
                by = by2;
            }
            MapBoard.readNullTerminatedString(dataInputStream, 25);
            n2 = dataInputStream.readUnsignedByte();
            switch (n2) {
                case 2: {
                    lineStyle = LineStyle.DOTTED;
                    break;
                }
                case 3: {
                    lineStyle = LineStyle.DASH_DOT;
                    break;
                }
                case 4: {
                    lineStyle = LineStyle.DASHED;
                    break;
                }
                case 5: {
                    lineStyle = LineStyle.DASH_DOT_DOT;
                    break;
                }
                default: {
                    lineStyle = LineStyle.SOLID;
                }
            }
            this.lineDefinitions[i] = by > 0 ? new LineDefinition(color, by, lineStyle) : null;
        }
    }

    protected void readLineDrawPriorityBlock(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        ADC2Utils.readBlockHeader(dataInputStream, "Line Draw Priority");
        dataInputStream.readByte();
        for (n2 = 1; n2 <= 10; ++n2) {
            n = dataInputStream.readUnsignedByte();
            if (n >= this.lineDefinitions.length || this.lineDefinitions[n] == null) continue;
            this.lineDefinitions[n].setHexLineDrawPriority(n2);
        }
        for (n2 = 1; n2 <= 10; ++n2) {
            n = dataInputStream.readUnsignedByte();
            if (n >= this.lineDefinitions.length || this.lineDefinitions[n] == null) continue;
            this.lineDefinitions[n].setHexSideDrawPriority(n2);
        }
    }

    protected void readMapSheetBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Map Sheet");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            int n3 = ADC2Utils.readBase250Word(dataInputStream);
            int n4 = ADC2Utils.readBase250Word(dataInputStream);
            int n5 = ADC2Utils.readBase250Word(dataInputStream);
            Rectangle rectangle = new Rectangle(n2, n3, n4 - n2 + 1, n5 - n3 + 1);
            String string = MapBoard.readNullTerminatedString(dataInputStream, 10);
            if (string.length() < 9) {
                dataInputStream.readFully(new byte[9 - string.length()]);
            }
            int n6 = dataInputStream.readUnsignedByte();
            dataInputStream.readFully(new byte[2]);
            int n7 = dataInputStream.readUnsignedByte();
            int n8 = dataInputStream.readUnsignedByte();
            if (i >= n - 1) continue;
            this.mapSheets.add(new MapSheet(string, rectangle, n6, n7, n8));
        }
    }

    protected void readHexNumberingBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Hex Numbering");
        for (int i = 0; i < this.mapSheets.size() + 1; ++i) {
            int n;
            int n2 = 0;
            for (n = 0; n < 4; ++n) {
                n2 <<= 8;
                n2 += dataInputStream.readUnsignedByte();
            }
            n = 0;
            for (int j = 0; j < 4; ++j) {
                n <<= 8;
                n += dataInputStream.readUnsignedByte();
            }
            if (i >= this.mapSheets.size()) continue;
            MapSheet mapSheet = this.mapSheets.get(i);
            mapSheet.setTopLeftCol(n2);
            mapSheet.setTopLeftRow(n);
        }
    }

    protected void readMapItemDrawingOrderBlock(DataInputStream dataInputStream) throws IOException {
        int n;
        ADC2Utils.readBlockHeader(dataInputStream, "Map Item Drawing Order");
        byte[] byArray = new byte[10];
        dataInputStream.readFully(byArray);
        ArrayList<MapLayer> arrayList = new ArrayList<MapLayer>(this.mapElements.size());
        for (n = 0; n < this.mapElements.size(); ++n) {
            if (byArray[n] >= this.mapElements.size() || byArray[n] < 0) {
                return;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (byArray[i] != byArray[n]) continue;
                    return;
                }
            }
            arrayList.add(this.mapElements.get(byArray[n]));
        }
        for (n = 0; n < this.mapElements.size(); ++n) {
            this.drawingPriorities[byArray[n]] = (byte)n;
        }
        this.mapElements = arrayList;
    }

    protected void readVersionBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "File Format Version");
        byte by = dataInputStream.readByte();
        this.isPreV208 = by != 0;
    }

    protected void readTableColorBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Table Color");
        dataInputStream.readByte();
        this.tableColor = ADC2Utils.getColorFromIndex(dataInputStream.readUnsignedByte());
    }

    protected void readPlaceNameBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Place Name");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = ADC2Utils.readBase250Word(dataInputStream);
            SymbolSet.SymbolData symbolData = this.getSet().getMapBoardSymbol(ADC2Utils.readBase250Word(dataInputStream));
            if (symbolData != null && this.isOnMapBoard(n3)) {
                this.placeSymbols.add(new HexData(n3, symbolData));
            }
            String string = MapBoard.readNullTerminatedString(dataInputStream, 25);
            Color color = ADC2Utils.getColorFromIndex(dataInputStream.readUnsignedByte());
            int n4 = 0;
            for (int j = 0; j < 3; ++j) {
                n2 = dataInputStream.readUnsignedByte();
                if (j != 2) continue;
                n4 = n2;
            }
            PlaceNameOrientation placeNameOrientation = null;
            block13: for (n2 = 0; n2 < 3; ++n2) {
                byte by = dataInputStream.readByte();
                if (n2 != 2) continue;
                switch (by) {
                    case 1: {
                        placeNameOrientation = PlaceNameOrientation.LOWER_CENTER;
                        continue block13;
                    }
                    case 2: {
                        placeNameOrientation = PlaceNameOrientation.UPPER_CENTER;
                        continue block13;
                    }
                    case 3: {
                        placeNameOrientation = PlaceNameOrientation.LOWER_RIGHT;
                        continue block13;
                    }
                    case 4: {
                        placeNameOrientation = PlaceNameOrientation.UPPER_RIGHT;
                        continue block13;
                    }
                    case 5: {
                        placeNameOrientation = PlaceNameOrientation.UPPER_LEFT;
                        continue block13;
                    }
                    case 6: {
                        placeNameOrientation = PlaceNameOrientation.LOWER_LEFT;
                        continue block13;
                    }
                    case 7: {
                        placeNameOrientation = PlaceNameOrientation.CENTER_LEFT;
                        continue block13;
                    }
                    case 8: {
                        placeNameOrientation = PlaceNameOrientation.CENTER_RIGHT;
                        continue block13;
                    }
                    case 9: {
                        placeNameOrientation = PlaceNameOrientation.HEX_CENTER;
                    }
                }
            }
            n2 = dataInputStream.readUnsignedByte();
            if (!this.isOnMapBoard(n3) || string.length() == 0 || placeNameOrientation == null) continue;
            this.placeNames.add(new PlaceName(n3, string, color, placeNameOrientation, n4, n2));
        }
    }

    boolean isOnMapBoard(int n) {
        return this.isOnMapBoard(n % this.columns, n / this.columns);
    }

    boolean isOnMapBoard(int n, int n2) {
        return n >= 0 && n < this.columns && n2 >= 0 && n2 < this.rows;
    }

    protected Layout getLayout() {
        return this.layout;
    }

    protected LineDefinition getLineDefinition(int n) {
        if (n < 0 | n >= this.lineDefinitions.length) {
            return null;
        }
        return this.lineDefinitions[n];
    }

    int getNColumns() {
        return this.columns;
    }

    int getNRows() {
        return this.rows;
    }

    SymbolSet getSet() {
        return this.set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(File file) throws IOException {
        super.load(file);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.baseName = MapBoard.stripExtension(file.getName());
            this.path = file.getPath();
            byte by = dataInputStream.readByte();
            if (by != -3) {
                throw new FileFormatException("Invalid Mapboard File Header");
            }
            dataInputStream.readFully(new byte[2]);
            String string = MapBoard.readWindowsFileName(dataInputStream);
            String string2 = MapBoard.forceExtension(string, "set");
            this.set = new SymbolSet();
            File file2 = this.action.getCaseInsensitiveFile(new File(string2), file, true, new ExtensionFileFilter("ADC2 Symbol Set", new String[]{".set"}));
            if (file2 == null) {
                throw new FileNotFoundException("Unable to find symbol set file.");
            }
            this.set.importFile(this.action, file2);
            dataInputStream.readByte();
            this.columns = ADC2Utils.readBase250Word(dataInputStream);
            this.rows = ADC2Utils.readBase250Word(dataInputStream);
            int n = this.set.getMapBoardSymbolSize();
            this.readHexDataBlock(dataInputStream);
            this.readPlaceNameBlock(dataInputStream);
            this.readHexSideBlock(dataInputStream);
            this.readLineDefinitionBlock(dataInputStream);
            this.readAttributeBlock(dataInputStream);
            this.readMapSheetBlock(dataInputStream);
            this.readHexLineBlock(dataInputStream);
            this.readLineDrawPriorityBlock(dataInputStream);
            int n2 = dataInputStream.read();
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.set.getMapBoardSymbolShape() == SymbolSet.Shape.SQUARE) {
                        this.layout = new GridOffsetColumnLayout(n, this.columns, this.rows);
                        break;
                    }
                    this.layout = new VerticalHexLayout(n, this.columns, this.rows);
                    break;
                }
                case 2: {
                    if (this.set.getMapBoardSymbolShape() == SymbolSet.Shape.SQUARE) {
                        this.layout = new GridOffsetRowLayout(n, this.columns, this.rows);
                        break;
                    }
                    this.layout = new HorizontalHexLayout(n, this.columns, this.rows);
                    break;
                }
                default: {
                    this.layout = new GridLayout(n, this.columns, this.rows);
                }
            }
            dataInputStream.readByte();
            dataInputStream.readShort();
            dataInputStream.readShort();
            dataInputStream.readByte();
            this.readTableColorBlock(dataInputStream);
            this.readHexNumberingBlock(dataInputStream);
            try {
                this.readMapBoardOverlaySymbolBlock(dataInputStream);
                this.readVersionBlock(dataInputStream);
                this.readMapItemDrawingOrderBlock(dataInputStream);
                this.readMapItemDrawFlagBlock(dataInputStream);
            }
            catch (ADC2Utils.NoMoreBlocksException noMoreBlocksException) {
                // empty catch block
            }
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)dataInputStream);
    }

    int getNFaces() {
        return this.getLayout().getNFaces();
    }

    Point getCenterOffset() {
        return this.getLayout().getOrigin();
    }

    Point coordinatesToPosition(int n, int n2) {
        return this.getLayout().coordinatesToPosition(n, n2, true);
    }

    Point indexToPosition(int n) {
        return this.getLayout().coordinatesToPosition(n % this.columns, n / this.columns, true);
    }

    Point indexToPosition(int n, boolean bl) {
        return this.getLayout().coordinatesToPosition(n % this.columns, n / this.columns, bl);
    }

    Point indexToCenterPosition(int n) {
        Point point = this.indexToPosition(n);
        if (point == null) {
            return point;
        }
        point.translate(this.getLayout().getDeltaX() / 2, this.getLayout().getDeltaY() / 2);
        return point;
    }

    public void writeToArchive() throws IOException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object4;
        GameModule gameModule = GameModule.getGameModule();
        BaseLayer baseLayer = new BaseLayer();
        if (!baseLayer.hasBaseMap()) {
            object4 = this.mapElements.iterator();
            while (object4.hasNext()) {
                baseLayer.overlay(object4.next());
                object4.remove();
            }
            this.mapElements.add(baseLayer);
        } else {
            this.mapElements.add(0, baseLayer);
            object4 = this.mapElements.iterator();
            object4.next();
            while (object4.hasNext()) {
                MapLayer object32 = object4.next();
                if (object32.isSwitchable()) continue;
                object2 = this.mapElements.iterator();
                object = object2.next();
                while (object != object32) {
                    ((MapLayer)object).overlay(object32);
                    object = object2.next();
                }
                object4.remove();
            }
            this.mapElements.add(0, baseLayer);
        }
        for (MapLayer mapLayer : this.mapElements) {
            mapLayer.writeToArchive();
        }
        this.getMainMap().setAttribute("moveWithinFormat", "$pieceName$ moving from [$previousLocation$] to [$location$]");
        this.getMainMap().setAttribute("moveToFormat", "$pieceName$ moving from [$previousLocation$] to [$location$]");
        this.getMainMap().setAttribute("createFormat", "$pieceName$ Added to [$location$]");
        object4 = this.getLayout().getGeometricGrid();
        if (this.mapSheets.size() == 1 && this.mapSheets.get(0) == null) {
            this.mapSheets.remove(0);
        }
        Board board = this.getBoard();
        if (this.mapSheets.size() > 0) {
            object2 = new ZonedGrid();
            object = this.mapSheets.iterator();
            while (object.hasNext() && (stringArray = (String[])object.next()) != null) {
                Zone zone = stringArray.getZone();
                if (zone == null) continue;
                MapBoard.insertComponent(zone, (Buildable)object2);
            }
            MapBoard.insertComponent((Buildable)object4, (Buildable)object2);
            MapBoard.insertComponent((Buildable)object2, board);
        } else {
            MapBoard.insertComponent((Buildable)object4, board);
        }
        object2 = gameModule.getAllDescendantComponentsOf(GlobalOptions.class).toArray(new GlobalOptions[0])[0];
        ((GlobalOptions)object2).setAttribute("autoReport", "Always");
        object = new Zoomer();
        stringArray = new String[3];
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = Double.toString(this.set.getZoomFactor(i));
        }
        ((Zoomer)object).setAttribute("zoomLevels", StringArrayConfigurer.arrayToString(stringArray));
        MapBoard.insertComponent((Buildable)object, this.getMainMap());
        if (this.placeNames.size() > 0) {
            this.writePlaceNames(gameModule);
        }
        object = new Inventory();
        MapBoard.insertComponent((Buildable)object, gameModule);
        ((Inventory)object).setAttribute("text", "Search");
        ((Inventory)object).setAttribute("tooltip", "Find place by name");
        ((Inventory)object).setAttribute("include", "CurrentMap = Main Map && Type != Layer");
        ((Inventory)object).setAttribute("icon", "");
        ((Inventory)object).setAttribute("groupBy", "Type");
    }

    protected void writePlaceNames(GameModule gameModule) {
        PrototypesContainer prototypesContainer = gameModule.getAllDescendantComponentsOf(PrototypesContainer.class).iterator().next();
        PrototypeDefinition prototypeDefinition = new PrototypeDefinition();
        MapBoard.insertComponent(prototypeDefinition, prototypesContainer);
        prototypeDefinition.setConfigureName(PLACE_NAMES);
        EditablePiece editablePiece = new BasicPiece();
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        sequenceEncoder.append("Type");
        editablePiece = new Marker("mark;" + sequenceEncoder.getValue(), editablePiece);
        editablePiece.setProperty("Type", PLACE_NAME);
        editablePiece = new Immobilized(editablePiece, "immob;n;V");
        prototypeDefinition.setPiece(editablePiece);
        this.getMainMap();
        Point point = this.getCenterOffset();
        HashSet<String> hashSet = new HashSet<String>();
        Board board = this.getBoard();
        for (PlaceName placeName : this.placeNames) {
            String string = placeName.getText();
            Point point2 = placeName.getPosition();
            if (point2 == null || hashSet.contains(string)) continue;
            hashSet.add(string);
            SetupStack setupStack = new SetupStack();
            MapBoard.insertComponent(setupStack, this.getMainMap());
            point2.translate(point.x, point.y);
            String string2 = this.getMainMap().locationName(point2);
            setupStack.setAttribute("name", string);
            setupStack.setAttribute("owningBoard", board.getConfigureName());
            MapGrid mapGrid = board.getGrid();
            Zone zone = null;
            if (mapGrid instanceof ZonedGrid) {
                zone = ((ZonedGrid)mapGrid).findZone(point2);
            }
            setupStack.setAttribute("x", Integer.toString(point2.x));
            setupStack.setAttribute("y", Integer.toString(point2.y));
            if (zone != null) {
                try {
                    if (mapGrid.getLocation(string2) != null) {
                        assert (mapGrid.locationName(mapGrid.getLocation(string2)).equals(string2));
                        setupStack.setAttribute("useGridLocation", true);
                        setupStack.setAttribute("location", string2);
                    }
                }
                catch (MapGrid.BadCoords badCoords) {
                    // empty catch block
                }
            }
            BasicPiece basicPiece = new BasicPiece();
            sequenceEncoder = new SequenceEncoder("piece;", ';');
            sequenceEncoder.append("").append("").append("").append(string);
            basicPiece.mySetType(sequenceEncoder.getValue());
            sequenceEncoder = new SequenceEncoder("prototype;".replaceAll(";", ""), ';');
            sequenceEncoder.append(PLACE_NAMES);
            editablePiece = new UsePrototype(sequenceEncoder.getValue(), basicPiece);
            PieceSlot pieceSlot = new PieceSlot(editablePiece);
            MapBoard.insertComponent(pieceSlot, setupStack);
        }
    }

    boolean isPreV208Layout() {
        return this.isPreV208;
    }

    Board getBoard() {
        BoardPicker boardPicker = this.getBoardPicker();
        String[] stringArray = boardPicker.getAllowableBoardNames();
        assert (stringArray.length <= 1);
        Board board = null;
        if (stringArray.length == 0) {
            board = new Board();
            MapBoard.insertComponent(board, boardPicker);
        } else {
            board = boardPicker.getBoard(stringArray[0]);
        }
        return board;
    }

    private ToolbarMenu getToolbarMenu() {
        List<ToolbarMenu> list = this.getMainMap().getComponentsOf(ToolbarMenu.class);
        ToolbarMenu toolbarMenu = null;
        if (list.size() == 0) {
            toolbarMenu = new ToolbarMenu();
            MapBoard.insertComponent(toolbarMenu, this.getMainMap());
            toolbarMenu.setAttribute("text", "View");
            toolbarMenu.setAttribute("tooltip", "Toggle visibility of map elements");
        } else {
            assert (list.size() == 1);
            toolbarMenu = list.get(0);
        }
        return toolbarMenu;
    }

    Color getTableColor() {
        return this.tableColor;
    }

    BoardPicker getBoardPicker() {
        if (this.boardPicker == null) {
            this.boardPicker = this.getMainMap().getAllDescendantComponentsOf(BoardPicker.class).toArray(new BoardPicker[0])[0];
        }
        return this.boardPicker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidImportFile(File file) throws IOException {
        boolean bl;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
            boolean bl2 = dataInputStream.readByte() == -3;
            dataInputStream.close();
            bl = bl2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)dataInputStream);
        return bl;
    }

    static /* synthetic */ Hex[] access$1502(MapBoard mapBoard, Hex[] hexArray) {
        mapBoard.hexes = hexArray;
        return hexArray;
    }

    protected abstract class Layout {
        protected final int nColumns;
        protected final int nRows;
        private final int size;

        Layout(int n, int n2, int n3) {
            this.size = n;
            this.nColumns = n2;
            this.nRows = n3;
        }

        protected int getRow(int n) {
            return n / this.nColumns;
        }

        protected int getCol(int n) {
            return n % this.nColumns;
        }

        void constrainRectangle(Point point, Point point2) {
            if (point.x < 0) {
                point.x = 0;
            }
            if (point.y < 0) {
                point.y = 0;
            }
            Dimension dimension = this.getBoardSize();
            if (point2.x >= dimension.width) {
                point2.x = dimension.width - 1;
            }
            if (point2.y >= dimension.height) {
                point2.y = dimension.height - 1;
            }
        }

        abstract int getNFaces();

        void initGridNumbering(RegularGridNumbering regularGridNumbering, MapSheet mapSheet) {
            regularGridNumbering.setAttribute("first", mapSheet.colsAndRows() ? "H" : "V");
            regularGridNumbering.setAttribute("hType", mapSheet.numericCols() ? "N" : "A");
            regularGridNumbering.setAttribute("hLeading", mapSheet.getNColChars() - 1);
            regularGridNumbering.setAttribute("hDescend", mapSheet.colsIncreaseLeft());
            regularGridNumbering.setAttribute("hDescend", mapSheet.colsIncreaseLeft());
            regularGridNumbering.setAttribute("vType", mapSheet.numericRows() ? "N" : "A");
            regularGridNumbering.setAttribute("vLeading", mapSheet.getNRowChars() - 1);
            regularGridNumbering.setAttribute("vDescend", mapSheet.rowsIncreaseUp());
        }

        void setGridNumberingOffsets(RegularGridNumbering regularGridNumbering, MapSheet mapSheet) {
            Point point = this.coordinatesToPosition(mapSheet.getField().x, mapSheet.getField().y, true);
            point.translate(this.getDeltaX() / 2, this.getDeltaY() / 2);
            int n = regularGridNumbering.getRow(point);
            int n2 = regularGridNumbering.getColumn(point);
            n = -n + mapSheet.getTopLeftRow();
            n2 = -n2 + mapSheet.getTopLeftCol();
            regularGridNumbering.setAttribute("hOff", n2);
            regularGridNumbering.setAttribute("vOff", n);
        }

        abstract RegularGridNumbering getGridNumbering();

        abstract Point coordinatesToPosition(int var1, int var2, boolean var3);

        abstract Dimension getBoardSize();

        abstract int getDeltaX();

        abstract int getDeltaY();

        Point getEast(int n) {
            int n2 = this.getRow(n);
            int n3 = this.getCol(n) + 1;
            return this.coordinatesToPosition(n3, n2, false);
        }

        abstract AbstractConfigurable getGeometricGrid();

        Point getNorth(int n) {
            int n2 = this.getRow(n) - 1;
            int n3 = this.getCol(n);
            return this.coordinatesToPosition(n3, n2, false);
        }

        Point getNorthEast(int n) {
            int n2 = this.getRow(n) - 1;
            int n3 = this.getCol(n) + 1;
            return this.coordinatesToPosition(n3, n2, false);
        }

        Point getNorthWest(int n) {
            int n2 = this.getRow(n) - 1;
            int n3 = this.getCol(n) - 1;
            return this.coordinatesToPosition(n3, n2, false);
        }

        abstract Point getOrigin();

        abstract Rectangle getRectangle(MapSheet var1);

        int getHexSize() {
            return this.size;
        }

        Point getSouth(int n) {
            int n2 = this.getRow(n) + 1;
            int n3 = this.getCol(n);
            return this.coordinatesToPosition(n3, n2, false);
        }

        Point getSouthEast(int n) {
            int n2 = this.getRow(n) + 1;
            int n3 = this.getCol(n) + 1;
            return MapBoard.this.getLayout().coordinatesToPosition(n3, n2, false);
        }

        Point getSouthWest(int n) {
            int n2 = this.getRow(n) + 1;
            int n3 = this.getCol(n) - 1;
            return this.coordinatesToPosition(n3, n2, false);
        }

        Point getWest(int n) {
            int n2 = this.getRow(n);
            int n3 = this.getCol(n) - 1;
            return this.coordinatesToPosition(n3, n2, false);
        }
    }

    protected abstract class VerticalLayout
    extends Layout {
        int getNFaces() {
            return 6;
        }

        VerticalLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        HexGridNumbering getGridNumbering() {
            return new HexGridNumbering();
        }

        void initGridNumbering(RegularGridNumbering regularGridNumbering, MapSheet mapSheet) {
            boolean bl = false;
            if (mapSheet.firstHexDown() && (mapSheet.getField().x & 1) == 1) {
                bl = true;
            } else if (mapSheet.firstHexUp() && mapSheet.getField().x % 2 == 0) {
                bl = true;
            }
            regularGridNumbering.setAttribute("stagger", bl);
            super.initGridNumbering(regularGridNumbering, mapSheet);
        }

        Point coordinatesToPosition(int n, int n2, boolean bl) {
            if (!bl || MapBoard.this.isOnMapBoard(n, n2)) {
                int n3 = this.getDeltaX() * n;
                int n4 = this.getDeltaY() * n2 + n % 2 * this.getDeltaY() / 2;
                return new Point(n3, n4);
            }
            return null;
        }

        Point getNorthEast(int n) {
            int n2 = this.getCol(n) + 1;
            int n3 = this.getRow(n) - Math.abs(n2) % 2;
            return this.coordinatesToPosition(n2, n3, false);
        }

        Point getNorthWest(int n) {
            int n2 = this.getCol(n) - 1;
            int n3 = this.getRow(n) - Math.abs(n2) % 2;
            return this.coordinatesToPosition(n2, n3, false);
        }

        Rectangle getRectangle(MapSheet mapSheet) {
            Rectangle rectangle = mapSheet.getField();
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                return null;
            }
            Point point = this.coordinatesToPosition(rectangle.x, rectangle.y, false);
            Point point2 = this.coordinatesToPosition(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, false);
            if (mapSheet.firstHexUp()) {
                point.y -= this.getHexSize() / 2;
            }
            if (rectangle.x % 2 == (rectangle.x + rectangle.width - 1) % 2) {
                if (mapSheet.firstHexDown()) {
                    point2.y += this.getHexSize() / 2;
                }
            } else if ((rectangle.x & 1) == 1) {
                point2.y = mapSheet.firstHexDown() ? (point2.y += this.getHexSize()) : (point2.y += this.getHexSize() / 2);
            } else if (mapSheet.firstHexUp() && rectangle.x % 2 == 0) {
                point2.y -= this.getHexSize() / 2;
            }
            point2.x += this.getHexSize() - 1;
            point2.y += this.getHexSize() - 1;
            point.y += this.getHexSize() / 5;
            point2.y -= this.getHexSize() / 5;
            this.constrainRectangle(point, point2);
            return new Rectangle(point.x, point.y, point2.x - point.x + 1, point2.y - point.y + 1);
        }

        Point getSouthEast(int n) {
            int n2 = this.getCol(n);
            int n3 = this.getRow(n) + Math.abs(n2) % 2;
            return this.coordinatesToPosition(++n2, n3, false);
        }

        Point getSouthWest(int n) {
            int n2 = this.getCol(n);
            int n3 = this.getRow(n) + Math.abs(n2) % 2;
            return this.coordinatesToPosition(--n2, n3, false);
        }
    }

    protected class VerticalHexLayout
    extends VerticalLayout {
        VerticalHexLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        Dimension getBoardSize() {
            Dimension dimension = new Dimension();
            dimension.width = this.getDeltaX() * this.nColumns + this.getHexSize() / 5 + 1;
            dimension.height = this.getDeltaY() * this.nRows + this.getHexSize() / 2 + 1;
            return dimension;
        }

        int getDeltaX() {
            return this.getHexSize() * 4 / 5 - (MapBoard.this.isPreV208Layout() ? 1 : 0);
        }

        int getDeltaY() {
            return this.getHexSize() - (MapBoard.this.isPreV208Layout() ? 2 : 1);
        }

        Point getOrigin() {
            return new Point(this.getHexSize() / 2, this.getHexSize() / 2 - (MapBoard.this.isPreV208Layout() ? 1 : 0));
        }

        HexGrid getGeometricGrid() {
            HexGrid hexGrid = new HexGrid();
            hexGrid.setOrigin(this.getOrigin());
            hexGrid.setDx(this.getDeltaX());
            hexGrid.setDy(this.getDeltaY());
            return hexGrid;
        }
    }

    protected class GridOffsetColumnLayout
    extends VerticalLayout {
        GridOffsetColumnLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        Dimension getBoardSize() {
            Dimension dimension = new Dimension();
            dimension.width = this.getDeltaX() * this.nColumns + 1;
            dimension.height = this.getDeltaY() * this.nRows + this.getHexSize() / 2 + 1;
            return dimension;
        }

        int getDeltaX() {
            return this.getHexSize();
        }

        int getDeltaY() {
            return this.getHexSize();
        }

        Point getOrigin() {
            return new Point(this.getHexSize() * 7 / 12, this.getHexSize() / 2);
        }

        AbstractConfigurable getGeometricGrid() {
            HexGrid hexGrid = new HexGrid();
            hexGrid.setOrigin(this.getOrigin());
            hexGrid.setDx(this.getDeltaX());
            hexGrid.setDy(this.getDeltaY());
            return hexGrid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PlaceNameOrientation {
        CENTER_LEFT,
        CENTER_RIGHT,
        HEX_CENTER,
        LOWER_CENTER,
        LOWER_LEFT,
        LOWER_RIGHT,
        UPPER_CENTER,
        UPPER_LEFT,
        UPPER_RIGHT;

    }

    protected class PlaceName
    extends MapDrawable {
        private final Color color;
        private final int font;
        private final PlaceNameOrientation orientation;
        private final int size;
        private final String text;

        PlaceName(int n, String string, Color color, PlaceNameOrientation placeNameOrientation, int n2, int n3) {
            super(n);
            this.text = string;
            assert (color != null);
            this.color = color;
            assert (placeNameOrientation != null);
            this.orientation = placeNameOrientation;
            this.size = n2;
            int n4 = (n3 &= 0x7F) & 0xF;
            if (n4 < 1 || n4 > 9) {
                n4 = 9;
                n3 = n3 & 0xF0 | n4;
            }
            this.font = n3;
        }

        Font getFont() {
            int n = this.getSize();
            return n == 0 ? null : MapBoard.getDefaultFont(this.getSize(), this.font);
        }

        Point getPosition(Graphics2D graphics2D) {
            Point point = this.getPosition();
            if (this.getSize() == 0) {
                return point;
            }
            assert (graphics2D.getFont() == this.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = MapBoard.this.getLayout().getHexSize();
            switch (this.orientation) {
                case LOWER_CENTER: 
                case UPPER_CENTER: 
                case LOWER_RIGHT: 
                case UPPER_RIGHT: 
                case UPPER_LEFT: 
                case LOWER_LEFT: 
                case HEX_CENTER: {
                    point.x += n / 2;
                    break;
                }
                case CENTER_RIGHT: {
                    point.x += n;
                    break;
                }
            }
            switch (this.orientation) {
                case LOWER_CENTER: 
                case UPPER_CENTER: 
                case HEX_CENTER: {
                    point.x -= fontMetrics.charsWidth(this.text.toCharArray(), 0, this.text.length()) / 2;
                    break;
                }
                case UPPER_LEFT: 
                case LOWER_LEFT: 
                case CENTER_LEFT: {
                    point.x -= fontMetrics.charsWidth(this.text.toCharArray(), 0, this.text.length());
                    break;
                }
            }
            switch (this.orientation) {
                case LOWER_CENTER: 
                case LOWER_RIGHT: 
                case LOWER_LEFT: {
                    point.y += n + fontMetrics.getAscent();
                    break;
                }
                case UPPER_CENTER: 
                case UPPER_RIGHT: 
                case UPPER_LEFT: {
                    point.y -= fontMetrics.getDescent();
                    break;
                }
                case HEX_CENTER: 
                case CENTER_RIGHT: 
                case CENTER_LEFT: {
                    point.y += n / 2 + fontMetrics.getHeight() / 2 - fontMetrics.getDescent();
                }
            }
            return point;
        }

        int getSize() {
            return this.size <= 5 ? 0 : (this.size + 1) * 4 / 3 - 1;
        }

        boolean draw(Graphics2D graphics2D) {
            if (this.getSize() != 0) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setFont(this.getFont());
                graphics2D.setColor(this.color);
                Point point = this.getPosition(graphics2D);
                graphics2D.drawString(this.text, point.x, point.y);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                return true;
            }
            return false;
        }

        String getText() {
            return this.text;
        }
    }

    protected class MapSheet {
        private int topLeftCol;
        private int topLeftRow;
        private final Rectangle field;
        private final String name;
        private final int nColChars;
        private final int nRowChars;
        private final int style;
        private Zone zone;

        MapSheet(String string, Rectangle rectangle, int n, int n2, int n3) {
            this.name = string;
            this.field = rectangle;
            this.style = n;
            this.nColChars = n2;
            this.nRowChars = n3;
        }

        Rectangle getField() {
            return this.field;
        }

        String getName() {
            return this.name;
        }

        int getNColChars() {
            return this.nColChars;
        }

        int getNRowChars() {
            return this.nRowChars;
        }

        String getRectangleAsString() {
            Rectangle rectangle = MapBoard.this.getLayout().getRectangle(this);
            if (rectangle == null) {
                return null;
            }
            return rectangle.x + "," + rectangle.y + ";" + (rectangle.x + rectangle.width - 1) + "," + rectangle.y + ";" + (rectangle.x + rectangle.width - 1) + "," + (rectangle.y + rectangle.height - 1) + ";" + rectangle.x + "," + (rectangle.y + rectangle.height - 1);
        }

        boolean alphaCols() {
            return !this.numericCols();
        }

        boolean alphaRows() {
            return !this.numericRows();
        }

        boolean colsAndRows() {
            return (this.style & 2) > 0;
        }

        boolean colsIncreaseLeft() {
            return !this.colsIncreaseRight();
        }

        boolean colsIncreaseRight() {
            return (this.style & 0x10) > 0;
        }

        boolean firstHexDown() {
            return (this.style & 0x40) > 0 && MapBoard.this.getLayout() instanceof VerticalLayout;
        }

        boolean firstHexLeft() {
            return (this.style & 0x40) > 0 && MapBoard.this.getLayout() instanceof HorizontalLayout;
        }

        boolean firstHexRight() {
            return (this.style & 0x40) == 0 && MapBoard.this.getLayout() instanceof HorizontalLayout;
        }

        boolean firstHexUp() {
            return (this.style & 0x40) == 0 && MapBoard.this.getLayout() instanceof VerticalLayout;
        }

        RegularGridNumbering getGridNumbering() {
            RegularGridNumbering regularGridNumbering = MapBoard.this.getLayout().getGridNumbering();
            MapBoard.this.getLayout().initGridNumbering(regularGridNumbering, this);
            return regularGridNumbering;
        }

        Zone getZone() {
            if (this.zone == null) {
                this.zone = new Zone();
                this.zone.setConfigureName(this.getName());
                String string = this.getRectangleAsString();
                if (string == null) {
                    return null;
                }
                this.zone.setAttribute("path", string);
                this.zone.setAttribute("locationFormat", "$name$ $gridLocation$");
                AbstractConfigurable abstractConfigurable = MapBoard.this.getLayout().getGeometricGrid();
                RegularGridNumbering regularGridNumbering = this.getGridNumbering();
                MapBoard.insertComponent(regularGridNumbering, abstractConfigurable);
                MapBoard.insertComponent(abstractConfigurable, this.zone);
                MapBoard.this.getLayout().setGridNumberingOffsets(regularGridNumbering, this);
            }
            return this.zone;
        }

        boolean numericCols() {
            return (this.style & 4) > 0;
        }

        boolean numericRows() {
            return (this.style & 8) > 0;
        }

        boolean rowsAndCols() {
            return !this.colsAndRows();
        }

        boolean rowsIncreaseDown() {
            return (this.style & 0x20) > 0;
        }

        boolean rowsIncreaseUp() {
            return !this.rowsIncreaseDown();
        }

        int getTopLeftCol() {
            return this.topLeftCol;
        }

        void setTopLeftCol(int n) {
            this.topLeftCol = n;
        }

        int getTopLeftRow() {
            return this.topLeftRow;
        }

        void setTopLeftRow(int n) {
            this.topLeftRow = n;
        }
    }

    protected abstract class MapDrawable {
        protected final int hexIndex;

        MapDrawable(int n) {
            this.hexIndex = n;
        }

        abstract boolean draw(Graphics2D var1);

        int getHexIndex() {
            return this.hexIndex;
        }

        Point getPosition() {
            return MapBoard.this.indexToPosition(this.hexIndex);
        }

        Rectangle getRectangle() {
            int n;
            Rectangle rectangle = new Rectangle(this.getPosition());
            rectangle.width = n = MapBoard.this.getLayout().getHexSize();
            rectangle.height = n;
            return rectangle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LineStyle {
        DASH_DOT(new float[]{12.0f, 8.0f, 4.0f, 8.0f}),
        DASH_DOT_DOT(new float[]{12.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f}),
        DASHED(new float[]{12.0f, 8.0f}),
        DOTTED(new float[]{4.0f, 4.0f}),
        SOLID(null);

        private float[] dash;

        private LineStyle(float[] fArray) {
            this.dash = fArray;
        }

        BasicStroke getStroke(int n, int n2) {
            if (this.dash == null) {
                return new BasicStroke(n, n2, 1);
            }
            return new BasicStroke(n, 0, 1, 0.0f, this.dash, 0.0f);
        }
    }

    protected static class LineDefinition {
        private final Color color;
        private int hexLineDrawPriority;
        private int hexSideDrawPriority;
        private ArrayList<ArrayList<Point2D.Float>> points = new ArrayList();
        private final int size;
        private final LineStyle style;

        LineDefinition(Color color, int n, LineStyle lineStyle) {
            this.color = color;
            this.size = n;
            this.style = lineStyle;
        }

        private void setHexLineDrawPriority(int n) {
            if (this.hexLineDrawPriority == 0) {
                this.hexLineDrawPriority = n;
            }
        }

        private void setHexSideDrawPriority(int n) {
            if (this.hexSideDrawPriority == 0) {
                this.hexSideDrawPriority = n;
            }
        }

        Color getColor() {
            return this.color;
        }

        BasicStroke getStroke(int n) {
            if (this.size <= 0 || this.style == null) {
                return null;
            }
            return this.style.getStroke(this.size, n);
        }

        void addLine(float f, float f2, float f3, float f4) {
            this.addLine(new Point2D.Float(f, f2), new Point2D.Float(f3, f4));
        }

        void addLine(int n, int n2, float f, float f2) {
            this.addLine(new Point2D.Float(n, n2), new Point2D.Float(f, f2));
        }

        void addLine(int n, int n2, int n3, int n4) {
            this.addLine(new Point2D.Float(n, n2), new Point2D.Float(n3, n4));
        }

        void addLine(Point2D.Float float_, Point2D.Float float_2) {
            for (int i = 0; i < this.points.size(); ++i) {
                int n;
                ArrayList<Point2D.Float> arrayList = this.points.get(i);
                if (float_.equals(arrayList.get(0))) {
                    if (float_2.equals(arrayList.get(1))) {
                        return;
                    }
                    for (n = 0; n < this.points.size(); ++n) {
                        if (i == n) continue;
                        ArrayList<Point2D.Float> arrayList2 = this.points.get(n);
                        if (float_2.equals(arrayList2.get(0))) {
                            if (arrayList.size() < arrayList2.size()) {
                                for (int j = 0; j < arrayList.size(); ++j) {
                                    arrayList2.add(0, arrayList.get(j));
                                }
                                this.points.remove(i);
                            } else {
                                for (int j = 0; j < arrayList2.size(); ++j) {
                                    arrayList.add(0, arrayList2.get(j));
                                }
                                this.points.remove(n);
                            }
                            return;
                        }
                        if (!float_2.equals(arrayList2.get(arrayList2.size() - 1))) continue;
                        arrayList2.addAll(arrayList);
                        this.points.remove(i);
                        return;
                    }
                    arrayList.add(0, float_2);
                    return;
                }
                if (float_.equals(arrayList.get(arrayList.size() - 1))) {
                    if (float_2.equals(arrayList.get(arrayList.size() - 2))) {
                        return;
                    }
                    for (n = 0; n < this.points.size(); ++n) {
                        if (i == n) continue;
                        ArrayList<Point2D.Float> arrayList3 = this.points.get(n);
                        if (float_2.equals(arrayList3.get(0))) {
                            arrayList.addAll(arrayList3);
                            this.points.remove(n);
                            return;
                        }
                        if (!float_2.equals(arrayList3.get(arrayList3.size() - 1))) continue;
                        if (arrayList.size() < arrayList3.size()) {
                            for (int j = arrayList.size() - 1; j >= 0; --j) {
                                arrayList3.add(arrayList.get(j));
                            }
                            this.points.remove(i);
                        } else {
                            for (int j = arrayList3.size() - 1; j >= 0; --j) {
                                arrayList.add(arrayList3.get(j));
                            }
                            this.points.remove(n);
                        }
                        return;
                    }
                    arrayList.add(float_2);
                    return;
                }
                for (n = 1; n < arrayList.size() - 1; ++n) {
                    if (!float_.equals(arrayList.get(n)) || !float_2.equals(arrayList.get(n - 1)) && !float_2.equals(arrayList.get(n + 1))) continue;
                    return;
                }
            }
            for (ArrayList<Point2D.Float> arrayList : this.points) {
                if (float_2.equals(arrayList.get(0))) {
                    if (float_.equals(arrayList.get(1))) {
                        return;
                    }
                    arrayList.add(0, float_);
                    return;
                }
                if (!float_2.equals(arrayList.get(arrayList.size() - 1))) continue;
                if (float_.equals(arrayList.get(arrayList.size() - 2))) {
                    return;
                }
                arrayList.add(float_);
                return;
            }
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(float_);
            arrayList.add(float_2);
            this.points.add(arrayList);
        }

        void clearPoints() {
            this.points.clear();
        }

        void draw(Graphics2D graphics2D, int n) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke basicStroke = this.getStroke(n);
            if (basicStroke == null) {
                return;
            }
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.getColor());
            GeneralPath generalPath = new GeneralPath(0);
            for (ArrayList<Point2D.Float> arrayList : this.points) {
                generalPath.moveTo(arrayList.get((int)0).x, arrayList.get((int)0).y);
                for (Point2D.Float float_ : arrayList) {
                    if (!float_.equals(arrayList.get(0))) {
                        generalPath.lineTo(float_.x, float_.y);
                        continue;
                    }
                    if (float_ == arrayList.get(0)) continue;
                    generalPath.closePath();
                }
            }
            graphics2D.draw(generalPath);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        int getHexLineDrawPriority() {
            return this.hexLineDrawPriority;
        }

        int getHexSideDrawPriority() {
            return this.hexSideDrawPriority;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Line
    extends MapDrawable {
        private final int line;

        Line(int n, int n2) {
            super(n);
            this.line = n2;
            if (MapBoard.this.hexes == null) {
                MapBoard.access$1502(MapBoard.this, new Hex[MapBoard.this.getNColumns() * MapBoard.this.getNRows()]);
            }
            if (MapBoard.this.hexes[n] == null) {
                ((MapBoard)MapBoard.this).hexes[n] = new Hex();
            }
            this.getLineList(MapBoard.this.hexes[n]).add(this);
        }

        LineDefinition getLine() {
            return MapBoard.this.getLineDefinition(this.line);
        }

        abstract ArrayList<Line> getLineList(Hex var1);

        int compare(LineDefinition lineDefinition, LineDefinition lineDefinition2) {
            if (lineDefinition == null && lineDefinition2 == null) {
                return 0;
            }
            if (lineDefinition == null) {
                return 1;
            }
            if (lineDefinition2 == null) {
                return -1;
            }
            for (Hex hex : MapBoard.this.hexes) {
                if (hex == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                for (Line line : this.getLineList(hex)) {
                    if (line.getLine() == lineDefinition) {
                        if (bl2) {
                            return 1;
                        }
                        bl = true;
                        continue;
                    }
                    if (line.getLine() != lineDefinition2) continue;
                    if (bl) {
                        return -1;
                    }
                    bl2 = true;
                }
            }
            return 0;
        }

        void drawLines(Graphics2D graphics2D, int n) {
            ArrayList<LineDefinition> arrayList = new ArrayList<LineDefinition>(Arrays.asList(MapBoard.this.lineDefinitions));
            while (arrayList.size() > 0) {
                LineDefinition lineDefinition = null;
                for (LineDefinition lineDefinition2 : arrayList) {
                    if (lineDefinition2 == null || lineDefinition != null && this.compare(lineDefinition2, lineDefinition) >= 0) continue;
                    lineDefinition = lineDefinition2;
                }
                if (lineDefinition == null) break;
                lineDefinition.draw(graphics2D, n);
                lineDefinition.clearPoints();
                arrayList.remove(lineDefinition);
            }
        }
    }

    protected abstract class HorizontalLayout
    extends Layout {
        HorizontalLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        int getNFaces() {
            return 6;
        }

        void setGridNumberingOffsets(RegularGridNumbering regularGridNumbering, MapSheet mapSheet) {
            Point point = this.coordinatesToPosition(mapSheet.getField().x, mapSheet.getField().y, true);
            point.translate(this.getDeltaX() / 2, this.getDeltaY() / 2);
            int n = regularGridNumbering.getColumn(point);
            int n2 = regularGridNumbering.getRow(point);
            n = -n + mapSheet.getTopLeftRow();
            n2 = -n2 + mapSheet.getTopLeftCol();
            regularGridNumbering.setAttribute("hOff", n);
            regularGridNumbering.setAttribute("vOff", n2);
        }

        void initGridNumbering(RegularGridNumbering regularGridNumbering, MapSheet mapSheet) {
            super.initGridNumbering(regularGridNumbering, mapSheet);
            boolean bl = false;
            if (mapSheet.firstHexRight() && (mapSheet.getField().y & 1) == 1) {
                bl = true;
            } else if (mapSheet.firstHexLeft() && mapSheet.getField().y % 2 == 0) {
                bl = true;
            }
            regularGridNumbering.setAttribute("stagger", bl);
            regularGridNumbering.setAttribute("first", mapSheet.rowsAndCols() ? "H" : "V");
            regularGridNumbering.setAttribute("hType", mapSheet.numericRows() ? "N" : "A");
            regularGridNumbering.setAttribute("vType", mapSheet.numericCols() ? "N" : "A");
            regularGridNumbering.setAttribute("hLeading", mapSheet.getNRowChars() - 1);
            regularGridNumbering.setAttribute("vLeading", mapSheet.getNColChars() - 1);
        }

        HexGridNumbering getGridNumbering() {
            return new HexGridNumbering();
        }

        Point coordinatesToPosition(int n, int n2, boolean bl) {
            if (!bl || MapBoard.this.isOnMapBoard(n, n2)) {
                int n3 = this.getDeltaX() * n + n2 % 2 * this.getDeltaX() / 2;
                int n4 = this.getDeltaY() * n2;
                return new Point(n3, n4);
            }
            return null;
        }

        Point getNorthEast(int n) {
            int n2 = this.getRow(n);
            int n3 = this.getCol(n) + Math.abs(n2) % 2;
            return this.coordinatesToPosition(n3, --n2, false);
        }

        Point getNorthWest(int n) {
            int n2 = this.getRow(n) - 1;
            int n3 = this.getCol(n) - Math.abs(n2) % 2;
            return this.coordinatesToPosition(n3, n2, false);
        }

        Rectangle getRectangle(MapSheet mapSheet) {
            Rectangle rectangle = mapSheet.getField();
            Point point = this.coordinatesToPosition(rectangle.x, rectangle.y, false);
            Point point2 = this.coordinatesToPosition(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, false);
            if (mapSheet.firstHexLeft()) {
                point.x -= this.getHexSize() / 2;
            }
            if (rectangle.y % 2 == (rectangle.y + rectangle.height - 1) % 2) {
                if (mapSheet.firstHexRight()) {
                    point2.x += this.getHexSize() / 2;
                }
            } else if ((rectangle.y & 1) == 1) {
                point2.x = mapSheet.firstHexLeft() ? (point2.x += this.getHexSize() / 2) : (point2.x += this.getHexSize());
            } else if (mapSheet.firstHexLeft() && rectangle.y % 2 == 0) {
                point2.x -= this.getHexSize() / 2;
            }
            point2.x += this.getHexSize() - 1;
            point2.y += this.getHexSize() - 1;
            point.x += this.getHexSize() / 5;
            point2.x -= this.getHexSize() / 5;
            this.constrainRectangle(point, point2);
            return new Rectangle(point.x, point.y, point2.x - point.x + 1, point2.y - point.y + 1);
        }

        Point getSouthEast(int n) {
            int n2 = this.getRow(n);
            int n3 = this.getCol(n) + Math.abs(n2) % 2;
            return this.coordinatesToPosition(n3, ++n2, false);
        }

        Point getSouthWest(int n) {
            int n2 = this.getRow(n) + 1;
            int n3 = this.getCol(n) - Math.abs(n2) % 2;
            return this.coordinatesToPosition(n3, n2, false);
        }
    }

    protected class GridOffsetRowLayout
    extends HorizontalLayout {
        GridOffsetRowLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        Dimension getBoardSize() {
            Dimension dimension = new Dimension();
            dimension.height = this.getDeltaY() * this.nRows + 1;
            dimension.width = this.getDeltaX() * this.nColumns + this.getHexSize() / 2 + 1;
            return dimension;
        }

        int getDeltaX() {
            return this.getHexSize();
        }

        int getDeltaY() {
            return this.getHexSize();
        }

        Point getOrigin() {
            return new Point(this.getHexSize() * 7 / 12, this.getHexSize() / 2);
        }

        AbstractConfigurable getGeometricGrid() {
            HexGrid hexGrid = new HexGrid();
            hexGrid.setSideways(true);
            hexGrid.setOrigin(this.getOrigin());
            hexGrid.setDx(this.getDeltaY());
            hexGrid.setDy(this.getDeltaX());
            return hexGrid;
        }
    }

    protected class HorizontalHexLayout
    extends HorizontalLayout {
        HorizontalHexLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        Dimension getBoardSize() {
            Dimension dimension = new Dimension();
            dimension.width = this.getDeltaX() * this.nColumns + this.getHexSize() / 2;
            dimension.height = this.getDeltaY() * this.nRows + this.getHexSize() / 5 + 1;
            return dimension;
        }

        int getDeltaX() {
            return this.getHexSize() - (MapBoard.this.isPreV208Layout() ? 2 : 0);
        }

        int getDeltaY() {
            return this.getHexSize() * 4 / 5 - 1;
        }

        Point getOrigin() {
            return new Point(this.getHexSize() / 2, this.getHexSize() / 2 - (MapBoard.this.isPreV208Layout() ? 1 : 0));
        }

        HexGrid getGeometricGrid() {
            HexGrid hexGrid = new HexGrid();
            hexGrid.setSideways(true);
            hexGrid.setOrigin(this.getOrigin());
            hexGrid.setDy(this.getDeltaX());
            hexGrid.setDx(this.getDeltaY());
            return hexGrid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HexSide
    extends Line {
        private final int side;

        HexSide(int n, int n2, int n3) {
            super(n, n2);
            this.side = n3;
        }

        @Override
        int compare(LineDefinition lineDefinition, LineDefinition lineDefinition2) {
            if (lineDefinition == null && lineDefinition2 == null) {
                return 0;
            }
            if (lineDefinition == null) {
                return 1;
            }
            if (lineDefinition2 == null) {
                return -1;
            }
            int n = lineDefinition.getHexSideDrawPriority() - lineDefinition2.getHexSideDrawPriority();
            if (n != 0) {
                return n;
            }
            return super.compare(lineDefinition, lineDefinition2);
        }

        @Override
        boolean draw(Graphics2D graphics2D) {
            LineDefinition lineDefinition = this.getLine();
            boolean bl = false;
            if (lineDefinition != null) {
                Point point;
                bl = true;
                Point point2 = this.getPosition();
                int n = MapBoard.this.getLayout().getHexSize();
                int n2 = MapBoard.this.getLayout().getDeltaX();
                int n3 = MapBoard.this.getLayout().getDeltaY();
                if ((this.side & 1) > 0) {
                    point = MapBoard.this.getLayout().getSouthWest(this.hexIndex);
                    point.translate(n2, 0);
                    Point point3 = MapBoard.this.getLayout().getSouth(this.hexIndex);
                    lineDefinition.addLine(point2.x, point.y, point2.x + n / 5, point3.y);
                }
                if ((this.side & 2) > 0) {
                    point = MapBoard.this.getLayout().getSouthWest(this.hexIndex);
                    point.translate(n2, 0);
                    lineDefinition.addLine(point2.x, point.y, point2.x + n / 5, point2.y);
                }
                if ((this.side & 4) > 0) {
                    lineDefinition.addLine(point2.x + n / 5, point2.y, point2.x + n2, point2.y);
                }
                if ((this.side & 8) > 0) {
                    point = MapBoard.this.getLayout().getSouthEast(this.hexIndex);
                    lineDefinition.addLine(point2.x, point2.y + n3, point.x, point2.y + n3 + n / 5);
                }
                if ((this.side & 0x10) > 0) {
                    lineDefinition.addLine(point2.x, point2.y + n / 5, point2.x, point2.y + n3);
                }
                if ((this.side & 0x20) > 0) {
                    point = MapBoard.this.getLayout().getNorthEast(this.hexIndex);
                    lineDefinition.addLine(point2.x, point2.y + n / 5, point.x, point2.y);
                }
                if ((this.side & 0x40) > 0) {
                    lineDefinition.addLine(point2.x, point2.y, point2.x, point2.y + n3);
                }
                if ((this.side & 0x80) > 0) {
                    lineDefinition.addLine(point2.x, point2.y, point2.x + n2, point2.y);
                }
            }
            if (this == MapBoard.this.hexSides.get(MapBoard.this.hexSides.size() - 1)) {
                this.drawLines(graphics2D, 1);
            }
            return bl;
        }

        @Override
        ArrayList<Line> getLineList(Hex hex) {
            return hex.hexSides;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HexLine
    extends Line {
        private final int direction;

        HexLine(int n, int n2, int n3) {
            super(n, n2);
            this.direction = n3;
        }

        @Override
        int compare(LineDefinition lineDefinition, LineDefinition lineDefinition2) {
            if (lineDefinition == null && lineDefinition2 == null) {
                return 0;
            }
            if (lineDefinition == null) {
                return 1;
            }
            if (lineDefinition2 == null) {
                return -1;
            }
            int n = lineDefinition.getHexLineDrawPriority() - lineDefinition2.getHexLineDrawPriority();
            if (n != 0) {
                return n;
            }
            return super.compare(lineDefinition, lineDefinition2);
        }

        @Override
        boolean draw(Graphics2D graphics2D) {
            LineDefinition lineDefinition = this.getLine();
            boolean bl = false;
            if (lineDefinition != null) {
                Point point;
                bl = true;
                Point point2 = this.getPosition();
                int n = MapBoard.this.getLayout().getHexSize();
                point2.translate(n / 2, n / 2);
                Layout layout = MapBoard.this.getLayout();
                if ((this.direction & 6) > 0) {
                    point = layout.getNorthWest(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 8) > 0) {
                    point = layout.getWest(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 0x30) > 0) {
                    point = layout.getSouthWest(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 0x80) > 0) {
                    point = layout.getSouth(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 0x100) > 0) {
                    point = layout.getNorth(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 0xC00) > 0) {
                    point = layout.getNorthEast(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 0x1000) > 0) {
                    point = layout.getEast(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
                if ((this.direction & 0x6000) > 0) {
                    point = layout.getSouthEast(this.hexIndex);
                    point.translate(n / 2, n / 2);
                    lineDefinition.addLine(point2.x, point2.y, (float)(point2.x + point.x) / 2.0f, (float)(point2.y + point.y) / 2.0f);
                }
            }
            if (this == MapBoard.this.hexLines.get(MapBoard.this.hexLines.size() - 1)) {
                this.drawLines(graphics2D, 0);
            }
            return bl;
        }

        @Override
        ArrayList<Line> getLineList(Hex hex) {
            return hex.hexLines;
        }
    }

    protected class MapBoardOverlay
    extends HexData {
        boolean draw(Graphics2D graphics2D) {
            if (this.symbol != null) {
                for (int i = 0; i < MapBoard.this.getNRows(); ++i) {
                    for (int j = 0; j < MapBoard.this.getNColumns(); ++j) {
                        Point point = MapBoard.this.coordinatesToPosition(j, i);
                        graphics2D.drawImage(this.symbol.getImage(), null, point.x, point.y);
                    }
                }
                return true;
            }
            return false;
        }

        MapBoardOverlay(SymbolSet.SymbolData symbolData) {
            super(-1, symbolData);
        }
    }

    protected class HexData
    extends MapDrawable {
        final SymbolSet.SymbolData symbol;

        HexData(int n, SymbolSet.SymbolData symbolData) {
            super(n);
            assert (symbolData != null);
            this.symbol = symbolData;
        }

        boolean draw(Graphics2D graphics2D) {
            Point point = this.getPosition();
            if (this.symbol != null && !this.symbol.isTransparent()) {
                graphics2D.drawImage(this.symbol.getImage(), null, point.x, point.y);
                return true;
            }
            return false;
        }
    }

    private static class Hex {
        ArrayList<Line> hexLines = new ArrayList();
        ArrayList<Line> hexSides = new ArrayList();

        private Hex() {
        }
    }

    protected class GridLayout
    extends Layout {
        GridLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        Point coordinatesToPosition(int n, int n2, boolean bl) {
            if (!bl || MapBoard.this.isOnMapBoard(n, n2)) {
                int n3 = this.getDeltaX() * n;
                int n4 = this.getDeltaY() * n2;
                return new Point(n3, n4);
            }
            return null;
        }

        Dimension getBoardSize() {
            Dimension dimension = new Dimension();
            dimension.width = this.getDeltaX() * this.nColumns;
            dimension.height = this.getDeltaY() * this.nRows;
            return dimension;
        }

        int getDeltaX() {
            return this.getHexSize();
        }

        int getDeltaY() {
            return this.getHexSize();
        }

        Point getOrigin() {
            return new Point(this.getHexSize() / 2, this.getHexSize() / 2);
        }

        SquareGrid getGeometricGrid() {
            SquareGrid squareGrid = new SquareGrid();
            squareGrid.setOrigin(this.getOrigin());
            squareGrid.setDx(this.getDeltaX());
            squareGrid.setDy(this.getDeltaY());
            return squareGrid;
        }

        Rectangle getRectangle(MapSheet mapSheet) {
            Rectangle rectangle = mapSheet.getField();
            Point point = this.coordinatesToPosition(rectangle.x, rectangle.y, false);
            Point point2 = this.coordinatesToPosition(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, false);
            point2.x += this.getHexSize() - 1;
            point2.y += this.getHexSize() - 1;
            this.constrainRectangle(point, point2);
            return new Rectangle(point.x, point.y, point2.x - point.x + 1, point2.y - point.y + 1);
        }

        RegularGridNumbering getGridNumbering() {
            return new SquareGridNumbering();
        }

        int getNFaces() {
            return 4;
        }
    }

    class BaseLayer
    extends MapLayer {
        BaseLayer() {
            super(null, "Base Layer", false);
        }

        boolean hasBaseMap() {
            File file = MapBoard.this.action.getCaseInsensitiveFile(new File(Importer.forceExtension(MapBoard.this.path, "sml")), null, false, null);
            if (file == null) {
                file = MapBoard.this.action.getCaseInsensitiveFile(new File(Importer.stripExtension(MapBoard.this.path) + "-Z" + 3 + ".bmp"), null, false, null);
            }
            return file != null;
        }

        boolean draw(Graphics2D graphics2D) {
            graphics2D.setBackground(MapBoard.this.tableColor);
            Dimension dimension = MapBoard.this.getLayout().getBoardSize();
            graphics2D.clearRect(0, 0, dimension.width, dimension.height);
            File file = MapBoard.this.action.getCaseInsensitiveFile(new File(Importer.forceExtension(MapBoard.this.path, "sml")), null, false, null);
            if (file != null) {
                try {
                    MapBoard.this.readScannedMapLayoutFile(file, graphics2D);
                }
                catch (IOException iOException) {}
            } else if (MapBoard.this.getSet().underlay != null) {
                graphics2D.drawImage(MapBoard.this.getSet().underlay, null, 0, 0);
            }
            return true;
        }

        void writeToArchive() throws IOException {
            this.writeImageToArchive();
            assert (this.imageName != null);
            Board board = MapBoard.this.getBoard();
            board.setAttribute("image", this.imageName);
            board.setConfigureName(MapBoard.this.baseName);
            MapBoard.this.getMainMap().setBoards(Collections.singleton(board));
        }

        protected Rectangle getCropRectangle(BufferedImage bufferedImage) {
            return new Rectangle(MapBoard.this.getLayout().getBoardSize());
        }

        protected AlphaComposite getComposite() {
            return AlphaComposite.SrcOver;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapLayer {
        private final ArrayList<? extends MapDrawable> elements;
        private final String name;
        private final boolean switchable;
        protected ArrayList<MapLayer> layers = null;
        protected String imageName;
        boolean shouldDraw = true;

        MapLayer(ArrayList<? extends MapDrawable> arrayList, String string, boolean bl) {
            this.elements = arrayList;
            this.name = string;
            this.switchable = bl;
        }

        void writeToArchive() throws IOException {
            Rectangle rectangle = this.writeImageToArchive();
            if (this.imageName != null && rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
                SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
                sequenceEncoder.append("").append("").append(this.imageName).append(this.getName());
                EditablePiece editablePiece = new BasicPiece("piece;" + sequenceEncoder.getValue());
                editablePiece = new Marker("mark;Layer", editablePiece);
                editablePiece.setProperty("Layer", this.getName());
                editablePiece = new Marker("mark;Type", editablePiece);
                editablePiece.setProperty("Type", "Layer");
                editablePiece = new Immobilized(editablePiece, "immob;n;V");
                LayeredPieceCollection layeredPieceCollection = MapBoard.this.getLayeredPieceCollection();
                String string = layeredPieceCollection.getAttributeValueString("layerOrder");
                string = string.equals("") ? this.getName() : string + "," + this.getName();
                layeredPieceCollection.setAttribute("layerOrder", string);
                Map map = MapBoard.this.getMainMap();
                Board board = MapBoard.this.getBoard();
                SetupStack setupStack = new SetupStack();
                MapBoard.insertComponent(setupStack, map);
                Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                setupStack.setAttribute("name", this.getName());
                setupStack.setAttribute("owningBoard", board.getConfigureName());
                setupStack.setAttribute("x", Integer.toString(point.x));
                setupStack.setAttribute("y", Integer.toString(point.y));
                PieceSlot pieceSlot = new PieceSlot(editablePiece);
                MapBoard.insertComponent(pieceSlot, setupStack);
                if (this.isSwitchable()) {
                    LayerControl layerControl = new LayerControl();
                    MapBoard.insertComponent(layerControl, layeredPieceCollection);
                    layerControl.setAttribute("text", this.getName());
                    layerControl.setAttribute("tooltip", "Toggle " + this.getName().toLowerCase() + " visibility");
                    layerControl.setAttribute("command", "Switch Layer between Active and Inactive");
                    layerControl.setAttribute("layers", this.getName());
                    ToolbarMenu toolbarMenu = MapBoard.this.getToolbarMenu();
                    String string2 = toolbarMenu.getAttributeValueString("menuItems");
                    string2 = string2.equals("") ? this.getName() : string2 + "," + new SequenceEncoder(this.getName(), ',').getValue();
                    toolbarMenu.setAttribute("menuItems", string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Rectangle writeImageToArchive() throws IOException {
            BufferedImage bufferedImage = this.getLayerImage();
            if (bufferedImage == null) {
                return null;
            }
            Rectangle rectangle = this.getCropRectangle(bufferedImage);
            if (rectangle.width == 0 || rectangle.height == 0) {
                return null;
            }
            File file = File.createTempFile("map", ".png", Info.getTempDir());
            try {
                ImageIO.write((RenderedImage)bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height), "png", file);
                this.imageName = Importer.getUniqueImageFileName(this.getName(), ".png");
                GameModule.getGameModule().getArchiveWriter().addImage(file.getPath(), this.imageName);
                Rectangle rectangle2 = rectangle;
                return rectangle2;
            }
            finally {
                FileUtils.forceDelete((File)file);
            }
        }

        protected Rectangle getCropRectangle(BufferedImage bufferedImage) {
            int n;
            Rectangle rectangle;
            block9: {
                rectangle = new Rectangle(MapBoard.this.getLayout().getBoardSize());
                do {
                    for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
                        if (bufferedImage.getRGB(rectangle.x, n) == 0) {
                            continue;
                        }
                        break block9;
                    }
                    ++rectangle.x;
                    --rectangle.width;
                } while (rectangle.width != 0);
                rectangle.height = 0;
                return rectangle;
            }
            block2: while (true) {
                for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                    if (bufferedImage.getRGB(n, rectangle.y) != 0) break block2;
                }
                ++rectangle.y;
                --rectangle.height;
            }
            block4: while (true) {
                for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
                    if (bufferedImage.getRGB(rectangle.x + rectangle.width - 1, n) != 0) break block4;
                }
                --rectangle.width;
            }
            block6: while (true) {
                for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                    if (bufferedImage.getRGB(n, rectangle.y + rectangle.height - 1) != 0) break block6;
                }
                --rectangle.height;
            }
            return rectangle;
        }

        void overlay(MapLayer mapLayer) {
            if (this.layers == null) {
                this.layers = new ArrayList();
            }
            this.layers.add(mapLayer);
        }

        protected AlphaComposite getComposite() {
            return AlphaComposite.SrcAtop;
        }

        BufferedImage getLayerImage() {
            Dimension dimension = MapBoard.this.getLayout().getBoardSize();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (this.draw(graphics2D)) {
                if (this.layers != null) {
                    graphics2D.setComposite(this.getComposite());
                    for (MapLayer mapLayer : this.layers) {
                        mapLayer.draw(graphics2D);
                    }
                }
            } else {
                bufferedImage = null;
            }
            return bufferedImage;
        }

        boolean draw(Graphics2D graphics2D) {
            if (this.shouldDraw) {
                this.shouldDraw = false;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                for (MapDrawable mapDrawable : this.elements) {
                    if (!mapDrawable.draw(graphics2D)) continue;
                    this.shouldDraw = true;
                }
            }
            return this.shouldDraw;
        }

        boolean isSwitchable() {
            return this.switchable;
        }

        String getName() {
            return this.name;
        }

        boolean hasElements() {
            return !this.elements.isEmpty();
        }
    }
}

