/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.tilecache.TileSlicer;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.lang.Callback;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArchiveImageTiler {
    private static final Logger logger = LoggerFactory.getLogger(FileArchiveImageTiler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FileArchive fileArchive, String string, int n, int n2, String[] stringArray, ExecutorService executorService, ImageLoader imageLoader, TileSlicer tileSlicer, Callback<String> callback, Callback<Void> callback2, Callback<Void> callback3) throws IOException {
        for (String string2 : stringArray) {
            logger.info("Tiling {}", (Object)string2);
            callback.receive(string2);
            BufferedImage bufferedImage = null;
            InputStream inputStream = null;
            try {
                inputStream = fileArchive.getInputStream(string2);
                bufferedImage = imageLoader.load(string2, inputStream, 1, 3, false);
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.error("", (Throwable)iOException);
                continue;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            tileSlicer.slice(bufferedImage, string2, string, n, n2, executorService, callback2);
        }
        executorService.shutdown();
        callback3.receive(null);
    }
}

