/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.PropertyNameExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SetGlobalProperty
extends DynamicProperty {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String ID = "setprop;";
    public static final String CURRENT_ZONE = "Current Zone/Current Map/Module";
    public static final String NAMED_ZONE = "Named Zone";
    public static final String NAMED_MAP = "Named Map";
    protected String description;
    protected String propertyLevel;
    protected String searchName;
    protected Decorator dec;

    public SetGlobalProperty() {
        this(ID, null);
    }

    public SetGlobalProperty(String string, GamePiece gamePiece) {
        super(string, gamePiece);
    }

    public String getDescription() {
        String string = "Set Global Property";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.key = decoder.nextToken("name");
        this.decodeConstraints(decoder.nextToken(""));
        this.keyCommandListConfig.setValue(decoder.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicProperty.DynamicKeyCommand[this.keyCommandListConfig.getListValue().size()]);
        ArrayList<DynamicProperty.DynamicKeyCommand> arrayList = new ArrayList<DynamicProperty.DynamicKeyCommand>();
        for (DynamicProperty.DynamicKeyCommand dynamicKeyCommand : this.keyCommands) {
            if (dynamicKeyCommand.getName() == null || dynamicKeyCommand.getName().length() <= 0) continue;
            arrayList.add(dynamicKeyCommand);
        }
        this.menuCommands = arrayList.toArray(new DynamicProperty.DynamicKeyCommand[arrayList.size()]);
        this.description = decoder.nextToken("");
        this.propertyLevel = decoder.nextToken(CURRENT_ZONE);
        this.searchName = decoder.nextToken("");
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.key);
        sequenceEncoder.append(this.encodeConstraints());
        sequenceEncoder.append(this.keyCommandListConfig.getValueString());
        sequenceEncoder.append(this.description);
        sequenceEncoder.append(this.propertyLevel);
        sequenceEncoder.append(this.searchName);
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        return "";
    }

    public void mySetState(String string) {
    }

    public Object getProperty(Object object) {
        if ("KeyCommands".equals(object)) {
            return this.getKeyCommands();
        }
        if ("Inner".equals(object)) {
            return this.piece;
        }
        if ("Outer".equals(object)) {
            return this.dec;
        }
        if ("visibleState".equals(object)) {
            return this.myGetState() + this.piece.getProperty(object);
        }
        return this.piece.getProperty(object);
    }

    public Object getLocalizedProperty(Object object) {
        if ("KeyCommands".equals(object)) {
            return this.getProperty(object);
        }
        if ("Inner".equals(object)) {
            return this.getProperty(object);
        }
        if ("Outer".equals(object)) {
            return this.getProperty(object);
        }
        if ("visibleState".equals(object)) {
            return this.getProperty(object);
        }
        return this.piece.getLocalizedProperty(object);
    }

    public void setProperty(Object object, Object object2) {
        if ("Inner".equals(object)) {
            this.setInner((GamePiece)object2);
        } else if ("Outer".equals(object)) {
            this.dec = (Decorator)object2;
        } else {
            this.piece.setProperty(object, object2);
        }
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetGlobalProperty.htm");
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        Command command = new NullCommand();
        for (int i = 0; i < this.keyCommands.length; ++i) {
            String string;
            Object object;
            if (!this.keyCommands[i].matches(keyStroke)) continue;
            MutableProperty mutableProperty = null;
            String string2 = new FormattedString(this.key).getText(Decorator.getOutermost(this));
            ArrayList<MutablePropertiesContainer> arrayList = new ArrayList<MutablePropertiesContainer>();
            arrayList.add(0, GameModule.getGameModule());
            Map map = this.getMap();
            if (NAMED_MAP.equals(this.propertyLevel)) {
                object = new FormattedString(this.searchName).getText(Decorator.getOutermost(this));
                map = Map.getMapById((String)object);
            }
            if (map != null) {
                arrayList.add(0, map);
            }
            object = null;
            if (CURRENT_ZONE.equals(this.propertyLevel) && this.getMap() != null) {
                object = this.getMap().findZone(this.getPosition());
            } else if (NAMED_ZONE.equals(this.propertyLevel) && this.getMap() != null) {
                string = new FormattedString(this.searchName).getText(Decorator.getOutermost(this));
                object = this.getMap().findZone(string);
            }
            if (object != null) {
                arrayList.add(0, (MutablePropertiesContainer)object);
            }
            if ((mutableProperty = MutableProperty.Util.findMutableProperty(string2, arrayList)) == null) {
                string = "Set Global Property (" + this.description + "): Unable to locate Global Property named " + string2;
                if (!this.propertyLevel.equals(CURRENT_ZONE)) {
                    string = string + " in " + this.propertyLevel + " " + this.searchName;
                }
                GameModule.getGameModule().warn(string);
                continue;
            }
            string = mutableProperty.getPropertyValue();
            String string3 = this.keyCommands[i].propChanger.getNewValue(string);
            this.format.setFormat(string3);
            string3 = this.format.getText(Decorator.getOutermost(this));
            command = mutableProperty.setPropertyValue(string3);
        }
        return command;
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer descConfig;
        protected PropertyNameExpressionConfigurer nameConfig;
        protected BooleanConfigurer numericConfig;
        protected IntConfigurer minConfig;
        protected IntConfigurer maxConfig;
        protected BooleanConfigurer wrapConfig;
        protected ListConfigurer keyCommandListConfig;
        protected StringEnumConfigurer levelConfig;
        protected FormattedExpressionConfigurer searchNameConfig;
        protected JLabel mapLabel = new JLabel("map");
        protected JLabel zoneLabel = new JLabel("zone");
        protected Box controls;
        protected Box nameBox;

        public Ed(final SetGlobalProperty setGlobalProperty) {
            this.keyCommandListConfig = new ListConfigurer(null, "Key Commands"){

                protected Configurer buildChildConfigurer() {
                    return new DynamicProperty.DynamicKeyCommandConfigurer(setGlobalProperty);
                }
            };
            this.keyCommandListConfig.setValue(new ArrayList<DynamicProperty.DynamicKeyCommand>(Arrays.asList(setGlobalProperty.keyCommands)));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = Ed.this.numericConfig.booleanValue();
                    Ed.this.minConfig.getControls().setVisible(bl);
                    Ed.this.maxConfig.getControls().setVisible(bl);
                    Ed.this.wrapConfig.getControls().setVisible(bl);
                    Ed.this.keyCommandListConfig.repack();
                }
            };
            this.controls = Box.createVerticalBox();
            this.descConfig = new StringConfigurer(null, "Description:  ", setGlobalProperty.description);
            this.controls.add(this.descConfig.getControls());
            this.nameConfig = new PropertyNameExpressionConfigurer(null, "Global Property Name:  ", setGlobalProperty.getKey(), (GamePiece)setGlobalProperty);
            this.controls.add(this.nameConfig.getControls());
            this.levelConfig = new StringEnumConfigurer(null, "", new String[]{SetGlobalProperty.CURRENT_ZONE, SetGlobalProperty.NAMED_ZONE, SetGlobalProperty.NAMED_MAP});
            this.levelConfig.setValue(setGlobalProperty.propertyLevel);
            this.levelConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.updateVisibility();
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Locate Property starting in the:   "));
            box.add(this.levelConfig.getControls());
            this.controls.add(box);
            this.nameBox = Box.createHorizontalBox();
            this.nameBox.add(new JLabel("Name of "));
            this.nameBox.add(this.mapLabel);
            this.nameBox.add(this.zoneLabel);
            this.nameBox.add(new JLabel(" containing property:  "));
            this.searchNameConfig = new FormattedExpressionConfigurer(null, "", setGlobalProperty.searchName, setGlobalProperty);
            this.nameBox.add(this.searchNameConfig.getControls());
            this.controls.add(this.nameBox);
            this.numericConfig = new BooleanConfigurer(null, "Is numeric?", setGlobalProperty.isNumeric());
            this.controls.add(this.numericConfig.getControls());
            this.minConfig = new IntConfigurer(null, "Minimum value:  ", (Integer)setGlobalProperty.getMinimumValue());
            this.controls.add(this.minConfig.getControls());
            this.maxConfig = new IntConfigurer(null, "Maximum value:  ", (Integer)setGlobalProperty.getMaximumValue());
            this.controls.add(this.maxConfig.getControls());
            this.wrapConfig = new BooleanConfigurer(null, "Wrap?", setGlobalProperty.isWrap());
            this.controls.add(this.wrapConfig.getControls());
            this.controls.add(this.keyCommandListConfig.getControls());
            this.numericConfig.addPropertyChangeListener(propertyChangeListener);
            this.numericConfig.fireUpdate();
            this.updateVisibility();
        }

        protected void updateVisibility() {
            this.mapLabel.setVisible(this.levelConfig.getValueString().equals(SetGlobalProperty.NAMED_MAP));
            this.zoneLabel.setVisible(this.levelConfig.getValueString().equals(SetGlobalProperty.NAMED_ZONE));
            this.nameBox.setVisible(!this.levelConfig.getValueString().equals(SetGlobalProperty.CURRENT_ZONE));
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
        }

        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameConfig.getValueString());
            sequenceEncoder.append(this.encodeConstraints());
            sequenceEncoder.append(this.keyCommandListConfig.getValueString());
            sequenceEncoder.append(this.descConfig.getValueString());
            sequenceEncoder.append(this.levelConfig.getValueString());
            sequenceEncoder.append(this.searchNameConfig.getValueString());
            return SetGlobalProperty.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

