/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceVisitor;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class Restricted
extends Decorator
implements EditablePiece {
    public static final String ID = "restrict;";
    private String[] side;
    private boolean restrictByPlayer;
    private String owningPlayer = "";
    private boolean restrictMovement = true;
    private static PlayerRoster.SideChangeListener handleRetirement;

    public Restricted() {
        this(ID, null);
    }

    public Restricted(String string, GamePiece gamePiece) {
        this.setInner(gamePiece);
        this.mySetType(string);
        if (handleRetirement == null) {
            handleRetirement = new RetirementHandler();
            PlayerRoster.addSideChangeListener(handleRetirement);
        }
    }

    public String getDescription() {
        return "Restricted Access";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RestrictedAccess.htm");
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.side = decoder.nextStringArray(0);
        this.restrictByPlayer = decoder.nextBoolean(false);
        this.restrictMovement = decoder.nextBoolean(true);
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public boolean isRestricted() {
        boolean bl = false;
        if (this.restrictByPlayer) {
            boolean bl2 = bl = this.owningPlayer.length() > 0 && !GameModule.getUserId().equals(this.owningPlayer);
        }
        if ((bl || !this.restrictByPlayer) && PlayerRoster.isActive() && GameModule.getGameModule().getGameState().isGameStarted()) {
            bl = true;
            for (int i = 0; i < this.side.length; ++i) {
                if (!this.side[i].equals(PlayerRoster.getMySide())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void setProperty(Object object, Object object2) {
        if ("Selected".equals(object) && Boolean.TRUE.equals(object2) && this.restrictByPlayer && this.owningPlayer.length() == 0) {
            if (this.getMap() != null) {
                this.owningPlayer = GameModule.getUserId();
            } else {
                System.err.println("Selected, but map == null");
            }
        }
        super.setProperty(object, object2);
    }

    protected KeyCommand[] getKeyCommands() {
        if (!this.isRestricted()) {
            return super.getKeyCommands();
        }
        return new KeyCommand[0];
    }

    public Object getLocalizedProperty(Object object) {
        if ("Restricted".equals(object)) {
            return this.isRestricted();
        }
        if ("RestrictedMovement".equals(object)) {
            return this.isRestricted() && this.restrictMovement;
        }
        return super.getLocalizedProperty(object);
    }

    public Object getProperty(Object object) {
        if ("Restricted".equals(object)) {
            return this.isRestricted();
        }
        if ("RestrictedMovement".equals(object)) {
            return this.isRestricted() && this.restrictMovement;
        }
        return super.getProperty(object);
    }

    public String myGetState() {
        return this.owningPlayer;
    }

    public String myGetType() {
        return ID + new SequenceEncoder(';').append(this.side).append(this.restrictByPlayer).append(this.restrictMovement).getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public Command keyEvent(KeyStroke keyStroke) {
        if (!this.isRestricted()) {
            return super.keyEvent(keyStroke);
        }
        return null;
    }

    public void mySetState(String string) {
        this.owningPlayer = string;
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private static class RetirementHandler
    implements PlayerRoster.SideChangeListener,
    PieceVisitor {
        private RetirementHandler() {
        }

        public void sideChanged(String string, String string2) {
            if (string2 == null) {
                PieceVisitorDispatcher pieceVisitorDispatcher = new PieceVisitorDispatcher(this);
                Command command = new NullCommand();
                for (Map map : GameModule.getGameModule().getComponentsOf(Map.class)) {
                    for (GamePiece gamePiece : map.getPieces()) {
                        command = command.append((Command)pieceVisitorDispatcher.accept(gamePiece));
                    }
                }
                GameModule.getGameModule().sendAndLog(command);
            }
        }

        public Object visitDefault(GamePiece gamePiece) {
            Restricted restricted = (Restricted)Decorator.getDecorator(gamePiece, Restricted.class);
            if (restricted != null && restricted.restrictByPlayer && GameModule.getUserId().equals(restricted.owningPlayer)) {
                ChangeTracker changeTracker = new ChangeTracker(gamePiece);
                restricted.owningPlayer = "";
                return changeTracker.getChangeCommand();
            }
            return null;
        }

        public Object visitStack(Stack stack) {
            Command command = new NullCommand();
            Iterator<GamePiece> iterator = stack.getPiecesIterator();
            while (iterator.hasNext()) {
                command = command.append((Command)this.visitDefault(iterator.next()));
            }
            return command;
        }
    }

    public static class Ed
    implements PieceEditor {
        private BooleanConfigurer byPlayer;
        private StringArrayConfigurer config;
        private BooleanConfigurer movementConfig;
        private Box box;

        public Ed(Restricted restricted) {
            this.byPlayer = new BooleanConfigurer(null, "Also belongs to initially-placing player?", restricted.restrictByPlayer);
            this.config = new StringArrayConfigurer(null, "Belongs to side", restricted.side);
            this.movementConfig = new BooleanConfigurer(null, "Prevent non-owning players from moving piece?", restricted.restrictMovement);
            this.box = Box.createVerticalBox();
            ((JComponent)this.byPlayer.getControls()).setAlignmentX(0.0f);
            ((JComponent)this.movementConfig.getControls()).setAlignmentX(0.0f);
            this.box.add(this.config.getControls());
            this.box.add(this.byPlayer.getControls());
            this.box.add(this.movementConfig.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            return Restricted.ID + new SequenceEncoder(';').append(this.config.getValueString()).append(this.byPlayer.booleanValue()).append(this.movementConfig.booleanValue()).getValue();
        }
    }
}

